/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.google.common.base.Joiner;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssElementDescriptorBase
implements CssElementDescriptor {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    @NotNull
    private final CssCommonDescriptorData myCommonData;

    protected CssElementDescriptorBase(@NotNull CssCommonDescriptorData commonDescriptorData) {
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "<init>"));
        }
        this.myCommonData = commonDescriptorData;
    }

    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion cssVersion = this.myCommonData.cssVersion;
        if (cssVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getCssVersion"));
        }
        return cssVersion;
    }

    @NotNull
    public CssContextType[] getAllowedContextTypes() {
        if (this.myCommonData.allowedInRules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getAllowedContextTypes"));
        }
        return this.myCommonData.allowedInRules;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.myCommonData.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myCommonData.presentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public BrowserVersion[] getBrowsers() {
        if (this.myCommonData.browsers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getBrowsers"));
        }
        return this.myCommonData.browsers;
    }

    @Nullable
    public String getSpecificationUrl() {
        return this.myCommonData.specificationUrl;
    }

    @NotNull
    public String getDescription() {
        String string = this.myCommonData.description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.element", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "getElementTypeName"));
        }
        return string;
    }

    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "isAllowedInContextType"));
        }
        if (contextType == CssContextType.ANY) {
            return true;
        }
        for (CssContextType rule : this.myCommonData.allowedInRules) {
            if (rule != contextType && (!contextType.isSubsetOfAny() || rule != CssContextType.ANY)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        StringBuilder builder = new StringBuilder();
        DocumentationUtil.formatEntityName((String)this.getElementTypeName(), (String)this.getPresentableName(), (StringBuilder)builder);
        this.fillWithAttributesDescription(builder);
        String description = this.getDescription();
        if (!description.isEmpty()) {
            builder.append("<br/>").append(description);
        }
        return builder.toString();
    }

    protected void fillWithAttributesDescription(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase", "fillWithAttributesDescription"));
        }
        this.fillSpecificationString(builder).append("<br/>");
        builder.append("Allowed in: ").append(COMMA_JOINER.join((Object[])this.myCommonData.allowedInRules)).append("<br/>");
        if (this.myCommonData.browsers.length > 0) {
            builder.append("Supported browsers: ").append(COMMA_JOINER.join((Object[])this.myCommonData.browsers)).append("<br/>");
        }
    }

    private StringBuilder fillSpecificationString(StringBuilder builder) {
        CssElementDescriptor.CssVersion cssVersion = this.getCssVersion();
        if (cssVersion == CssElementDescriptor.CssVersion.UNKNOWN && this.myCommonData.specificationUrl == null) {
            return builder;
        }
        builder.append("Specification: ");
        if (this.myCommonData.specificationUrl != null) {
            String linkName = cssVersion == CssElementDescriptor.CssVersion.UNKNOWN ? "link" : cssVersion.getPresentableName();
            builder.append("<a href=\"").append(this.myCommonData.specificationUrl).append("\">").append(linkName).append("</a>");
        } else {
            builder.append(cssVersion.getPresentableName());
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssElementDescriptorBase)) {
            return false;
        }
        CssElementDescriptorBase base = (CssElementDescriptorBase)o;
        return this.myCommonData.equals(base.myCommonData);
    }

    public int hashCode() {
        return this.myCommonData.hashCode();
    }
}

