/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.structure;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssTreeModel;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssStructureViewExtension
implements StructureViewExtension {
    private static final StructureViewTreeElement[] EMPTY_ELEMENTS = new StructureViewTreeElement[0];

    public Class<? extends PsiElement> getType() {
        return XmlTag.class;
    }

    public StructureViewTreeElement[] getChildren(PsiElement parent) {
        CssStylesheet stylesheet = CssStructureViewExtension.findStyleSheet(parent, true);
        if (stylesheet != null) {
            return CssStructureViewElement.create((PsiElement)stylesheet).getChildren();
        }
        return EMPTY_ELEMENTS;
    }

    public Object getCurrentEditorElement(Editor editor, PsiElement parent) {
        CssStylesheet stylesheet = CssStructureViewExtension.findStyleSheet(parent, false);
        if (stylesheet != null) {
            PsiFile file = stylesheet.getContainingFile();
            if (InjectedLanguageManager.getInstance((Project)stylesheet.getProject()).isInjectedFragment(file)) {
                editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file);
            }
            return new CssTreeModel(stylesheet, editor).getCurrentEditorElement();
        }
        return null;
    }

    @Nullable
    private static CssStylesheet findStyleSheet(PsiElement parent, boolean respectFileReferences) {
        CssStylesheet stylesheet = null;
        XmlTag xmlTag = (XmlTag)parent;
        String name = xmlTag.getLocalName();
        if (respectFileReferences && "Style".equals(xmlTag.getLocalName()) && ("http://www.adobe.com/2006/mxml".equals(xmlTag.getNamespace()) || "http://ns.adobe.com/mxml/2009".equals(xmlTag.getNamespace()))) {
            PsiFile includedFile;
            XmlAttribute sourceAttribute = xmlTag.getAttribute("source");
            PsiFile psiFile = includedFile = sourceAttribute == null ? null : FileReferenceUtil.findFile((PsiElement)sourceAttribute.getValueElement());
            if (includedFile instanceof StylesheetFile) {
                return ((StylesheetFile)includedFile).getStylesheet();
            }
        }
        if ("style".equalsIgnoreCase(name) && (stylesheet = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)xmlTag, CssStylesheet.class)) == null) {
            final StylesheetFile[] injectedFile = new StylesheetFile[1];
            for (XmlTagChild c : xmlTag.getValue().getChildren()) {
                if (!(c instanceof PsiLanguageInjectionHost)) continue;
                InjectedLanguageUtil.enumerate((PsiElement)c, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/css/impl/structure/CssStructureViewExtension$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/psi/css/impl/structure/CssStructureViewExtension$1", "visit"));
                        }
                        if (injectedPsi instanceof StylesheetFile) {
                            injectedFile[0] = (StylesheetFile)injectedPsi;
                        }
                    }
                });
            }
            if (injectedFile[0] != null) {
                stylesheet = injectedFile[0].getStylesheet();
            }
        }
        return stylesheet;
    }
}

