/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs.base;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CssSimpleNamedStubElementType<PsiT extends CssNamedElement>
extends CssNamedStubElementType<CssNamedStub<PsiT>, PsiT> {
    public CssSimpleNamedStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "<init>"));
        }
        super(debugName);
    }

    public CssSimpleNamedStubElementType(@NotNull @NonNls String debugName, @NotNull Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "<init>"));
        }
        super(debugName, language);
    }

    public void serialize(@NotNull CssNamedStub<PsiT> stub, @NotNull StubOutputStream stream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "serialize"));
        }
        stream.writeName(stub.getName());
        stream.writeInt(stub.getTextOffset());
    }

    public CssNamedStub<PsiT> createStub(@NotNull PsiT psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "createStub"));
        }
        return new CssNamedStub(parentStub, (IStubElementType)this, StringUtil.notNullize((String)psi.getName()), psi.getTextOffset());
    }

    @NotNull
    public CssNamedStub<PsiT> deserialize(@NotNull StubInputStream stream, StubElement parentStub) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "deserialize"));
        }
        CssNamedStub cssNamedStub = new CssNamedStub(parentStub, (IStubElementType)this, stream.readName(), stream.readInt());
        if (cssNamedStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/base/CssSimpleNamedStubElementType", "deserialize"));
        }
        return cssNamedStub;
    }
}

