/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssAttributeRSide;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyIndex;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.impl.util.completion.CssDumbAwareCompletionContributor;
import com.intellij.psi.css.impl.util.completion.ImageSizeCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssHtmlAttributeNameCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssHtmlAttributeValueCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssSelectorSuffixCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.KeyframesNameCompletionProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssCompletionContributor
extends CompletionContributor {
    public CssCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)CssCompletionContributor.attributeName(), new CssHtmlAttributeNameCompletionProvider());
        this.extend(CompletionType.BASIC, CssCompletionContributor.attributeValue(), new CssHtmlAttributeValueCompletionProvider());
        this.extend(CompletionType.BASIC, CssCompletionContributor.className(), new CssSelectorSuffixCompletionProvider(CssSelectorSuffixType.CLASS));
        this.extend(CompletionType.BASIC, CssCompletionContributor.identifierName(), new CssSelectorSuffixCompletionProvider(CssSelectorSuffixType.ID));
        this.extend(CompletionType.BASIC, (ElementPattern)CssCompletionContributor.propertyValue(), new ImageSizeCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)CssCompletionContributor.keyframesName(), new KeyframesNameCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)CssCompletionContributor.animationName(), new KeyframesNameCompletionProvider());
    }

    private static ElementPattern<? extends PsiElement> className() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent(CssClass.class)});
    }

    private static ElementPattern<? extends PsiElement> identifierName() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_HASH).withParent(CssIdSelector.class);
    }

    private static PsiElementPattern.Capture<PsiElement> attributeName() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent(CssAttribute.class);
    }

    private static ElementPattern<PsiElement> attributeValue() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent(CssAttributeRSide.class), PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_STRING_TOKEN).withSuperParent(2, CssAttributeRSide.class)});
    }

    private static PsiElementPattern.Capture<PsiElement> animationName() {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent(CssTerm.class)).inside((ElementPattern)PlatformPatterns.psiElement(CssDeclaration.class).withText((ElementPattern)StandardPatterns.string().contains("animation-name")));
    }

    private static PsiElementPattern.Capture<PsiElement> keyframesName() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_KEYFRAMES_SYM));
    }

    private static PsiElementPattern.Capture<PsiElement> propertyValue() {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(CssTerm.class)).inside(CssDeclaration.class);
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        CssSelectorSuffixType suffixType;
        CssAttribute attribute;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/CssCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/CssCompletionContributor", "fillCompletionVariants"));
        }
        result = CssDumbAwareCompletionContributor.fixPrefixForVendorPrefixes(parameters, result, new IElementType[0]);
        PsiElement position = parameters.getPosition();
        if (CssCompletionContributor.attributeValue().accepts((Object)position) && (attribute = (CssAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, CssAttribute.class)) != null && (suffixType = attribute.getType()) != CssSelectorSuffixType.UNKNOWN) {
            new CssSelectorSuffixCompletionProvider(suffixType).addCompletionVariants(parameters, new ProcessingContext(), result);
        }
        if (CssPsiUtil.isCustomVariableReference((PsiElement)position)) {
            PsiFile originalFile = parameters.getOriginalFile();
            GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement(position);
            Project project = position.getProject();
            for (String name : StubIndex.getInstance().getAllKeys(CssCustomPropertyIndex.KEY, project)) {
                Collection declarations = StubIndex.getElements(CssCustomPropertyIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssDeclaration.class);
                for (CssDeclaration declaration : declarations) {
                    result.addElement(CssCompletionUtil.lookupForCustomProperty(name, declaration, originalFile));
                }
            }
        }
        super.fillCompletionVariants(parameters, result);
    }
}

