/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.find;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class CssElementsSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected CssElementsSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, final @NotNull Processor<PsiReference> consumer) {
        EnumSet<PsiSearchHelperImpl.Options> options;
        String textToSearch;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/css/impl/util/find/CssElementsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/css/impl/util/find/CssElementsSearcher", "processQuery"));
        }
        PsiElement elementToSearch = p.getElementToSearch();
        if (elementToSearch instanceof CssSelectorSuffix) {
            textToSearch = ((CssSelectorSuffix)elementToSearch).getName();
            if (StringUtil.isEmpty((String)textToSearch)) {
                return;
            }
            options = EnumSet.of(PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);
        } else if (elementToSearch instanceof CssDeclaration && ((CssDeclaration)elementToSearch).isCustomProperty()) {
            textToSearch = ((CssDeclaration)elementToSearch).getName();
            if (StringUtil.isEmpty((String)textToSearch)) {
                return;
            }
            options = EnumSet.of(PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH, PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);
        } else {
            return;
        }
        SearchScope scope = p.getEffectiveSearchScope();
        final SingleTargetRequestResultProcessor singleTargetRequestResultProcessor = new SingleTargetRequestResultProcessor(elementToSearch);
        TextOccurenceProcessor processor = new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/find/CssElementsSearcher$1", "execute"));
                }
                return singleTargetRequestResultProcessor.processTextOccurrence(element, offsetInElement, consumer);
            }
        };
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)elementToSearch.getProject());
        if (helper instanceof PsiSearchHelperImpl) {
            ((PsiSearchHelperImpl)helper).processElementsWithWord(processor, scope, textToSearch, (short)255, options, null);
        } else {
            helper.processElementsWithWord(processor, scope, textToSearch, (short)255, true);
        }
    }
}

