/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.AfterElement;
import com.intellij.psi.filters.position.XmlTokenTypeFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssIdentifierReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private static final TokenSet FUNCTION_TYPES = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN, CssElementTypes.CSS_FUNCTION});
    private final PsiElement myElement;

    public CssIdentifierReference(PsiElement element) {
        this.myElement = element;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "resolveInner"));
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])this.findDeclarations());
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "resolveInner"));
        }
        return resolveResultArray;
    }

    private PsiElement[] findDeclarations() {
        CssPropertyDescriptor descriptor;
        CssDeclaration psiElement;
        if (CssUtil.isCssDeclaration(this.myElement)) {
            CssDeclaration parent = (CssDeclaration)this.myElement.getParent();
            CssPropertyDescriptor descriptor2 = parent.getDescriptor();
            if (descriptor2 != null) {
                PsiElement[] psiElementArray;
                PsiElement[] declaration = descriptor2.getDeclarations((PsiElement)parent);
                if (declaration.length > 0) {
                    psiElementArray = declaration;
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = parent;
                }
                return psiElementArray;
            }
        } else if (FUNCTION_TYPES.contains(this.myElement.getNode().getElementType()) && (psiElement = CssUtil.getDeclaration(this.myElement)) != null && (descriptor = CssDescriptorsUtil.getPropertyDescriptor((CssDeclaration)psiElement)) != null && descriptor.isValidValue(this.myElement)) {
            return new PsiElement[]{psiElement};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] results;
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(element, result.getElement())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (!CssUtil.isCssDeclaration(this.myElement) && !CssIdentifierReference.isAttribute(this.myElement)) {
            CssPropertyDescriptor descriptor;
            if (new AfterElement((ElementFilter)new XmlTokenTypeFilter(CssElementTypes.CSS_NUMBER)).isAcceptable((Object)this.myElement, null)) {
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            CssDeclaration declaration = CssUtil.getDeclaration(this.myElement);
            CssPropertyDescriptor cssPropertyDescriptor = descriptor = declaration != null ? declaration.getDescriptor() : null;
            if (descriptor != null) {
                Object[] objectArray = ContainerUtil.mapNotNull((Object[])descriptor.getVariants(this.myElement), (Function)new Function<Object, Object>(){

                    public Object fun(Object o) {
                        return CssCompletionUtil.valueLookupElement(o);
                    }
                }, (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "getVariants"));
                }
                return objectArray;
            }
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static boolean isAttribute(@Nullable PsiElement element) {
        return element != null && element.getParent() instanceof CssAttribute;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssIdentifierReference", "getUnresolvedMessagePattern"));
        }
        return "";
    }
}

