/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssIdValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssJavaScriptValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssPositionValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssSelectorValue;
import com.intellij.psi.css.impl.descriptor.value.CssSemitonesValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrangeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrlValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueDescriptorModificator {
    @NotNull
    public static CssValueDescriptor withParent(@NotNull CssValueDescriptor descriptor, @Nullable CssValueDescriptor newParent) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator", "withParent"));
        }
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(descriptor.isShowInCompletion(), descriptor.getMinOccur(), descriptor.getMaxOccur(), descriptor.getObsoleteVersion(), descriptor.getObsoleteTooltip(), newParent, descriptor.getExclusion(), descriptor.isCommaSeparated());
        CssValueDescriptor cssValueDescriptor = CssValueDescriptorModificator.create(descriptor, valueDescriptorData, CssValueDescriptorModificator.copyCommonData(descriptor));
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator", "withParent"));
        }
        return cssValueDescriptor;
    }

    @NotNull
    public static CssValueDescriptor withQuantifiers(@NotNull CssValueDescriptor descriptor, int minOccur, int maxOccur, boolean commaSeparated) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator", "withQuantifiers"));
        }
        if (minOccur == descriptor.getMinOccur() && maxOccur == descriptor.getMaxOccur() && commaSeparated == descriptor.isCommaSeparated()) {
            CssValueDescriptor cssValueDescriptor = descriptor;
            if (cssValueDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator", "withQuantifiers"));
            }
            return cssValueDescriptor;
        }
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(descriptor.isShowInCompletion(), minOccur, maxOccur, descriptor.getObsoleteVersion(), descriptor.getObsoleteTooltip(), descriptor.getParent(), descriptor.getExclusion(), commaSeparated);
        CssValueDescriptor cssValueDescriptor = CssValueDescriptorModificator.create(descriptor, valueDescriptorData, CssValueDescriptorModificator.copyCommonData(descriptor));
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator", "withQuantifiers"));
        }
        return cssValueDescriptor;
    }

    private static CssCommonDescriptorData copyCommonData(CssValueDescriptor descriptor) {
        return new CssCommonDescriptorData(descriptor.getId(), descriptor.getPresentableName(), descriptor.getAllowedContextTypes(), descriptor.getBrowsers(), descriptor.getCssVersion(), descriptor.getSpecificationUrl(), descriptor.getDescription());
    }

    @NotNull
    private static CssValueDescriptor create(CssValueDescriptor descriptor, CssValueDescriptorData valueDescriptorData, CssCommonDescriptorData commonDescriptorData) {
        Ref result = new Ref();
        descriptor.accept((CssValueDescriptorVisitor)new ValueFactory((Ref<CssValueDescriptor>)result, commonDescriptorData, valueDescriptorData));
        assert (!result.isNull());
        CssValueDescriptor cssValueDescriptor = (CssValueDescriptor)result.get();
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator", "create"));
        }
        return cssValueDescriptor;
    }

    private static class ValueFactory
    extends CssValueDescriptorVisitorImpl {
        private final Ref<CssValueDescriptor> myResult;
        private final CssCommonDescriptorData myCommonDescriptorData;
        private final CssValueDescriptorData myValueDescriptorData;

        public ValueFactory(Ref<CssValueDescriptor> result, CssCommonDescriptorData commonDescriptorData, CssValueDescriptorData valueDescriptorData) {
            this.myResult = result;
            this.myCommonDescriptorData = commonDescriptorData;
            this.myValueDescriptorData = valueDescriptorData;
        }

        @Override
        public void visitAngleValue(@NotNull CssAngleValue angleValue) {
            if (angleValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "angleValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitAngleValue"));
            }
            this.myResult.set((Object)new CssAngleValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitAnyValue(@NotNull CssAnyValue anyValue) {
            if (anyValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anyValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitAnyValue"));
            }
            this.myResult.set((Object)new CssAnyValueImpl(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitColorValue(@NotNull CssColorValue colorValue) {
            if (colorValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitColorValue"));
            }
            this.myResult.set((Object)new CssColorValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitExpressionValue(@NotNull CssExpressionValue expressionValue) {
            if (expressionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitExpressionValue"));
            }
            this.myResult.set((Object)new CssExpressionValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitFrequencyValue(@NotNull CssFrequencyValue frequencyValue) {
            if (frequencyValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frequencyValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitFrequencyValue"));
            }
            this.myResult.set((Object)new CssFrequencyValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
            if (functionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitFunctionValue"));
            }
            this.myResult.set((Object)new CssFunctionInvocationValue(functionValue.getFunctionName(), this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitGroupValue(@NotNull CssGroupValue groupValue) {
            if (groupValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitGroupValue"));
            }
            CssGroupValue newValue = CssGroupValue.create(this.myCommonDescriptorData, this.myValueDescriptorData, groupValue.isWhitespacesShouldBeIgnored(), groupValue.getValuesSeparator(), groupValue.getType());
            for (CssValueDescriptor valueDescriptor : groupValue.getChildren()) {
                newValue.addChild(CssValueDescriptorModificator.withParent(valueDescriptor, newValue));
            }
            this.myResult.set((Object)newValue);
        }

        @Override
        public void visitInlineValue(@NotNull CssInlineValue inlineValue) {
            if (inlineValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitInlineValue"));
            }
            this.myResult.set((Object)new CssInlineValue(inlineValue.getRefId(), this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitIntegerValue(@NotNull CssIntegerValue integerValue) {
            if (integerValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integerValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitIntegerValue"));
            }
            this.myResult.set((Object)new CssIntegerValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitJavaScriptValue(@NotNull CssJavaScriptValue javaScriptValue) {
            if (javaScriptValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaScriptValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitJavaScriptValue"));
            }
            this.myResult.set((Object)new CssJavaScriptValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitLengthValue(@NotNull CssLengthValue lengthValue) {
            if (lengthValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengthValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitLengthValue"));
            }
            this.myResult.set((Object)new CssLengthValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitNameValue(@NotNull CssNameValue nameValue) {
            if (nameValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitNameValue"));
            }
            this.myResult.set((Object)new CssNameValue(nameValue.getValue(), nameValue.isCaseSensitive(), this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitNumberValue(@NotNull CssNumberValue numberValue) {
            if (numberValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitNumberValue"));
            }
            this.myResult.set((Object)new CssNumberValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitPercentageValue(@NotNull CssPercentageValue percentageValue) {
            if (percentageValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "percentageValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitPercentageValue"));
            }
            this.myResult.set((Object)new CssPercentageValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitPositionValue(@NotNull CssPositionValue positionValue) {
            if (positionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positionValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitPositionValue"));
            }
            this.myResult.set((Object)new CssPositionValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitPropertyReferenceValue(@NotNull CssPropertyReferenceValue propertyReferenceValue) {
            if (propertyReferenceValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReferenceValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitPropertyReferenceValue"));
            }
            this.myResult.set((Object)new CssPropertyReferenceValue(propertyReferenceValue.getPropertyName(), this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitResolutionValue(@NotNull CssResolutionValue resolutionValue) {
            if (resolutionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitResolutionValue"));
            }
            this.myResult.set((Object)new CssResolutionValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitSelectorValue(@NotNull CssSelectorValue selectorValue) {
            if (selectorValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitSelectorValue"));
            }
            this.myResult.set((Object)new CssSelectorValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitStringValue(@NotNull CssStringValue stringValue) {
            if (stringValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitStringValue"));
            }
            this.myResult.set((Object)new CssStringValue(stringValue.getValue(), this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitTextValue(@NotNull CssTextValue textValue) {
            if (textValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitTextValue"));
            }
            this.myResult.set((Object)new CssTextValue(textValue.getValue(), this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitTimeValue(@NotNull CssTimeValue timeValue) {
            if (timeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitTimeValue"));
            }
            this.myResult.set((Object)new CssTimeValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitUrangeValue(@NotNull CssUrangeValue urangeValue) {
            if (urangeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urangeValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitUrangeValue"));
            }
            this.myResult.set((Object)new CssUrangeValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitUrlValue(@NotNull CssUrlValue urlValue) {
            if (urlValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitUrlValue"));
            }
            this.myResult.set((Object)new CssUrlValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitDecibelValue(@NotNull CssDecibelValue decibelValue) {
            if (decibelValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decibelValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitDecibelValue"));
            }
            this.myResult.set((Object)new CssDecibelValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitSemitonesValue(@NotNull CssSemitonesValue semitoneValue) {
            if (semitoneValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semitoneValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitSemitonesValue"));
            }
            this.myResult.set((Object)new CssSemitonesValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }

        @Override
        public void visitIdValue(@NotNull CssIdValue idValue) {
            if (idValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idValue", "com/intellij/psi/css/impl/util/scheme/CssValueDescriptorModificator$ValueFactory", "visitIdValue"));
            }
            this.myResult.set((Object)new CssIdValue(this.myCommonDescriptorData, this.myValueDescriptorData));
        }
    }
}

