/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCssFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public abstract String getId();

    public abstract boolean acceptFile(VirtualFile var1);

    public abstract void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> var1);

    @NotNull
    public final FileIncludeInfo[] getIncludeInfos(FileContent inputData) {
        if (!this.hasImports(inputData.getContentAsText())) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/include/AbstractCssFileIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList result = ContainerUtil.newArrayList();
        final VirtualFile hostFile = inputData.getFile();
        final String hostFileExt = StringUtil.notNullize((String)hostFile.getExtension());
        inputData.getPsiFile().accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitCssImport(CssImport cssImport) {
                for (String uri : cssImport.getUriStrings()) {
                    if (!AbstractCssFileIncludeProvider.canBeResolvedToLocalFile(uri)) continue;
                    String uriExt = FileUtilRt.getExtension((String)uri);
                    AbstractCssFileIncludeProvider.this.addImports(result, hostFile, hostFileExt, uri, uriExt);
                }
            }

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        FileIncludeInfo[] fileIncludeInfoArray = result.toArray(new FileIncludeInfo[result.size()]);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/include/AbstractCssFileIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }

    private static boolean canBeResolvedToLocalFile(@NotNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/psi/css/include/AbstractCssFileIncludeProvider", "canBeResolvedToLocalFile"));
        }
        return !HtmlUtil.hasHtmlPrefix((String)uri) && !uri.startsWith("\\\\");
    }

    protected boolean hasImports(@NotNull CharSequence hostFileText) {
        if (hostFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileText", "com/intellij/psi/css/include/AbstractCssFileIncludeProvider", "hasImports"));
        }
        return CharArrayUtil.indexOf((CharSequence)hostFileText, (CharSequence)"@import", (int)0) >= 0;
    }

    protected abstract void addImports(@NotNull List<FileIncludeInfo> var1, @NotNull VirtualFile var2, @NotNull String var3, @NotNull String var4, @NotNull String var5);
}

