/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssUnknownPropertyInspectionBase
extends CssBaseInspection {
    @NonNls
    public static final Key<CssUnknownPropertyInspectionBase> SHORT_NAME_KEY = Key.create((String)"CssUnknownProperty");
    protected static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.css.inspections.CssUnknownPropertyInspection");
    public boolean myCustomPropertiesEnabled;
    public boolean myIgnoreVendorSpecificProperties;
    public JDOMExternalizableStringList myCustomPropertiesList = new JDOMExternalizableStringList();
    protected JCheckBox myIgnoreVendorSpecificPropertiesCheckBox;
    protected JCheckBox myCheckBox;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.unknown.property", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase", "buildVisitor"));
        }
        UnknownPropertyVisitor unknownPropertyVisitor = new UnknownPropertyVisitor(holder);
        if (unknownPropertyVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase", "buildVisitor"));
        }
        return unknownPropertyVisitor;
    }

    protected String createPropertiesString() {
        StringBuilder buffer = new StringBuilder();
        for (String property : this.myCustomPropertiesList) {
            if (buffer.length() == 0) {
                buffer.append(property);
                continue;
            }
            buffer.append(',');
            buffer.append(property);
        }
        return buffer.toString();
    }

    public boolean isCustomProperty(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase", "isCustomProperty"));
        }
        return this.myCustomPropertiesList.contains((Object)property.toLowerCase(Locale.US));
    }

    public boolean isIgnoreVendorSpecificProperties() {
        return this.myIgnoreVendorSpecificProperties;
    }

    public boolean isCustomPropertiesEnabled() {
        return this.myCustomPropertiesEnabled;
    }

    public JDOMExternalizableStringList getCustomPropertiesList() {
        return this.myCustomPropertiesList;
    }

    protected void reparseProperties(@NotNull String properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase", "reparseProperties"));
        }
        this.myCustomPropertiesList = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            this.myCustomPropertiesList.add((Object)tokenizer.nextToken().toLowerCase(Locale.US).trim());
        }
    }

    public void addCustomPropertyName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase", "addCustomPropertyName"));
        }
        String s = text.trim().toLowerCase(Locale.US);
        if (!this.isCustomProperty(s)) {
            this.myCustomPropertiesList.add((Object)s);
        }
        if (!this.isCustomPropertiesEnabled()) {
            this.myCustomPropertiesEnabled = true;
        }
    }

    private static LocalQuickFix createUnknownPropertyFix(String postfix) {
        return CssFixFactory.getInstance().cssUnknownPropertyIntentionAction(postfix);
    }

    private class UnknownPropertyVisitor
    extends CssElementVisitor {
        private final ProblemsHolder myHolder;

        public UnknownPropertyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitCssDeclaration(CssDeclaration declaration) {
            if (declaration.isCustomProperty()) {
                return;
            }
            PsiElement propertyNameElement = declaration.getPropertyNameElement();
            if (propertyNameElement == null) {
                return;
            }
            Collection descriptors = declaration.getDescriptors();
            if (!descriptors.isEmpty()) {
                descriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, propertyNameElement, this.myHolder);
                CssInspectionsUtil.filterDescriptorsByMediaTypeAndCheck(descriptors, propertyNameElement, this.myHolder);
                return;
            }
            if (declaration.getDescriptor() != null) {
                return;
            }
            if (!CssInspectionsUtil.isPureCssPropertyName(propertyNameElement)) {
                return;
            }
            if (!propertyNameElement.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE) || PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
                return;
            }
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)declaration);
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            boolean reportError = false;
            if (CssPropertyUtil.isVendorSpecificElement(propertyName)) {
                if (!CssUnknownPropertyInspectionBase.this.isIgnoreVendorSpecificProperties()) {
                    quickFixes.add(new CssIgnoreVendorSpecificPropertiesQuickFix());
                    String postfix = CssPropertyUtil.getElementNameWithoutVendorPrefix(propertyName);
                    if (this.isReallyUnknownProperty(declaration, postfix)) {
                        propertyName = postfix;
                        quickFixes.add(CssUnknownPropertyInspectionBase.createUnknownPropertyFix(postfix));
                        reportError = true;
                    } else {
                        reportError = false;
                    }
                }
            } else if (this.isReallyUnknownProperty(declaration, propertyName)) {
                quickFixes.add(CssUnknownPropertyInspectionBase.createUnknownPropertyFix(propertyName));
                reportError = true;
            }
            if (reportError) {
                quickFixes.addAll(CssDescriptorsUtil.getQuickFixesForUnknownProperty((String)propertyName, (PsiElement)declaration, (boolean)this.myHolder.isOnTheFly()));
                this.myHolder.registerProblem(propertyNameElement, CssBundle.message((String)"css.inspections.unknown.message", (Object[])new Object[]{propertyName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
            }
        }

        private boolean isReallyUnknownProperty(CssDeclaration declaration, String propertyName) {
            return (!CssUnknownPropertyInspectionBase.this.isCustomPropertiesEnabled() || !CssUnknownPropertyInspectionBase.this.isCustomProperty(propertyName)) && !this.isToIgnore(propertyName, declaration);
        }

        private boolean isToIgnore(String propertyName, CssDeclaration declaration) {
            return propertyName != null && declaration != null && propertyName.equals("src") && CssUtil.isInsideFontFace((PsiElement)declaration);
        }
    }

    private static class CssIgnoreVendorSpecificPropertiesQuickFix
    implements LocalQuickFix {
        private CssIgnoreVendorSpecificPropertiesQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = CssBundle.message((String)"css.unknown.vendor.property.fix.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
            profile.modifyToolSettings(SHORT_NAME_KEY, element, (Consumer)new Consumer<CssUnknownPropertyInspectionBase>(){

                public void consume(CssUnknownPropertyInspectionBase inspection) {
                    inspection.myIgnoreVendorSpecificProperties = true;
                }
            });
        }
    }
}

