/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class StylesheetFileReferenceSet
extends FileReferenceSet {
    private final Condition<PsiFileSystemItem> COMPLETION_FILTER;

    public StylesheetFileReferenceSet(@NotNull PsiElement element, @NotNull String referenceText, @NotNull TextRange textRange, FileType ... suitableFileTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "<init>"));
        }
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "<init>"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "<init>"));
        }
        super(referenceText, element, textRange.getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, true, suitableFileTypes);
        this.COMPLETION_FILTER = new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                if (item.isDirectory()) {
                    return true;
                }
                PsiElement element = StylesheetFileReferenceSet.this.getElement();
                if (!element.isValid() || item.equals(element.getContainingFile().getOriginalFile())) {
                    return false;
                }
                for (FileType type : StylesheetFileReferenceSet.this.getSuitableFileTypes()) {
                    if (item.getVirtualFile().getFileType() != type) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected boolean isSoft() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList result = ContainerUtil.newArrayList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)this.getCurrentDirectory());
        result.addAll(super.computeDefaultContexts());
        ContainerUtil.addAllNotNull((Collection)result, this.getJavaResourceRoots());
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "computeDefaultContexts"));
        }
        return arrayList;
    }

    @Nullable
    private PsiFileSystemItem getCurrentDirectory() {
        PsiFile file = this.getElement().getContainingFile();
        return file != null ? file.getParent() : null;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getJavaResourceRoots() {
        if (!PlatformUtils.isIdeaUltimate()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "getJavaResourceRoots"));
            }
            return list;
        }
        final PsiElement element = this.getElement();
        if (!element.isValid()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "getJavaResourceRoots"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "getJavaResourceRoots"));
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = ContainerUtil.map((Collection)moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE), (Function)new Function<VirtualFile, PsiFileSystemItem>(){

            public PsiFileSystemItem fun(VirtualFile file) {
                return FileReferenceHelper.getPsiFileSystemItem((PsiManager)element.getManager(), (VirtualFile)file);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet", "getJavaResourceRoots"));
        }
        return list;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return this.COMPLETION_FILTER;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new StylesheetFileReference(this, range, index, text);
    }
}

