/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve.impl;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.xml.util.HtmlLinkUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XhtmlFileInfo {
    private static final Key<CachedValue<XhtmlFileInfo>> XHTML_FILE_INFO = Key.create((String)"XhtmlFileInfo");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.resolve.impl.XhtmlFileInfo");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    private final XmlFile myXhtmlFile;
    private final long myModificationStamp;
    private final Pair[] myPairs;
    private CssStylesheet[] myStylesheets = new CssStylesheet[0];
    private CssStylesheet[] myAllStylesheets = new CssStylesheet[0];
    @NonNls
    private String[] myReferencedStylesheetNames;
    private int myPreferredCssStylesheetIndex = -1;
    private final Set<CssStylesheet> myReferencedStylesheets;
    private static final Key<CachedValue<CssStylesheet>> PREDEFINED_STYLESHEET = Key.create((String)"CssPredefinedStylesheet");
    @NonNls
    public static final String DEFAULT_STYLESHEET_FILE_NAME = "css2default_.css";
    @NonNls
    private static final String _INTERNAL_DEFAULT_CSS_NAME = "css2default.css.txt";
    private boolean myUseAgentStylesheet;
    private CssStylesheet myPredefinedStylesheet;
    @NonNls
    private static final Pattern CSS_SUFFIX_PATTERN = Pattern.compile(".css(\\?.*)?$");
    @NonNls
    private static final String TEXT_CSS_TYPE = "text/css";

    XhtmlFileInfo(XmlFile xhtmlFile) {
        assert (xhtmlFile != null);
        this.myXhtmlFile = xhtmlFile;
        this.myModificationStamp = xhtmlFile.getModificationStamp();
        this.myReferencedStylesheets = new HashSet<CssStylesheet>(2);
        this.initStylesheets();
        this.myPairs = this.getPairs();
    }

    @Nullable
    private static CssStylesheet getPredefinedStylesheet(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/resolve/impl/XhtmlFileInfo", "getPredefinedStylesheet"));
        }
        CachedValue cachedValue = (CachedValue)project.getUserData(PREDEFINED_STYLESHEET);
        if (cachedValue == null) {
            final PsiManager manager = PsiManager.getInstance((Project)project);
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)manager.getProject());
            cachedValue = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<CssStylesheet>(){

                public CachedValueProvider.Result<CssStylesheet> compute() {
                    PsiFile fileFromText;
                    String s = XhtmlFileInfo.loadDefaultCssContent();
                    if (s != null && (fileFromText = PsiFileFactory.getInstance((Project)manager.getProject()).createFileFromText(XhtmlFileInfo.DEFAULT_STYLESHEET_FILE_NAME, (FileType)CssFileType.INSTANCE, (CharSequence)s)) instanceof CssFile) {
                        CssFile cssFile = (CssFile)fileFromText;
                        return new CachedValueProvider.Result((Object)cssFile.getStylesheet(), new Object[]{ModificationTracker.NEVER_CHANGED});
                    }
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
            });
            project.putUserData(PREDEFINED_STYLESHEET, (Object)cachedValue);
        }
        return (CssStylesheet)cachedValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String loadDefaultCssContent() {
        InputStream stream = XhtmlFileInfo.class.getResourceAsStream(_INTERNAL_DEFAULT_CSS_NAME);
        if (stream == null) {
            LOG.error("Cannot open find internal default css file", new String[]{_INTERNAL_DEFAULT_CSS_NAME});
            return null;
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        try {
            String string = FileUtil.loadTextAndClose((Reader)streamReader);
            return string;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                streamReader.close();
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private void initStylesheets() {
        PsiElement[] linkUrls;
        this.myPredefinedStylesheet = XhtmlFileInfo.getPredefinedStylesheet(this.myXhtmlFile.getProject());
        this.myReferencedStylesheets.clear();
        try {
            linkUrls = XhtmlFileInfo.gatherLinks(this.myXhtmlFile, false);
        }
        catch (PsiInvalidElementAccessException e) {
            VirtualFile vFile = this.myXhtmlFile.getVirtualFile();
            if (vFile != null) {
                LOG.error((Object)LogMessageEx.createEvent((String)"InvalidElementAccess", (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)vFile)}));
            }
            throw e;
        }
        this.myStylesheets = this.getStylesheets(linkUrls, false);
        this.myReferencedStylesheetNames = new String[linkUrls.length];
        int nonQualifiedAlternateCount = 0;
        for (int i = 0; i < linkUrls.length; ++i) {
            boolean isAlternate;
            XmlTag tag = (XmlTag)linkUrls[i].getParent().getParent();
            String title = tag.getAttributeValue("title");
            String rel = tag.getAttributeValue("rel");
            boolean bl = isAlternate = rel != null && rel.contains("alternate");
            if (title == null && rel != null && isAlternate) {
                title = "alternate" + (++nonQualifiedAlternateCount != 1 ? String.valueOf(nonQualifiedAlternateCount) : "");
            }
            if (!isAlternate && title != null && this.myPreferredCssStylesheetIndex == -1) {
                this.myPreferredCssStylesheetIndex = i;
            }
            this.myReferencedStylesheetNames[i] = title == null ? "__$persistent$__" : title;
        }
        PsiElement[] allLinkUrls = XhtmlFileInfo.gatherLinks(this.myXhtmlFile, true);
        this.myAllStylesheets = this.getStylesheets(allLinkUrls, true);
    }

    public static PsiElement[] gatherLinks(XmlFile xhtmlFile, final boolean allMedias) {
        final ArrayList result = new ArrayList();
        HtmlLinkUtil.processLinks((XmlFile)xhtmlFile, (Processor)new Processor<XmlTag>(){

            public boolean process(XmlTag xmlTag) {
                XhtmlFileInfo.processLinkTag(xmlTag, result, allMedias);
                return true;
            }
        });
        return PsiUtilCore.toPsiElementArray(result);
    }

    private CssStylesheet[] getStylesheets(@NotNull PsiElement[] linkElements, boolean allMedias) {
        if (linkElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkElements", "com/intellij/psi/css/resolve/impl/XhtmlFileInfo", "getStylesheets"));
        }
        ArrayList<CssStylesheet> result = new ArrayList<CssStylesheet>();
        for (PsiElement element : linkElements) {
            this.findOneStyleSheet(element, result, (PsiFile)this.myXhtmlFile, true, allMedias);
        }
        return (CssStylesheet[])ArrayUtil.toObjectArray(result, CssStylesheet.class);
    }

    private static void processLinkTag(@NotNull XmlTag tag, @NotNull List<PsiElement> result, boolean allMedias) {
        XmlAttributeValue valueElement;
        XmlAttribute attribute;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/resolve/impl/XhtmlFileInfo", "processLinkTag"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/resolve/impl/XhtmlFileInfo", "processLinkTag"));
        }
        String type = tag.getAttributeValue("type");
        String href = tag.getAttributeValue("href");
        if (href == null) {
            return;
        }
        if (type == null && !CSS_SUFFIX_PATTERN.matcher(href).find()) {
            return;
        }
        String media = tag.getAttributeValue("media");
        HashSet mediaTypes = Sets.newHashSet((Iterable)COMMA_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)media).toUpperCase(Locale.US)));
        if ((type == null || TEXT_CSS_TYPE.equals(type)) && (allMedias || media == null || mediaTypes.contains(CssMediaType.SCREEN.toString()) || mediaTypes.contains(CssMediaType.ALL.toString())) && (attribute = tag.getAttribute("href")) != null && (valueElement = attribute.getValueElement()) != null) {
            result.add((PsiElement)valueElement);
        }
    }

    boolean isReferencedStyleSheet(CssStylesheet stylesheet) {
        return this.myReferencedStylesheets.contains(stylesheet);
    }

    @Nullable
    String getPreferredStylesheetName() {
        if (this.myPreferredCssStylesheetIndex == -1) {
            return null;
        }
        return this.myReferencedStylesheetNames[this.myPreferredCssStylesheetIndex];
    }

    public CssStylesheet[] getLinkStylesheets() {
        this.checkIfModified();
        return this.getLinkStylesheets(this.myUseAgentStylesheet, false);
    }

    public CssStylesheet[] getAllLinkStylesheets() {
        this.checkIfModified();
        return this.getLinkStylesheets(this.myUseAgentStylesheet, true);
    }

    private CssStylesheet[] getLinkStylesheets(boolean withAgentStylesheet, boolean allMedias) {
        CssStylesheet[] stylesheets;
        CssStylesheet[] cssStylesheetArray = stylesheets = allMedias ? this.myAllStylesheets : this.myStylesheets;
        if (!withAgentStylesheet || this.myPredefinedStylesheet == null) {
            return stylesheets;
        }
        ArrayList<CssStylesheet> result = new ArrayList<CssStylesheet>(Arrays.asList(stylesheets));
        result.add(0, this.myPredefinedStylesheet);
        return result.toArray(new CssStylesheet[result.size()]);
    }

    @NonNls
    String[] getReferencedStylesheetNames() {
        this.checkIfModified();
        return this.myReferencedStylesheetNames;
    }

    private void checkIfModified() {
        boolean modified = false;
        if (this.myModificationStamp != this.myXhtmlFile.getModificationStamp()) {
            modified = true;
        } else {
            for (Pair pair : this.myPairs) {
                if (pair.getModificationStamp() == pair.getFile().getModificationStamp()) continue;
                modified = true;
                break;
            }
        }
        if (modified) {
            this.initStylesheets();
        }
    }

    private void findOneStyleSheet(PsiElement linkUrl, List<CssStylesheet> collection, PsiFile base, boolean referenced, boolean allMedias) {
        StylesheetFile file = null;
        if (linkUrl instanceof StylesheetFile) {
            file = (StylesheetFile)linkUrl;
        } else {
            PsiFile[] psiFiles = linkUrl instanceof CssImport ? ((CssImport)linkUrl).resolve() : CssResolveManager.getInstance().resolveFiles(linkUrl, base);
            for (PsiFile psiFile : psiFiles) {
                if (!(psiFile instanceof StylesheetFile)) continue;
                file = (StylesheetFile)psiFile;
                break;
            }
        }
        if (file == null) {
            return;
        }
        CssStylesheet stylesheet = file.getStylesheet();
        if (stylesheet == null || collection.contains(stylesheet)) {
            return;
        }
        if (referenced) {
            this.myReferencedStylesheets.add(stylesheet);
        }
        collection.add(stylesheet);
        for (CssImport anImport : stylesheet.getImports()) {
            if (!allMedias && !anImport.isScreen()) continue;
            this.findOneStyleSheet((PsiElement)anImport, collection, (PsiFile)file, false, allMedias);
        }
    }

    private Pair[] getPairs() {
        ArrayList<Pair> collection = new ArrayList<Pair>();
        for (CssStylesheet myStylesheet : this.myStylesheets) {
            PsiFile containingFile = myStylesheet.getContainingFile();
            collection.add(new Pair(containingFile, containingFile.getModificationStamp()));
        }
        return (Pair[])ArrayUtil.toObjectArray(collection, Pair.class);
    }

    public void setUseAgentStyleSheet(boolean useAgentStylesheet) {
        this.myUseAgentStylesheet = useAgentStylesheet;
    }

    @Nullable
    public static XhtmlFileInfo getInfo(final @NotNull XmlFile file, boolean useAgentStylesheets) {
        XhtmlFileInfo info;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/resolve/impl/XhtmlFileInfo", "getInfo"));
        }
        CachedValue cachedValue = (CachedValue)file.getUserData(XHTML_FILE_INFO);
        if (cachedValue == null) {
            Project project = file.getProject();
            PsiManager manager = PsiManager.getInstance((Project)project);
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)manager.getProject());
            cachedValue = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<XhtmlFileInfo>(){

                public CachedValueProvider.Result<XhtmlFileInfo> compute() {
                    CssStylesheet[] stylesheets;
                    XhtmlFileInfo info = new XhtmlFileInfo(file);
                    HashSet<PsiFile> stylesheetFiles = new HashSet<PsiFile>();
                    for (CssStylesheet stylesheet : stylesheets = info.getAllLinkStylesheets()) {
                        stylesheetFiles.add(stylesheet.getContainingFile());
                    }
                    Object[] dependencies = ArrayUtil.toObjectArray(stylesheetFiles);
                    return new CachedValueProvider.Result((Object)info, new Object[]{file, dependencies});
                }
            }, false);
            file.putUserData(XHTML_FILE_INFO, (Object)cachedValue);
        }
        if ((info = (XhtmlFileInfo)cachedValue.getValue()) != null) {
            info.setUseAgentStyleSheet(useAgentStylesheets);
        }
        return info;
    }

    public int getLinksCount() {
        return this.myStylesheets.length;
    }

    public int getAllLinksCount() {
        return this.myAllStylesheets.length;
    }

    private static final class Pair {
        private final PsiFile myFile;
        private final long myModificationStamp;

        private Pair(PsiFile file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
        }

        private PsiFile getFile() {
            return this.myFile;
        }

        private long getModificationStamp() {
            return this.myModificationStamp;
        }
    }
}

