/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.ConnectionOwnerFactory;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(RemoteTransfer.class);
    @NonNls
    private static final String VERSION_FILE = "build.txt";
    private static final Function<String, VirtualFile> PATH_TO_VFILE = new Function<String, VirtualFile>(){

        @Nullable
        public VirtualFile apply(String path) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
    };
    @Nullable
    private final Project myProject;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    @Nullable
    private final RemoteSdkCredentials myRemoteSdkCredentials;
    @NotNull
    private final HelpersTransferConfig myHelpersTransferConfig;
    private boolean myTransferTaskModal;

    private RemoteTransfer(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull HelpersTransferConfig helpersTransferConfig, @Nullable RemoteSdkCredentials remoteSdkCredentials) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "<init>"));
        }
        if (helpersTransferConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersTransferConfig", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "<init>"));
        }
        this.myTransferTaskModal = true;
        this.myProject = project;
        this.myConnectionOwner = connectionOwner;
        this.myRemoteSdkCredentials = remoteSdkCredentials;
        this.myHelpersTransferConfig = helpersTransferConfig;
    }

    @Deprecated
    protected RemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials remoteSdkCredentials) {
        if (remoteSdkCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentials", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "<init>"));
        }
        this(project, ConnectionOwnerFactory.createConnectionOwner(project, component), RemoteSdkUtil.newHelpersTransferConfigFromRemoteCredentials(remoteSdkCredentials), remoteSdkCredentials);
    }

    protected RemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull HelpersTransferConfig helpersTransferConfig) {
        if (helpersTransferConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersTransferConfig", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "<init>"));
        }
        this(project, ConnectionOwnerFactory.createConnectionOwner(project, component), helpersTransferConfig, null);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Deprecated
    @NotNull
    public RemoteSdkCredentials getRemoteSdkCredentials() {
        if (this.myRemoteSdkCredentials == null) {
            throw new IllegalStateException("Remote SDK credentials are absent");
        }
        RemoteSdkCredentials remoteSdkCredentials = this.myRemoteSdkCredentials;
        if (remoteSdkCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "getRemoteSdkCredentials"));
        }
        return remoteSdkCredentials;
    }

    @NotNull
    public HelpersTransferConfig getHelpersTransferConfig() {
        HelpersTransferConfig helpersTransferConfig = this.myHelpersTransferConfig;
        if (helpersTransferConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "getHelpersTransferConfig"));
        }
        return helpersTransferConfig;
    }

    protected void uploadHelpers(boolean uploadOnSnapshot, @NotNull Collection<String> helpersPaths, @NotNull String remoteHelperPath, @NotNull String title) {
        if (helpersPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersPaths", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "uploadHelpers"));
        }
        if (remoteHelperPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteHelperPath", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "uploadHelpers"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "uploadHelpers"));
        }
        this.uploadHelpers(uploadOnSnapshot, helpersPaths, remoteHelperPath, title, false);
    }

    protected void uploadHelpers(final boolean uploadOnSnapshot, final @NotNull Collection<String> helpersPaths, final @NotNull String remoteHelperPath, final @NotNull String title, boolean cancellable) {
        if (helpersPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersPaths", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "uploadHelpers"));
        }
        if (remoteHelperPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteHelperPath", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "uploadHelpers"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "uploadHelpers"));
        }
        if (this.myHelpersTransferConfig.isHelpersVersionChecked() && !uploadOnSnapshot) {
            return;
        }
        LOG.info("Uploading helpers to " + remoteHelperPath);
        final Task process = this.createTask(this.myProject, title, cancellable, new Progressive(){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$2", "run"));
                }
                RemoteTransfer.this.doCopyHelpers(indicator, title, uploadOnSnapshot, helpersPaths, remoteHelperPath);
            }
        });
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run(process);
                }
            });
        } else {
            process.run(ProgressManager.getInstance().getProgressIndicator());
        }
    }

    @NotNull
    protected Task createTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, final @NotNull Progressive progressive) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createTask"));
        }
        if (progressive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressive", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createTask"));
        }
        if (this.isTransferTaskModal()) {
            Task.Modal modal = new Task.Modal(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$4", "run"));
                    }
                    progressive.run(indicator);
                }
            };
            if (modal == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createTask"));
            }
            return modal;
        }
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, title, canBeCancelled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$5", "run"));
                }
                progressive.run(indicator);
            }
        };
        if (backgroundable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createTask"));
        }
        return backgroundable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyHelpers(ProgressIndicator indicator, String title, boolean uploadOnSnapshot, Collection<String> helpersPaths, String remoteHelperPath) {
        FileTransferConfig fileTransferConfig = this.myHelpersTransferConfig.createFileTransferConfig();
        WebServerConfig webServerConfig = new WebServerConfig();
        webServerConfig.setFileTransferConfig(fileTransferConfig);
        webServerConfig.setId("UploadHelpers" + webServerConfig.toString());
        RemoteConnection connection = null;
        try {
            indicator.setFraction(0.0);
            connection = this.openConnection(title, webServerConfig, indicator);
            RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, webServerConfig);
            context.setPromptForOverwrite(true);
            if (RemoteTransfer.helpersUpdateNeeded(indicator, connection, this.getHelpersTransferConfig().getHelpersPath(), uploadOnSnapshot)) {
                context.getConfig().setPathMappings(webServerConfig.getId(), RemoteTransfer.createMapping(helpersPaths, remoteHelperPath));
                context.getConfig().setExcludedPaths(webServerConfig.getId(), this.getExcludedHelpersPaths(helpersPaths));
                try {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles((ExecutionContext)context, (Collection)Collections2.transform(helpersPaths, PATH_TO_VFILE));
                    ArrayList operations = Lists.newArrayList((Iterable)resultWithErrors.operations);
                    TransferOperation copyVersion = RemoteTransfer.writeHelpersVersion(connection, this.getHelpersTransferConfig().getHelpersPath());
                    if (copyVersion != null) {
                        operations.add(copyVersion);
                    }
                    RemoteTransfer.executeOperationsBatch(indicator, context, operations);
                }
                catch (ProcessCanceledException cancelled) {
                    throw cancelled;
                }
                catch (Exception e) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LOG.error("Can't copy helpers", (Throwable)e);
                            Messages.showErrorDialog((String)e.getMessage(), (String)"Error Copying Helpers");
                        }
                    });
                }
            }
            LOG.info("Helpers upload successfully completed");
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            if (PublishUtils.isAuthFail((Throwable)e)) {
                PublishUtils.clearPasswordIfNotStored((FileTransferConfig)webServerConfig.getFileTransferConfig());
            }
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        this.myHelpersTransferConfig.setHelpersVersionChecked(true);
    }

    protected final RemoteConnection openConnection(@NotNull String title, @NotNull WebServerConfig webServerConfig, @Nullable ProgressIndicator indicator) throws FileSystemException {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "openConnection"));
        }
        if (webServerConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webServerConfig", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "openConnection"));
        }
        return RemoteConnectionManager.getInstance().openConnection(this.myConnectionOwner, title, webServerConfig, FileTransferConfig.Origin.Default, null, indicator);
    }

    protected RemoteSdkExecutionContext getRemoteSdkExecutionContext(ProgressIndicator indicator, RemoteConnection connection, WebServerConfig webServerConfig) {
        return new RemoteSdkExecutionContext(this.myProject, indicator, webServerConfig, connection);
    }

    private static boolean helpersUpdateNeeded(@NotNull ProgressIndicator indicator, @NotNull RemoteConnection connection, @NotNull String helpersPath, boolean updateOnSnapshot) throws FileSystemException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "helpersUpdateNeeded"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "helpersUpdateNeeded"));
        }
        if (helpersPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersPath", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "helpersUpdateNeeded"));
        }
        FileObject versionFile = RemoteTransfer.getVersionFileObject(connection, helpersPath);
        connection.getFileSystem().resolveFile(connection.getRootName()).resolveFile(new RemoteFile(helpersPath, VERSION_FILE).getPath());
        try {
            String content = new String(FileTransferUtil.getContent((FileObject)versionFile, (ProgressIndicator)indicator));
            String localContent = RemoteTransfer.getLocalVersion();
            LOG.info("Remote helpers version is " + content + ", local helpers version is " + localContent);
            if (content.length() > 0) {
                return !localContent.equals(content) || localContent.endsWith(".SNAPSHOT") && updateOnSnapshot;
            }
        }
        catch (IOException e) {
            LOG.info("Failed to retrieve helpers version file", (Throwable)e);
        }
        return true;
    }

    private static String getLocalVersion() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    @Nullable
    private static TransferOperation writeHelpersVersion(@NotNull RemoteConnection connection, @NotNull String helpersPath) throws FileSystemException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "writeHelpersVersion"));
        }
        if (helpersPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersPath", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "writeHelpersVersion"));
        }
        final FileObject target = RemoteTransfer.getVersionFileObject(connection, helpersPath);
        return new TransferOperation(){

            public String getProgressText(ExecutionContext context) {
                return "Writing version file";
            }

            public String getDetailedText(ExecutionContext context) {
                return "Writing to " + target.getName();
            }

            public void execute(ExecutionContext context) throws FileSystemException {
                if (!target.exists()) {
                    target.createFile();
                }
                try (PrintWriter pw = new PrintWriter(target.getContent().getOutputStream());){
                    pw.print(RemoteTransfer.getLocalVersion());
                }
            }

            public String getErrorMessage(ExecutionContext context, String reason) {
                return "Can't write helpers version";
            }

            public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
            }
        };
    }

    private static FileObject getVersionFileObject(@NotNull RemoteConnection connection, @NotNull String helpersPath) throws FileSystemException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "getVersionFileObject"));
        }
        if (helpersPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersPath", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "getVersionFileObject"));
        }
        return connection.getFileSystem().resolveFile(connection.getRootName()).resolveFile(helpersPath).resolveFile(VERSION_FILE);
    }

    @NotNull
    private static List<DeploymentPathMapping> createMapping(@NotNull Collection<String> paths, final @NotNull String remotePath) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createMapping"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createMapping"));
        }
        Collection mappings = Collections2.transform(paths, (Function)new Function<String, DeploymentPathMapping>(){

            public DeploymentPathMapping apply(String path) {
                DeploymentPathMapping mapping = new DeploymentPathMapping();
                mapping.setLocalPath(path);
                mapping.setDeployPath(remotePath);
                return mapping;
            }
        });
        ArrayList arrayList = Lists.newArrayList((Iterable)mappings);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "createMapping"));
        }
        return arrayList;
    }

    public static void executeOperationsBatch(@NotNull ProgressIndicator indicator, RemoteSdkExecutionContext context, List<TransferOperation> operations) throws FileSystemException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "executeOperationsBatch"));
        }
        int complete = 0;
        for (TransferOperation operation : operations) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(operation.getProgressText((ExecutionContext)context));
            operation.execute((ExecutionContext)context);
            indicator.setFraction((double)(++complete) / (double)operations.size());
        }
    }

    @NotNull
    protected String[] getAdditionalExcludePatterns() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteTransfer", "getAdditionalExcludePatterns"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean isTransferTaskModal() {
        return this.myTransferTaskModal;
    }

    public void setTransferTaskModal(boolean transferTaskModal) {
        this.myTransferTaskModal = transferTaskModal;
    }

    protected List<ExcludedPath> getExcludedHelpersPaths(Collection<String> helpersPaths) {
        return Lists.newArrayList();
    }

    public static interface HelpersTransferConfig {
        @NotNull
        public String getHelpersPath();

        @NotNull
        public FileTransferConfig createFileTransferConfig();

        public boolean isHelpersVersionChecked();

        public void setHelpersVersionChecked(boolean var1);
    }

    protected final class RemoteSdkExecutionContext
    implements ExecutionContext {
        @Nullable
        private final Project myProject;
        private final ProgressIndicator myProgressIndicator;
        private PublishConfig myPublishConfig;
        private WebServerConfig myWebServerConfig;
        private RemoteConnection myConnection;
        private boolean myPromptForOverwrite;
        private boolean myServerSideModification = true;

        private RemoteSdkExecutionContext(Project project, ProgressIndicator progressIndicator, WebServerConfig webServerConfig, RemoteConnection connection) {
            this.myProject = project;
            this.myProgressIndicator = progressIndicator;
            this.myWebServerConfig = webServerConfig;
            this.myConnection = connection;
            this.myPublishConfig = new PublishConfig(project, UltimateVerifier.getInstance());
            this.myPublishConfig.setPromptOnRemoteOverwrite(PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP);
            this.myPublishConfig.setExcludeMask(StringUtil.join((String[])ArrayUtil.mergeArrays((String[])PublishConfig.DEFAULT_EXCLUDES, (String[])RemoteTransfer.this.getAdditionalExcludePatterns()), (String)";"));
        }

        public PublishConfig getConfig() {
            return this.myPublishConfig;
        }

        public void incCounter(String counterTitle) {
        }

        public void incBytesTransmitted(long bytes) {
        }

        public void console(String message, ConsoleViewContentType type) {
        }

        public boolean isMultipleOperations() {
            return true;
        }

        public void showBalloon(String message, MessageType type) {
        }

        public void setPromptForOverwrite(boolean promptForOverwrite) {
            this.myPromptForOverwrite = promptForOverwrite;
        }

        public boolean promptForOverwrite(@Nullable FileObject source, @NotNull FileObject target) throws IOException {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/remotesdk/RemoteTransfer$RemoteSdkExecutionContext", "promptForOverwrite"));
            }
            return this.myPromptForOverwrite;
        }

        public ProgressIndicator getProgressIndicator() {
            return this.myProgressIndicator;
        }

        public void addAffectedRoot(FileName fileName, boolean remote) {
        }

        public boolean isServerSideModification() {
            return this.myServerSideModification;
        }

        public void setServerSideModification(boolean serverSideModification) {
            this.myServerSideModification = serverSideModification;
        }

        public WebServerConfig getServer() {
            return this.myWebServerConfig;
        }

        public FileObject findRemoteFile(WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
            FileObject file = this.myWebServerConfig.findFile(this.myConnection.getFileSystem(), path);
            if (refreshUpRecursively) {
                DeploymentPathUtils.refreshRemoteFile((FileObject)file, (ExecutionContextBase)this);
            } else {
                file.refresh();
            }
            return file;
        }

        public boolean isTolerateSetPermissionsErrors() {
            return true;
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        public boolean isCancellable() {
            return false;
        }

        public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
        }

        public void setCurrentFileFraction(double fraction) {
        }

        public void setIgnoreOverwriting(boolean ignore) {
        }

        public DeploymentMode getDeploymentMode() {
            return DeploymentMode.CUSTOM;
        }

        public DeploymentRevisionTracker getRevisionTracker() {
            return DeploymentRevisionTracker.DEAF;
        }
    }
}

