/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionPool;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConnectionManagerImpl
extends SshConnectionManager {
    private static final Object DEFAULT_OWNER = new Object();
    private final Map<SessionKey, Object> myLocks = Maps.newHashMap();
    private final Map<SessionKey, SshConnectionPool> myPoolMap = Maps.newHashMap();

    @Override
    @NotNull
    public SshRemoteSession getSession(@NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        SshRemoteSession sshRemoteSession = this.getSession(null, data, 60L, TimeUnit.SECONDS);
        if (sshRemoteSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        return sshRemoteSession;
    }

    @Override
    public SshRemoteSession getSession(@Nullable Project project, @NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        return this.getSession(project, data, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public SshRemoteSession getSession(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) throws RemoteSdkException {
        void timeUnit2;
        SshConnectionPool pool;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        final SessionKey key = this.createSessionKey(project, data);
        Object lock = this.getLock(key);
        Disposable d = null;
        Object object = lock;
        synchronized (object) {
            pool = this.myPoolMap.get(key);
            if (pool == null) {
                pool = new SshConnectionPool(lock);
                this.myPoolMap.put(key, pool);
                d = new Disposable(){

                    public void dispose() {
                        SshConnectionPool pool = (SshConnectionPool)SshConnectionManagerImpl.this.myPoolMap.get(key);
                        if (pool != null) {
                            pool.close();
                            SshConnectionManagerImpl.this.myPoolMap.remove(key);
                            SshConnectionManagerImpl.this.myLocks.remove(key);
                        }
                    }
                };
            }
        }
        if (d != null) {
            if (project == null || project.isDefault()) {
                Disposer.register((Disposable)ApplicationManager.getApplication(), d);
            } else {
                Disposer.register((Disposable)project, d);
            }
        }
        return pool.getSession(project, data, timeout, (TimeUnit)timeUnit2);
    }

    private Object getLock(@NotNull SessionKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getLock"));
        }
        if (!this.myLocks.containsKey(key)) {
            this.myLocks.put(key, new Object());
        }
        return this.myLocks.get(key);
    }

    private SessionKey createSessionKey(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "createSessionKey"));
        }
        return new SessionKey(project != null ? project : DEFAULT_OWNER, RemoteSdkUtil.createFromRemoteCredentials(data));
    }

    private class SessionKey {
        @NotNull
        private final Object myOwner;
        @NotNull
        private final FileTransferConfig myTransferConfig;

        private SessionKey(@NotNull Object project, FileTransferConfig config) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl$SessionKey", "<init>"));
            }
            if (config == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl$SessionKey", "<init>"));
            }
            this.myOwner = project;
            this.myTransferConfig = config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionKey key = (SessionKey)o;
            return this.myOwner.equals(key.myOwner) && this.myTransferConfig.equals((Object)key.myTransferConfig);
        }

        public int hashCode() {
            return 31 * this.myOwner.hashCode() + this.myTransferConfig.hashCode();
        }
    }
}

