/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConnectionPool {
    private SshRemoteSession mySession;
    private final Object myLock;
    private final AtomicBoolean myClosing;

    public SshConnectionPool(@NotNull Object lock) {
        if (lock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "com/jetbrains/plugins/remotesdk/transport/SshConnectionPool", "<init>"));
        }
        this.mySession = null;
        this.myClosing = new AtomicBoolean(false);
        this.myLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public synchronized SshRemoteSession getSession(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionPool", "getSession"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/transport/SshConnectionPool", "getSession"));
        }
        if (this.mySession == null || !this.mySession.isConnected()) {
            Object object = this.myLock;
            synchronized (object) {
                void timeUnit2;
                this.mySession = RemoteSdkUtil.createRemoteSession(project, data, timeout, (TimeUnit)timeUnit2);
                if (this.myClosing.get()) {
                    this.doClose();
                    throw new RemoteSdkException("Ssh connection pool is already closed");
                }
            }
        }
        SshRemoteSession sshRemoteSession = this.mySession;
        if (sshRemoteSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshConnectionPool", "getSession"));
        }
        return sshRemoteSession;
    }

    private void doClose() {
        this.mySession.disconnect();
        this.mySession = null;
        this.myClosing.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AtomicBoolean atomicBoolean = this.myClosing;
        synchronized (atomicBoolean) {
            if (this.mySession != null && this.mySession.isConnected()) {
                if (!this.myClosing.getAndSet(true)) {
                    this.doClose();
                }
            } else {
                this.myClosing.set(true);
            }
        }
    }
}

