/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteMappingsConfiguration {
    private static final int LOCAL_INDEX = 0;
    private static final int REMOTE_INDEX = 1;
    private static final int DISABLED = 2;
    public static final int VALIDATION_INTERVAL = 300;
    public static final Comparator<MappingWrapper> LOCAL_PATH_COMPARATOR = new Comparator<MappingWrapper>(){

        @Override
        public int compare(MappingWrapper o1, MappingWrapper o2) {
            return StringUtil.compare((String)o1.getMapping().getLocalRoot(), (String)o2.getMapping().getLocalRoot(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
        }
    };
    public static final String HELP_ID = "remote.mappings";
    private ChangesTrackingTableView<MappingWrapper> myTable;
    @NotNull
    private final Project myProject;
    @NotNull
    private final RemoteCredentials myCredentials;
    private final boolean myWithDisabling;
    private final boolean myWithType;
    private ToolbarDecorator myToolbarDecorator;
    private JPanel myPanel;
    private boolean myValidatedOk;
    private Consumer<Boolean> myValidationCallback;
    private final Set<String> myDuplicateUserLocalPaths;
    private String myErrorText;

    public RemoteMappingsConfiguration(@NotNull Project project, @NotNull List<MappingWrapper> data, @NotNull RemoteCredentials credentials, boolean withDisabling, boolean withType, @NotNull Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "<init>"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "<init>"));
        }
        this.myValidatedOk = true;
        this.myProject = project;
        this.myCredentials = credentials;
        this.myWithDisabling = withDisabling;
        this.myWithType = withType;
        this.myDuplicateUserLocalPaths = new HashSet<String>();
        this.createUI(data, disposable);
    }

    public void setValidationCallback(Consumer<Boolean> validationCallback) {
        this.myValidationCallback = validationCallback;
    }

    private void validateTable() {
        ListTableModel model = this.myTable.getListTableModel();
        ArrayList items = new ArrayList(model.getItems());
        boolean editingLocal = false;
        int editingRow = -1;
        String editingValue = null;
        if (this.myTable.isEditing()) {
            editingLocal = this.myTable.getEditingColumn() == 0;
            editingRow = this.myTable.getEditingRow();
            Object value = this.myTable.getCellEditor() == null ? null : this.myTable.getCellEditor().getCellEditorValue();
            editingValue = value instanceof String ? (String)value : null;
        }
        HashSet<String> duplicateControl = new HashSet<String>();
        this.myDuplicateUserLocalPaths.clear();
        this.myErrorText = null;
        boolean validatedOk = true;
        for (int i = 0; i < items.size(); ++i) {
            String remoteRoot;
            MappingWrapper wrapper = (MappingWrapper)items.get(i);
            if (!MappingType.USER_DEFINED.equals((Object)wrapper.getType())) continue;
            String localRoot = editingLocal && editingRow == i ? editingValue : wrapper.getMapping().getLocalRoot();
            String string = remoteRoot = !editingLocal && editingRow == i ? editingValue : wrapper.getMapping().getRemoteRoot();
            if (StringUtil.isEmptyOrSpaces((String)localRoot) || StringUtil.isEmptyOrSpaces((String)remoteRoot)) {
                validatedOk = false;
                this.myErrorText = "Some paths are empty";
            }
            if (duplicateControl.contains(localRoot)) {
                this.myDuplicateUserLocalPaths.add(localRoot);
                if (validatedOk) {
                    this.myErrorText = "There are duplicate local user-defined paths";
                }
                validatedOk = false;
            }
            duplicateControl.add(localRoot);
        }
        this.myTable.revalidate();
        this.myTable.repaint();
        this.myValidatedOk = validatedOk;
        if (this.myValidationCallback != null) {
            this.myValidationCallback.consume((Object)this.myValidatedOk);
        }
    }

    public boolean isValidatedOk() {
        return this.myValidatedOk;
    }

    public String getErrorText() {
        return this.myErrorText;
    }

    private void createUI(List<MappingWrapper> data, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "createUI"));
        }
        this.myTable = new ChangesTrackingTableView<MappingWrapper>(){

            protected void onCellValueChanged(int row, int column, Object value) {
                RemoteMappingsConfiguration.this.myValidatedOk = false;
            }

            protected void onEditingStopped() {
            }
        };
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTable.setRowHeight(Math.max(UIUtil.getBalloonWarningIcon().getIconHeight() + 2, new JTextField().getPreferredSize().height + 2));
        ListTableModel model = new ListTableModel(this.createColumns(), new ArrayList<MappingWrapper>(data));
        model.setSortable(false);
        this.myTable.setModelAndUpdateColumns(model);
        this.myToolbarDecorator = ToolbarDecorator.createDecorator(this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListTableModel model = RemoteMappingsConfiguration.this.myTable.getListTableModel();
                int newRow = model.getRowCount() == 0 ? 0 : model.getRowCount() - 1;
                for (int i = 0; i < model.getRowCount(); ++i) {
                    if (!MappingType.HEADER.equals((Object)((MappingWrapper)model.getRowValue(i)).getType())) continue;
                    newRow = i;
                    break;
                }
                model.insertRow(newRow, (Object)new MappingWrapper(MappingType.USER_DEFINED, new PathMappingSettings.PathMapping(null, null)));
                RemoteMappingsConfiguration.this.myTable.getSelectionModel().setSelectionInterval(newRow, newRow);
                RemoteMappingsConfiguration.this.myTable.editCellAt(newRow, 0);
                Component component = RemoteMappingsConfiguration.this.myTable.getCellEditor(newRow, 0).getTableCellEditorComponent((JTable)RemoteMappingsConfiguration.this.myTable, "", true, newRow, 0);
                IdeFocusManager.getInstance((Project)RemoteMappingsConfiguration.this.myProject).requestFocus(component, true);
                RemoteMappingsConfiguration.this.validateTable();
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                List objects = RemoteMappingsConfiguration.this.myTable.getSelectedObjects();
                if (objects.isEmpty()) {
                    return false;
                }
                for (MappingWrapper object : objects) {
                    if (MappingType.USER_DEFINED.equals((Object)object.getType())) continue;
                    return false;
                }
                return true;
            }
        }).disableUpDownActions();
        this.myPanel = this.myToolbarDecorator.createPanel();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, disposable);
        alarm.addRequest(this.createValidateRequest(alarm), 300, ModalityState.any());
    }

    private Runnable createValidateRequest(final Alarm alarm) {
        return new Runnable(){

            @Override
            public void run() {
                RemoteMappingsConfiguration.this.validateTable();
                alarm.addRequest(RemoteMappingsConfiguration.this.createValidateRequest(alarm), 300, ModalityState.any());
            }
        };
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private ColumnInfo[] createColumns() {
        if (!this.myWithDisabling && !this.myWithType) {
            return new ColumnInfo[]{this.createLocalPathColumn(), this.createRemotePathColumn()};
        }
        if (!this.myWithDisabling) {
            return new ColumnInfo[]{this.createIconColumn(), this.createLocalPathColumn(), this.createRemotePathColumn()};
        }
        if (!this.myWithType) {
            return new ColumnInfo[]{this.createLocalPathColumn(), this.createRemotePathColumn(), this.createDisabledColumn()};
        }
        return new ColumnInfo[]{this.createIconColumn(), this.createLocalPathColumn(), this.createRemotePathColumn(), this.createDisabledColumn()};
    }

    private ColumnInfo createDisabledColumn() {
        return new ColumnInfo<MappingWrapper, Boolean>("Disabled"){

            @Nullable
            public Boolean valueOf(MappingWrapper wrapper) {
                return !MappingType.USER_DEFINED.equals((Object)wrapper.getType()) && wrapper.isDisabled();
            }

            public boolean isCellEditable(MappingWrapper wrapper) {
                return !MappingType.USER_DEFINED.equals((Object)wrapper.getType());
            }

            public void setValue(MappingWrapper wrapper, Boolean value) {
                if (!MappingType.USER_DEFINED.equals((Object)wrapper.getType())) {
                    wrapper.setDisabled(value);
                }
            }

            @Nullable
            public TableCellEditor getEditor(MappingWrapper wrapper) {
                return new BooleanTableCellEditor(false);
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return new BooleanTableCellRenderer();
            }
        };
    }

    private ColumnInfo createIconColumn() {
        return new ColumnInfo<MappingWrapper, Object>(" "){
            private ColoredTableCellRenderer myRenderer;
            {
                this.myRenderer = new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                        if (value instanceof Icon) {
                            this.setIcon((Icon)value);
                        }
                    }
                };
            }

            @Nullable
            public Object valueOf(MappingWrapper wrapper) {
                return wrapper.getType().getIcon();
            }

            public int getWidth(JTable table) {
                return UIUtil.getBalloonWarningIcon().getIconWidth() + 2;
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return this.myRenderer;
            }
        };
    }

    @NotNull
    private ColumnInfo<MappingWrapper, String> createRemotePathColumn() {
        ColumnInfo<MappingWrapper, String> columnInfo = new ColumnInfo<MappingWrapper, String>("Remote Path"){
            private Comparator<MappingWrapper> myComparator;
            {
                this.myComparator = new Comparator<MappingWrapper>(){

                    @Override
                    public int compare(MappingWrapper o1, MappingWrapper o2) {
                        return StringUtil.compare((String)o1.getMapping().getRemoteRoot(), (String)o2.getMapping().getRemoteRoot(), (boolean)false);
                    }
                };
            }

            @Nullable
            public String valueOf(MappingWrapper mapping) {
                return mapping.getMapping().getRemoteRoot();
            }

            public boolean isCellEditable(MappingWrapper mapping) {
                return MappingType.USER_DEFINED.equals((Object)mapping.myType);
            }

            public void setValue(MappingWrapper mapping, String value) {
                mapping.getMapping().setRemoteRoot(value);
            }

            @Nullable
            public TableCellEditor getEditor(MappingWrapper mapping) {
                return new LocalPathCellEditor(){

                    protected ActionListener createActionListener(JTable table) {
                        return new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String file = RemoteSdkUtil.chooseRemoteFile(RemoteMappingsConfiguration.this.myProject, RemoteMappingsConfiguration.this.myCredentials, false);
                                if (!StringUtil.isEmptyOrSpaces((String)file)) {
                                    ((JTextField)myComponent.getChildComponent()).setText(file);
                                }
                            }
                        };
                    }
                };
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return new MyTableCellRenderer();
            }

            @Nullable
            public Comparator<MappingWrapper> getComparator() {
                return this.myComparator;
            }
        };
        if (columnInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "createRemotePathColumn"));
        }
        return columnInfo;
    }

    @NotNull
    private ColumnInfo<MappingWrapper, String> createLocalPathColumn() {
        ColumnInfo<MappingWrapper, String> columnInfo = new ColumnInfo<MappingWrapper, String>("Local Path"){
            private Comparator<MappingWrapper> myComparator;
            {
                this.myComparator = LOCAL_PATH_COMPARATOR;
            }

            @Nullable
            public String valueOf(MappingWrapper mapping) {
                return mapping.getMapping().getLocalRoot();
            }

            public boolean isCellEditable(MappingWrapper mapping) {
                return MappingType.USER_DEFINED.equals((Object)mapping.myType);
            }

            public void setValue(MappingWrapper mapping, String value) {
                mapping.getMapping().setLocalRoot(value);
            }

            @Nullable
            public TableCellEditor getEditor(MappingWrapper mapping) {
                return new LocalPathCellEditor("Choose local path", RemoteMappingsConfiguration.this.myProject);
            }

            @Nullable
            public Comparator<MappingWrapper> getComparator() {
                return this.myComparator;
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return new MyTableCellRenderer();
            }
        };
        if (columnInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration", "createLocalPathColumn"));
        }
        return columnInfo;
    }

    private class MyTableCellRenderer
    extends SimpleColoredRenderer
    implements TableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected boolean shouldPaintBackground() {
            return true;
        }

        protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
            return attributes;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(null);
            if (value == null) {
                return this;
            }
            MappingWrapper mappingWrapper = (MappingWrapper)RemoteMappingsConfiguration.this.myTable.getListTableModel().getRowValue(row);
            if (mappingWrapper != null && !MappingType.USER_DEFINED.equals((Object)mappingWrapper.getType())) {
                this.setBackground(UIUtil.getLabelBackground());
                this.setPaintFocusBorder(false);
            } else {
                this.setBackground(UIUtil.getTableBackground());
                if (column == 0 && mappingWrapper != null && RemoteMappingsConfiguration.this.myDuplicateUserLocalPaths.contains(StringUtil.notNullize((String)mappingWrapper.getMapping().getLocalRoot()))) {
                    this.setBorder(BorderFactory.createLineBorder((Color)JBColor.RED));
                }
            }
            if (mappingWrapper != null && MappingType.HEADER.equals((Object)mappingWrapper.getType())) {
                this.append(value.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            return this;
        }
    }

    public static enum MappingType {
        USER_DEFINED(AllIcons.Ide.Readwrite, "User-defined"),
        REPLICATED_FOLDER(AllIcons.Ide.Readonly, "Shared folders from Vagrantfile:"),
        DEPLOYMENT(AllIcons.Ide.Readonly, "From deployment configuration:"),
        SYS_PATH(AllIcons.Ide.Readonly, "sys.path"),
        SKELETONS(AllIcons.Ide.Readonly, "Skeletons"),
        HELPERS(AllIcons.Ide.Readonly, "Helpers"),
        HEADER(null, "Header");

        @Nullable
        private final Icon myIcon;
        @Nullable
        private final String myTooltip;

        private MappingType() {
            this.myIcon = null;
            this.myTooltip = null;
        }

        private MappingType(Icon icon, String tooltip) {
            this.myIcon = icon;
            this.myTooltip = tooltip;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Nullable
        public String getTooltip() {
            return this.myTooltip;
        }
    }

    private static class MappingWrapper {
        private final MappingType myType;
        private final PathMappingSettings.PathMapping myMapping;
        private boolean myIsDisabled;

        public MappingWrapper(MappingType type, PathMappingSettings.PathMapping mapping) {
            this.myType = type;
            this.myMapping = mapping;
            this.myIsDisabled = false;
        }

        public boolean isDisabled() {
            return this.myIsDisabled;
        }

        public void setDisabled(boolean disabled) {
            this.myIsDisabled = disabled;
        }

        public MappingType getType() {
            return this.myType;
        }

        public PathMappingSettings.PathMapping getMapping() {
            return this.myMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingWrapper wrapper = (MappingWrapper)o;
            if (this.myType != wrapper.myType) {
                return false;
            }
            return !(this.myMapping != null ? !this.myMapping.equals((Object)wrapper.myMapping) : wrapper.myMapping != null);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + (this.myMapping != null ? this.myMapping.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myPrefix;
        @NotNull
        private final String myServerId;
        @NotNull
        private final RemoteSdkAdditionalData mySdkAdditionalData;
        @Nullable
        private final RemoteMappingsManager.Mappings myMappings;
        private final Map<MappingType, List<PathMappingSettings.PathMapping>> myMap;
        private boolean myWithDisabling;
        private boolean myWithType;
        private RemoteCredentials myCredentials;
        private final Comparator<MappingWrapper> myMappingsComparator;
        private String myTooltipText;
        private JComponent myDescriptionComponent;

        public Builder(@NotNull Project project, @NotNull String prefix, @NotNull String serverId, @NotNull RemoteSdkAdditionalData sdkAdditionalData) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "<init>"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "<init>"));
            }
            if (serverId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "<init>"));
            }
            if (sdkAdditionalData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkAdditionalData", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "<init>"));
            }
            this.myProject = project;
            this.myPrefix = prefix;
            this.myServerId = serverId;
            this.mySdkAdditionalData = sdkAdditionalData;
            this.myMappings = RemoteMappingsManager.getInstance(project).getForServer(prefix, serverId);
            this.myMap = new HashMap<MappingType, List<PathMappingSettings.PathMapping>>();
            this.myMappingsComparator = this.createMappingsComparator();
        }

        public Builder withMappings(@NotNull MappingType type, @NotNull List<PathMappingSettings.PathMapping> mappings) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "withMappings"));
            }
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "withMappings"));
            }
            if (MappingType.USER_DEFINED.equals((Object)type)) {
                return null;
            }
            this.myMap.put(type, mappings);
            return this;
        }

        public Builder withDescriptionComponent(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "withDescriptionComponent"));
            }
            this.myDescriptionComponent = component;
            return this;
        }

        public Builder setWithDisabling(boolean withDisabling) {
            this.myWithDisabling = withDisabling;
            return this;
        }

        public Builder setWithType(boolean withType) {
            this.myWithType = withType;
            return this;
        }

        @Nullable
        public String getPresentation() throws ExecutionException {
            return this.getPresentation(this.convertToWrappers(false));
        }

        @Nullable
        public String getPresentation(@NotNull Collection<MappingWrapper> mappings) throws ExecutionException {
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "getPresentation"));
            }
            if (!mappings.isEmpty()) {
                ArrayList<MappingWrapper> list = new ArrayList<MappingWrapper>(mappings);
                Collections.sort(list, this.myMappingsComparator);
                StringBuilder sb = new StringBuilder();
                for (MappingWrapper wrapper : list) {
                    if (wrapper.isDisabled() || MappingType.HEADER.equals((Object)wrapper.getType())) continue;
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    sb.append(this.present(wrapper.getMapping(), "<Project root>"));
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
                return "(Everything disabled)";
            }
            return null;
        }

        @NotNull
        private Comparator<MappingWrapper> createMappingsComparator() {
            final Comparator<MappingWrapper> baseComparator = new Comparator<MappingWrapper>(){

                @Override
                public int compare(MappingWrapper o1, MappingWrapper o2) {
                    return FileUtil.toSystemIndependentName((String)o1.getMapping().getLocalRoot()).compareTo(FileUtil.toSystemIndependentName((String)o2.getMapping().getLocalRoot()));
                }
            };
            if (this.myProject.getBasePath() == null) {
                Comparator<MappingWrapper> comparator = baseComparator;
                if (comparator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "createMappingsComparator"));
                }
                return comparator;
            }
            final File projectFile = new File(this.myProject.getBasePath());
            Comparator<MappingWrapper> comparator = new Comparator<MappingWrapper>(){

                @Override
                public int compare(MappingWrapper o1, MappingWrapper o2) {
                    if (!o1.getType().equals((Object)o2.getType())) {
                        return MappingType.USER_DEFINED.equals((Object)o1.getType()) ? -1 : 1;
                    }
                    if (FileUtil.filesEqual((File)projectFile, (File)new File(o1.getMapping().getLocalRoot()))) {
                        return -1;
                    }
                    if (FileUtil.filesEqual((File)projectFile, (File)new File(o2.getMapping().getLocalRoot()))) {
                        return 1;
                    }
                    return baseComparator.compare(o1, o2);
                }
            };
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "createMappingsComparator"));
            }
            return comparator;
        }

        public String getTooltipText() {
            if (this.myTooltipText == null) {
                ArrayList<MappingWrapper> wrappers = new ArrayList<MappingWrapper>(this.convertToWrappers(true));
                StringBuilder sb = new StringBuilder();
                for (MappingWrapper wrapper : wrappers) {
                    if (wrapper.isDisabled()) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (MappingType.HEADER.equals((Object)wrapper.getType())) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append("<b>").append(wrapper.getMapping().getLocalRoot()).append("</b>");
                        continue;
                    }
                    sb.append(this.present(wrapper.getMapping(), "&lt;Project root&gt;"));
                }
                this.myTooltipText = sb.toString();
            }
            return this.myTooltipText;
        }

        private String present(PathMappingSettings.PathMapping mapping, @NotNull String projectRoot) {
            String relativePath;
            File localFile;
            if (projectRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRoot", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "present"));
            }
            if (this.myProject.getBasePath() == null) {
                return mapping.getLocalRoot() + UIUtil.rightArrow() + mapping.getRemoteRoot();
            }
            File projectBaseDir = new File(this.myProject.getBasePath());
            if (FileUtil.isAncestor((File)projectBaseDir, (File)(localFile = new File(mapping.getLocalRoot())), (boolean)false) && (relativePath = FileUtil.getRelativePath((File)projectBaseDir, (File)localFile)) != null) {
                relativePath = relativePath.startsWith("./") || ".".equals(relativePath) ? relativePath.substring(1) : (!relativePath.startsWith("/") ? "/" + relativePath : relativePath);
                return projectRoot + relativePath + UIUtil.rightArrow() + mapping.getRemoteRoot();
            }
            return mapping.getLocalRoot() + UIUtil.rightArrow() + mapping.getRemoteRoot();
        }

        public String configureAndSelect() throws ExecutionException {
            RemoteSdkCredentials credentials;
            List<MappingWrapper> list = this.convertToWrappers(true);
            Disposable disposable = new Disposable(){

                public void dispose() {
                }
            };
            try {
                credentials = this.mySdkAdditionalData.getRemoteSdkCredentials(this.myProject, true);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
            final RemoteMappingsConfiguration configuration = new RemoteMappingsConfiguration(this.myProject, list, (RemoteCredentials)credentials, this.myWithDisabling, this.myWithType, disposable);
            final DialogBuilder builder = new DialogBuilder();
            builder.setTitle("Edit Project Path Mappings");
            JPanel wrapperPanel = new JPanel(new BorderLayout());
            wrapperPanel.add((Component)configuration.getPanel(), "Center");
            JPanel wrapperPanel2 = new JPanel(new BorderLayout());
            wrapperPanel.add((Component)wrapperPanel2, "South");
            if (this.myDescriptionComponent != null) {
                wrapperPanel2.add((Component)this.myDescriptionComponent, "East");
                this.myDescriptionComponent.setAlignmentX(1.0f);
            }
            builder.setCenterPanel((JComponent)wrapperPanel);
            builder.setDimensionServiceKey(RemoteMappingsConfiguration.class.getName());
            builder.setPreferredFocusComponent((JComponent)configuration.myTable);
            builder.addDisposable(disposable);
            builder.setHelpId(RemoteMappingsConfiguration.HELP_ID);
            configuration.setValidationCallback(new Consumer<Boolean>(){

                public void consume(Boolean aBoolean) {
                    builder.setOkActionEnabled(aBoolean.booleanValue());
                    builder.setErrorText(configuration.getErrorText());
                }
            });
            if (!builder.showAndGet()) {
                return null;
            }
            ListTableModel model = configuration.myTable.getListTableModel();
            ArrayList settings = new ArrayList();
            HashMap<String, String> disabled = new HashMap<String, String>();
            for (MappingWrapper wrapper : model.getItems()) {
                if (MappingType.USER_DEFINED.equals((Object)wrapper.getType())) {
                    settings.add(wrapper.getMapping());
                    continue;
                }
                if (!wrapper.isDisabled()) continue;
                disabled.put(wrapper.getMapping().getLocalRoot(), wrapper.getMapping().getRemoteRoot());
            }
            RemoteMappingsManager.Mappings newMappings = RemoteMappingsManager.getInstance(this.myProject).create(this.myPrefix, this.myServerId, settings.isEmpty() ? Collections.emptyList() : settings);
            if (!disabled.isEmpty()) {
                newMappings.setDisabled(disabled);
            }
            RemoteMappingsManager.getInstance(this.myProject).setForServer(newMappings);
            return this.getPresentation(model.getItems());
        }

        @NotNull
        private List<MappingWrapper> convertToWrappers(boolean withHeaders) {
            final Map disabled = this.myMappings == null ? Collections.emptyMap() : this.myMappings.getDisabled();
            final ArrayList<MappingWrapper> list = new ArrayList<MappingWrapper>();
            PairConsumer<MappingType, PathMappingSettings.PathMapping> adder = new PairConsumer<MappingType, PathMappingSettings.PathMapping>(){

                public void consume(MappingType type, PathMappingSettings.PathMapping mapping) {
                    MappingWrapper wrapper = new MappingWrapper(type, mapping);
                    wrapper.setDisabled(Comparing.equal((String)((String)disabled.get(mapping.getLocalRoot())), (String)mapping.getRemoteRoot()));
                    list.add(wrapper);
                }
            };
            if (this.myMappings != null) {
                for (PathMappingSettings.PathMapping pathMapping : this.myMappings.getSettings()) {
                    adder.consume((Object)MappingType.USER_DEFINED, (Object)pathMapping);
                }
            }
            for (Map.Entry entry : this.myMap.entrySet()) {
                MappingType type = (MappingType)((Object)entry.getKey());
                List mappingsList = (List)entry.getValue();
                if (mappingsList.isEmpty()) continue;
                if (withHeaders) {
                    list.add(new MappingWrapper(MappingType.HEADER, new PathMappingSettings.PathMapping(type.getTooltip(), "")));
                }
                for (PathMappingSettings.PathMapping mapping : mappingsList) {
                    adder.consume((Object)type, (Object)mapping);
                }
            }
            ArrayList<MappingWrapper> arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder", "convertToWrappers"));
            }
            return arrayList;
        }
    }
}

