/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class StatusPanel
extends JBPanel {
    private final ReentrantLock myLock = new ReentrantLock();
    private String myError;
    private Action myCurrentAction;

    public StatusPanel() {
        super((LayoutManager)new BorderLayout());
        this.setVisible(false);
    }

    public void resetState() {
        this.myLock.lock();
        try {
            this.cancelCurrentAction();
            this.clearUI();
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action progress(final String message) {
        this.myLock.lock();
        try {
            Action action;
            this.cancelCurrentAction();
            this.myCurrentAction = action = new Action();
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.clearUI();
                    AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon(message);
                    StatusPanel.this.add((Component)asyncProcessIcon, "Center");
                    StatusPanel.this.setVisible(true);
                    asyncProcessIcon.resume();
                    StatusPanel.this.refreshUI();
                }
            });
            Action action2 = action;
            return action2;
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void cancelCurrentAction() {
        if (this.myCurrentAction != null) {
            this.myCurrentAction.cancel();
            this.myCurrentAction = null;
        }
    }

    private void clearUI() {
        this.myError = null;
        this.removeAll();
        this.setVisible(false);
        this.refreshUI();
    }

    private void refreshUI() {
        this.revalidate();
        this.repaint();
    }

    private void showMessage(String message, JBColor color, Icon statusIcon) {
        this.removeAll();
        this.setVisible(true);
        JBLabel label = new JBLabel(message);
        label.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)color) + "'><left>" + message + "</left></b></font>")));
        label.setIcon(statusIcon);
        label.setBorder((Border)new EmptyBorder(4, 10, 0, 2));
        this.add((Component)label, "Center");
        this.refreshUI();
    }

    private void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)((Object)this)));
    }

    public String getError() {
        return this.myError;
    }

    public class Action {
        private volatile boolean myCancelled = false;
        private final AtomicBoolean myCompleted = new AtomicBoolean(false);

        private boolean checkIsInProgressAndComplete() {
            return this.myCompleted.compareAndSet(false, true) && !this.myCancelled;
        }

        private void cancel() {
            this.myCancelled = true;
        }

        public void done() {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusPanel.this.myLock.lock();
                        try {
                            if (!Action.this.myCancelled) {
                                StatusPanel.this.clearUI();
                            }
                        }
                        finally {
                            StatusPanel.this.myLock.unlock();
                        }
                    }
                });
            }
        }

        public void doneWithResult(String message) {
            this.showMessageOnce(message, false);
        }

        public void failed(String message) {
            this.showMessageOnce(message, true);
        }

        private void showMessageOnce(final String message, final boolean isError) {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusPanel.this.myLock.lock();
                        try {
                            if (!Action.this.myCancelled) {
                                JBColor color = isError ? JBColor.RED : JBColor.DARK_GRAY;
                                Icon statusIcon = isError ? AllIcons.Actions.Lightning : AllIcons.General.InspectionsOK;
                                StatusPanel.this.myError = isError ? message : null;
                                StatusPanel.this.showMessage(message, color, statusIcon);
                            }
                        }
                        finally {
                            StatusPanel.this.myLock.unlock();
                        }
                    }
                });
            }
        }
    }
}

