/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.sdk.impl;

import com.intellij.appengine.sdk.impl.AppEngineSdkImpl;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AppEngineSdkUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.appengine.sdk.impl.AppEngineSdkUtil");
    @NonNls
    public static final String APP_ENGINE_DOWNLOAD_URL = "http://code.google.com/appengine/downloads.html#Google_App_Engine_SDK_for_Java";
    private static final FacetConfigurationQuickFix DOWNLOAD_SDK_QUICK_FIX = new FacetConfigurationQuickFix("Download..."){

        public void run(JComponent place) {
            BrowserUtil.browse((String)AppEngineSdkUtil.APP_ENGINE_DOWNLOAD_URL);
        }
    };

    private AppEngineSdkUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveWhiteList(File cachedWhiteList, Map<String, Set<String>> classesWhiteList) {
        try {
            FileUtil.createParentDirs((File)cachedWhiteList);
            try (PrintWriter writer = new PrintWriter(cachedWhiteList);){
                for (String packageName : classesWhiteList.keySet()) {
                    writer.println("." + packageName);
                    Set<String> classes = classesWhiteList.get(packageName);
                    for (String aClass : classes) {
                        writer.println(aClass);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<String>> loadWhiteList(File input) throws IOException {
        THashMap map = new THashMap();
        try (BufferedReader reader = new BufferedReader(new FileReader(input));){
            String line;
            THashSet currentClasses = new THashSet();
            map.put((Object)"", (Object)currentClasses);
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(".")) {
                    String packageName = line.substring(1);
                    currentClasses = new THashSet();
                    map.put((Object)packageName, (Object)currentClasses);
                    continue;
                }
                currentClasses.add(line);
            }
        }
        return map;
    }

    public static Map<String, Set<String>> computeWhiteList(File toolsApiJarFile) {
        try {
            THashMap map = new THashMap();
            UrlClassLoader loader = UrlClassLoader.build().urls(new URL[]{toolsApiJarFile.toURI().toURL()}).parent(AppEngineSdkUtil.class.getClassLoader()).get();
            Class<?> whiteListClass = Class.forName("com.google.apphosting.runtime.security.WhiteList", true, (ClassLoader)loader);
            Set classes = (Set)whiteListClass.getMethod("getWhiteList", new Class[0]).invoke(null, new Object[0]);
            for (String qualifiedName : classes) {
                String packageName = StringUtil.getPackageName((String)qualifiedName);
                Set classNames = (Set)map.get((Object)packageName);
                if (classNames == null) {
                    classNames = new THashSet();
                    map.put((Object)packageName, (Object)classNames);
                }
                classNames.add(StringUtil.getShortName((String)qualifiedName));
            }
            return map;
        }
        catch (UnsupportedClassVersionError e) {
            LOG.warn((Throwable)e);
            return Collections.emptyMap();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    @NotNull
    public static ValidationResult checkPath(String path) {
        AppEngineSdkImpl sdk = new AppEngineSdkImpl(path);
        File appCfgFile = sdk.getAppCfgFile();
        if (!appCfgFile.exists()) {
            ValidationResult validationResult = AppEngineSdkUtil.createNotFoundMessage(path, appCfgFile);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkUtil", "checkPath"));
            }
            return validationResult;
        }
        File toolsApiJarFile = sdk.getToolsApiJarFile();
        if (!toolsApiJarFile.exists()) {
            ValidationResult validationResult = AppEngineSdkUtil.createNotFoundMessage(path, toolsApiJarFile);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkUtil", "checkPath"));
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkUtil", "checkPath"));
        }
        return validationResult;
    }

    private static ValidationResult createNotFoundMessage(@NotNull String path, @NotNull File file) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/appengine/sdk/impl/AppEngineSdkUtil", "createNotFoundMessage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/appengine/sdk/impl/AppEngineSdkUtil", "createNotFoundMessage"));
        }
        return new ValidationResult("'" + path + "' is not valid App Engine SDK installation: " + "'" + file + "' file not found", DOWNLOAD_SDK_QUICK_FIX);
    }
}

