/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.artifactResolver.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;

public class MavenModuleMap {
    private static final MavenModuleMap ourInstance = new MavenModuleMap();
    public static final String PATHS_FILE_PROPERTY = "idea.modules.paths.file";
    private final Properties myMap = new Properties();

    private MavenModuleMap() {
        String path = System.getProperty(PATHS_FILE_PROPERTY);
        if (path != null) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));){
                this.myMap.load(in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static MavenModuleMap getInstance() {
        return ourInstance;
    }

    public boolean resolveToModule(Artifact artifact) {
        File file;
        String extension = artifact.getArtifactHandler().getExtension();
        if ("jar".equals(extension) && "test-jar".equals(artifact.getType())) {
            extension = "test-jar";
        }
        if ((file = this.findArtifact(artifact.getGroupId(), artifact.getArtifactId(), extension, artifact.getBaseVersion())) == null) {
            return false;
        }
        artifact.setFile(file);
        artifact.setResolved(true);
        return true;
    }

    public File findArtifact(String groupId, String artifactId, String type, String baseVersion) {
        String key = groupId + ':' + artifactId + ':' + type + ':' + baseVersion;
        String value = this.myMap.getProperty(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        File file = new File(value);
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

