/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.version;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

final class JarResources {
    public boolean debugOn = false;
    private final Map<String, byte[]> htJarContents = new Hashtable<String, byte[]>();
    private String jarFileName;
    private boolean fullLoaded;

    public JarResources(String jarFileName) {
        this(jarFileName, true);
    }

    public JarResources(String jarFileName, boolean loadAll) {
        this.jarFileName = jarFileName;
        this.fullLoaded = loadAll;
        if (loadAll) {
            this.fullScan();
        }
    }

    public byte[] getResource(String name) {
        if (!this.fullLoaded && !this.htJarContents.containsKey(name)) {
            this.loadOnDemand(name);
        }
        return this.htJarContents.get(name);
    }

    private void fullScan() {
        try {
            ZipEntry ze;
            Hashtable<String, Integer> htSizes = new Hashtable<String, Integer>();
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze2 = e.nextElement();
                htSizes.put(ze2.getName(), (int)ze2.getSize());
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                int chunk;
                int size;
                if (ze.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
                }
                if ((size = (int)ze.getSize()) == -1) {
                    size = (Integer)htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
                if (!this.debugOn) continue;
                System.out.println(ze.getName() + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
            }
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOnDemand(String name) {
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(this.jarFileName);
            ZipEntry ze = zf.getEntry(name);
            if (ze == null) {
                return;
            }
            is = zf.getInputStream(ze);
            int size = is.available();
            if (size == -1) {
                return;
            }
            byte[] b = new byte[size];
            int readed = is.read(b);
            this.htJarContents.put(ze.getName(), b);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

