/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacetConfiguration;
import com.intellij.dmserver.facet.DMBundleSupportProvider;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMCompositeSupportProvider;
import com.intellij.dmserver.facet.DMConfigFacetConfiguration;
import com.intellij.dmserver.facet.DMConfigSupportProvider;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.dmserver.facet.DMFacetSupportProviderBase;
import com.intellij.dmserver.facet.DMModuleBundleFacetSettingsPanel;
import com.intellij.dmserver.facet.DMModuleCompositeFacetSettingsPanel;
import com.intellij.dmserver.facet.DMModuleConfigFacetSettingsPanel;
import com.intellij.dmserver.facet.DMModuleFacetSettingsPanel;
import com.intellij.dmserver.facet.DMProjectFacetSettingsPanel;
import com.intellij.dmserver.facet.DMServerSupportProvider;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerSupportConfigurable
extends FrameworkSupportConfigurable {
    private final FrameworkSupportModel myModel;
    private DMProjectFacetSettingsPanel myProjectSettingsPanel;
    private JRadioButton myBundleRadioButton;
    private JRadioButton myCompositeRadioButton;
    private JRadioButton myConfigRadioButton;
    private JPanel myMainPanel;
    private JPanel myFacetSettingsPanel;
    private final DMServerSupportProvider myFrameworkSupportProvider;
    private final boolean myInProjectCreation;
    private final FacetContribution[] myFacetContributions;
    private final Project myProject;
    private final ModulesProvider myModulesProvider;

    public DMServerSupportConfigurable(@NotNull FrameworkSupportModel model, @NotNull DMServerSupportProvider frameworkSupportProvider) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/facet/DMServerSupportConfigurable", "<init>"));
        }
        if (frameworkSupportProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkSupportProvider", "com/intellij/dmserver/facet/DMServerSupportConfigurable", "<init>"));
        }
        FacetContribution[] facetContributionArray = new FacetContribution[3];
        this.$$$setupUI$$$();
        facetContributionArray[0] = new BundleFacetContribution();
        facetContributionArray[1] = new CompositeFacetContribution();
        facetContributionArray[2] = new ConfigFacetContribution();
        this.myFacetContributions = facetContributionArray;
        this.myProject = model.getProject();
        this.myFrameworkSupportProvider = frameworkSupportProvider;
        this.myInProjectCreation = this.myProject == null;
        this.myProjectSettingsPanel.init(this.myProject);
        this.myModulesProvider = DefaultModulesProvider.createForProject((Project)this.myProject);
        this.myModel = model;
        for (final FacetContribution contribution : this.myFacetContributions) {
            contribution.getRadioButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DMServerSupportConfigurable.this.selectContribution(contribution);
                }
            });
        }
        this.myBundleRadioButton.setSelected(true);
        this.selectContribution(this.myFacetContributions[0]);
    }

    public void selectContribution(FacetContribution contribution) {
        contribution.getPanel().updateEnablement();
        ((CardLayout)this.myFacetSettingsPanel.getLayout()).show(this.myFacetSettingsPanel, contribution.getCardName());
        this.myFacetSettingsPanel.repaint();
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void addSupport(final @NotNull Module module, @NotNull ModifiableRootModel model, @Nullable Library library) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMServerSupportConfigurable", "addSupport"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/facet/DMServerSupportConfigurable", "addSupport"));
        }
        if (this.myInProjectCreation) {
            StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    DMServerSupportConfigurable.this.myProjectSettingsPanel.applyFrameworkSelection(module.getProject());
                }
            });
        }
        this.getSelectedFacetSupport().addSupport(module, model);
    }

    public void finishAddSupport(@NotNull Module module, @NotNull ModifiableRootModel model) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMServerSupportConfigurable", "finishAddSupport"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/facet/DMServerSupportConfigurable", "finishAddSupport"));
        }
        this.getSelectedFacetSupport().finishAddSupport(module, model, this.myProjectSettingsPanel.getSelectedServerInstallation());
    }

    private FacetContribution getSelectedFacetSupport() {
        for (FacetContribution facetContribution : this.myFacetContributions) {
            if (!facetContribution.isSelected()) continue;
            return facetContribution;
        }
        throw new IllegalStateException();
    }

    public void onFrameworkSelectionChanged(boolean selected) {
        if (selected) {
            this.getSelectedFacetSupport().getPanel().updateEnablement();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        DMProjectFacetSettingsPanel dMProjectFacetSettingsPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerSupportConfigurable.project.settings"), (int)0, (int)0, null, null));
        this.myProjectSettingsPanel = dMProjectFacetSettingsPanel = new DMProjectFacetSettingsPanel();
        JComponent jComponent = dMProjectFacetSettingsPanel.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setEnabled(true);
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerSupportConfigurable.module.settings"), (int)0, (int)0, null, null));
        this.myCompositeRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerSupportConfigurable.par.or.plan"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBundleRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerSupportConfigurable.bundle"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerSupportConfigurable.configuration"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerSupportConfigurable.facet"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFacetSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(1, 0, 1, 5, 0, 3, 6, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ConfigFacetContribution
    extends FacetContribution<DMConfigFacetConfiguration, DMConfigSupportProvider> {
        private ConfigFacetContribution() {
        }

        @Override
        protected DMConfigFacetConfiguration createFacetConfiguration() {
            return new DMConfigFacetConfiguration();
        }

        @Override
        protected DMModuleFacetSettingsPanel<DMConfigFacetConfiguration> createModuleSettingsPanel() {
            return new DMModuleConfigFacetSettingsPanel();
        }

        @Override
        protected JRadioButton getRadioButton() {
            return DMServerSupportConfigurable.this.myConfigRadioButton;
        }

        @Override
        @NonNls
        protected String getCardName() {
            return "config";
        }

        @Override
        protected DMConfigSupportProvider getProvider() {
            return DMServerSupportConfigurable.this.myFrameworkSupportProvider.getConfigSupportProvider();
        }
    }

    private class CompositeFacetContribution
    extends FacetContribution<DMCompositeFacetConfiguration, DMCompositeSupportProvider> {
        private CompositeFacetContribution() {
        }

        @Override
        protected DMCompositeFacetConfiguration createFacetConfiguration() {
            return new DMCompositeFacetConfiguration();
        }

        @Override
        protected DMModuleFacetSettingsPanel<DMCompositeFacetConfiguration> createModuleSettingsPanel() {
            return new DMModuleCompositeFacetSettingsPanel();
        }

        @Override
        protected JRadioButton getRadioButton() {
            return DMServerSupportConfigurable.this.myCompositeRadioButton;
        }

        @Override
        @NonNls
        protected String getCardName() {
            return "composite";
        }

        @Override
        protected DMCompositeSupportProvider getProvider() {
            return DMServerSupportConfigurable.this.myFrameworkSupportProvider.getCompositeSupportProvider();
        }
    }

    private class BundleFacetContribution
    extends FacetContribution<DMBundleFacetConfiguration, DMBundleSupportProvider> {
        private DMModuleBundleFacetSettingsPanel myFacetSettingsPanel;

        private BundleFacetContribution() {
        }

        @Override
        public void init() {
            super.init();
            this.myFacetSettingsPanel.initFrameworkContribution(this.getProvider().getWebSupportProvider(), DMServerSupportConfigurable.this.myModel);
        }

        @Override
        protected DMBundleFacetConfiguration createFacetConfiguration() {
            return new DMBundleFacetConfiguration();
        }

        @Override
        protected DMModuleFacetSettingsPanel<DMBundleFacetConfiguration> createModuleSettingsPanel() {
            this.myFacetSettingsPanel = new DMModuleBundleFacetSettingsPanel();
            return this.myFacetSettingsPanel;
        }

        @Override
        protected JRadioButton getRadioButton() {
            return DMServerSupportConfigurable.this.myBundleRadioButton;
        }

        @Override
        @NonNls
        protected String getCardName() {
            return "bundle";
        }

        @Override
        protected DMBundleSupportProvider getProvider() {
            return DMServerSupportConfigurable.this.myFrameworkSupportProvider.getBundleSupportProvider();
        }
    }

    private abstract class FacetContribution<C extends DMFacetConfigurationBase<C>, P extends DMFacetSupportProviderBase<?, C>> {
        private DMModuleFacetSettingsPanel<C> myPanel;

        private FacetContribution() {
        }

        public void init() {
            this.myPanel.init(DMServerSupportConfigurable.this.myProject, null, DMServerSupportConfigurable.this.myModulesProvider, (Disposable)DMServerSupportConfigurable.this);
            this.myPanel.load(this.createFacetConfiguration());
        }

        public DMModuleFacetSettingsPanel<C> getPanel() {
            if (this.myPanel == null) {
                this.myPanel = this.createModuleSettingsPanel();
                DMServerSupportConfigurable.this.myFacetSettingsPanel.add(this.getCardName(), this.myPanel.getMainPanel());
                this.init();
            }
            return this.myPanel;
        }

        public boolean isSelected() {
            return this.getRadioButton().isSelected();
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMServerSupportConfigurable$FacetContribution", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/facet/DMServerSupportConfigurable$FacetContribution", "addSupport"));
            }
            ((DMFacetSupportProviderBase)((Object)this.getProvider())).addDMSupport(module, rootModel);
        }

        public void finishAddSupport(Module module, ModifiableRootModel rootModel, DMServerInstallation installation) {
            C facetConfiguration = this.createFacetConfiguration();
            this.myPanel.save(facetConfiguration);
            ((DMFacetSupportProviderBase)((Object)this.getProvider())).finishAddDMSupport(module, rootModel, installation, facetConfiguration);
        }

        protected abstract C createFacetConfiguration();

        protected abstract DMModuleFacetSettingsPanel<C> createModuleSettingsPanel();

        protected abstract JRadioButton getRadioButton();

        @NonNls
        protected abstract String getCardName();

        protected abstract P getProvider();
    }
}

