/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.install.ServerVersionHandler;
import com.intellij.dmserver.install.impl.DMServerInstallationImpl;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerRepositoryEditor;
import com.intellij.dmserver.integration.DMServerRepositoryEditorListener;
import com.intellij.dmserver.integration.PathResolver;
import com.intellij.dmserver.libraries.LibrariesDialog;
import com.intellij.dmserver.libraries.LibrariesDialogCreator;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.IconUtils;
import com.intellij.dmserver.util.UiUtil;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;

public class DMServerIntegrationEditor
extends ApplicationServerPersistentDataEditor<DMServerIntegrationData> {
    private TextFieldWithBrowseButton myInstallationHomeField;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myPickupDirectoryField;
    private JSpinner myDeployerTimeoutField;
    private JCheckBox myShellEnabledCheckBox;
    private JCheckBox myLogSystemOutCheckBox;
    private JCheckBox myLogSystemErrCheckBox;
    private TextFieldWithBrowseButton myServerLogsRootFolder;
    private JSpinner myShellPortField;
    private JButton myExportButton;
    private JButton myImportButton;
    private JButton myEditFrameworkButton;
    private JTextField myFrameworkNameField;
    private JPanel myStatusPanel;
    private JBLabel myStatusErrorLabel;
    private JBLabel myStatusValidLabel;
    private DMServerRepositoryEditor myRepositoryEditor;
    private JLabel myReadErrorLabel;
    private JPanel myRepositoryPanel;
    private boolean myFieldsEnabled;
    private boolean myLockRefreshHome = false;
    private VirtualFile myHome;
    private DMServerInstallation myInstallation;
    private FrameworkInstanceDefinition myFramework;
    private Project myProject;
    private final PathResolver myPathResolver;

    public DMServerIntegrationEditor() {
        this.$$$setupUI$$$();
        this.myPathResolver = new PathResolver(){

            @Override
            protected VirtualFile getBaseDir() {
                return DMServerIntegrationEditor.this.myHome;
            }
        };
        this.myRepositoryEditor = new DMServerRepositoryEditor();
        this.myRepositoryEditor.setParent(this);
        this.myRepositoryPanel.add((Component)this.myRepositoryEditor.createComponent(), "Center");
        this.setupDirectoryPicker(this.myInstallationHomeField, DmServerBundle.message("DMServerIntegrationEditor.label.setup.server.home", new Object[0]), false);
        this.myInstallationHomeField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (DMServerIntegrationEditor.this.myLockRefreshHome) {
                    return;
                }
                DMServerIntegrationEditor.this.refreshHome(true);
            }
        });
        DMServerIntegrationEditor.setupSpinner(this.myDeployerTimeoutField);
        DMServerIntegrationEditor.setupSpinner(this.myShellPortField);
        this.setupDirectoryPicker(this.myPickupDirectoryField, DmServerBundle.message("DMServerIntegrationEditor.label.setup.pickup.folder", new Object[0]), true);
        this.setupDirectoryPicker(this.myServerLogsRootFolder, DmServerBundle.message("DMServerIntegrationEditor.label.setup.logs.folder", new Object[0]), true);
        this.myShellEnabledCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DMServerIntegrationEditor.this.refreshShellPortEnabled();
            }
        });
        this.myImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMServerIntegrationEditor.this.doImport();
            }
        });
        this.myExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMServerIntegrationEditor.this.doExport();
            }
        });
        this.myEditFrameworkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMServerIntegrationEditor.this.doManageBundles();
            }
        });
        IconUtils.setupWarningLabel((JLabel)this.myStatusErrorLabel);
        IconUtils.setupWarningLabel(this.myReadErrorLabel);
        this.setReadError(false);
        this.myRepositoryEditor.setListener(new DMServerRepositoryEditorListener(){

            @Override
            public void itemAdded() {
                DMServerIntegrationEditor.this.setReadError(false);
            }
        });
        this.refreshUi();
    }

    private void setReadError(boolean hasReadError) {
        this.myReadErrorLabel.setVisible(hasReadError);
    }

    private boolean hasReadError() {
        return this.myReadErrorLabel.isVisible();
    }

    private void refreshStatus(boolean valid) {
        String cardName = valid ? "valid" : "error";
        ((CardLayout)this.myStatusPanel.getLayout()).show(this.myStatusPanel, cardName);
        if (valid) {
            this.myStatusValidLabel.setText(DmServerBundle.message("DMServerIntegrationEditor.label.detected.version", this.myInstallation.getVersionName()));
        }
    }

    private static void setupSpinner(JSpinner spinner) {
        spinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        spinner.setEditor(new JSpinner.NumberEditor(spinner, "0"));
    }

    private void doManageBundles() {
        LibrariesDialogCreator.getInstance();
        LibrariesDialog dialog = LibrariesDialogCreator.createDialog(this.myFramework, this.myProject, this.myInstallation);
        dialog.show();
    }

    private void refreshUi() {
        this.refreshHome(false);
        this.refreshShellPortEnabled();
    }

    private void refreshHome(boolean importIfValid) {
        this.myHome = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.myInstallationHomeField.getText()));
        this.myInstallation = this.myHome == null ? null : new DMServerInstallationImpl(this.myHome);
        boolean installationValid = this.isInstallationValid();
        this.setServerFieldsEnabled(installationValid, installationValid && this.myInstallation.getServerVersion().getVersion() != ServerVersionHandler.DMVersion.DM_10);
        this.refreshFramework(installationValid);
        this.refreshStatus(installationValid);
        if (importIfValid && installationValid) {
            this.doImport();
        }
    }

    private boolean isInstallationValid() {
        return this.myInstallation != null && this.myInstallation.isValid();
    }

    private void refreshFramework(boolean installationValid) {
        Project[] openProjects;
        boolean frameworkExists;
        this.myFramework = null;
        this.myProject = null;
        if (installationValid) {
            this.myFramework = DMServerInstallationManager.getInstance().findFramework(this.myInstallation, false);
        }
        boolean bl = frameworkExists = this.myFramework != null;
        this.myFrameworkNameField.setText(installationValid ? (frameworkExists ? this.myFramework.getName() : DmServerBundle.message("DMServerIntegrationEditor.message.framework-not-yet-created", new Object[0])) : "");
        if (frameworkExists && (openProjects = ProjectManager.getInstance().getOpenProjects()).length > 0) {
            this.myProject = openProjects[0];
        }
        this.myEditFrameworkButton.setEnabled(this.myProject != null);
    }

    private void setServerFieldsEnabled(boolean enabled, boolean logsEnabled) {
        this.myFieldsEnabled = enabled;
        this.myPickupDirectoryField.setEnabled(enabled);
        this.myDeployerTimeoutField.setEnabled(enabled);
        this.myShellEnabledCheckBox.setEnabled(enabled);
        this.myLogSystemOutCheckBox.setEnabled(logsEnabled);
        this.myLogSystemErrCheckBox.setEnabled(logsEnabled);
        if (!logsEnabled) {
            this.myLogSystemOutCheckBox.setSelected(true);
            this.myLogSystemErrCheckBox.setSelected(true);
        }
        this.myServerLogsRootFolder.setEnabled(enabled);
        this.myShellPortField.setEnabled(enabled);
        this.myExportButton.setEnabled(enabled);
        this.myImportButton.setEnabled(enabled);
        this.myEditFrameworkButton.setEnabled(enabled);
        this.myRepositoryEditor.setEnabled(enabled);
    }

    private void setupDirectoryPicker(TextFieldWithBrowseButton field, String description, boolean allowRelative) {
        UiUtil.setupDirectoryPicker(field, DmServerBundle.message("DMServerIntegrationEditor.browse.title", new Object[0]), description, null, (TextComponentAccessor<JTextField>)(allowRelative ? new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                return DMServerIntegrationEditor.this.getPathResolver().path2Absolute(component.getText());
            }

            public void setText(JTextField component, @NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dmserver/integration/DMServerIntegrationEditor$8", "setText"));
                }
                component.setText(DMServerIntegrationEditor.this.getPathResolver().path2Relative(text));
            }
        } : TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
    }

    protected void resetEditorFrom(DMServerIntegrationData data) {
        this.myLockRefreshHome = true;
        try {
            this.myInstallationHomeField.setText(FileUtil.toSystemDependentName((String)data.getInstallationHome()));
        }
        finally {
            this.myLockRefreshHome = false;
        }
        this.loadFieldsFrom(data);
    }

    private void loadFieldsFrom(DMServerIntegrationData data) {
        this.refreshUi();
        this.myPickupDirectoryField.setText(FileUtil.toSystemDependentName((String)data.getPickupFolder()));
        this.myDeployerTimeoutField.setValue(data.getDeploymentTimeoutSecs());
        this.myShellEnabledCheckBox.setSelected(data.isShellEnabled());
        this.myLogSystemOutCheckBox.setSelected(data.isWrapSystemOut());
        this.myLogSystemErrCheckBox.setSelected(data.isWrapSystemErr());
        this.myServerLogsRootFolder.setText(FileUtil.toSystemDependentName((String)data.getDumpsFolder()));
        this.myShellPortField.setValue(data.getShellPort());
        this.myRepositoryEditor.loadFrom(data, this.myInstallation == null ? null : this.myInstallation.getServerVersion().getVersion());
        this.setReadError(data.isReloadRequired());
    }

    protected void applyEditorTo(DMServerIntegrationData data) {
        this.doApplyEditorTo(data);
    }

    private void doApplyEditorTo(DMServerIntegrationData data) {
        data.setInstallationHome(FileUtil.toSystemIndependentName((String)this.myInstallationHomeField.getText()));
        data.setPickupFolder(FileUtil.toSystemIndependentName((String)this.myPickupDirectoryField.getText()));
        data.setDeploymentTimeoutSecs((Integer)this.myDeployerTimeoutField.getValue());
        data.setShellEnabled(this.myShellEnabledCheckBox.isSelected());
        data.setWrapSystemOut(this.myLogSystemOutCheckBox.isSelected());
        data.setWrapSystemErr(this.myLogSystemErrCheckBox.isSelected());
        data.setDumpsFolder(FileUtil.toSystemIndependentName((String)this.myServerLogsRootFolder.getText()));
        data.setShellPort((Integer)this.myShellPortField.getValue());
        data.setReloadRequired(this.hasReadError());
        this.myRepositoryEditor.applyTo(data);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/integration/DMServerIntegrationEditor", "createEditor"));
        }
        return jPanel;
    }

    private void refreshShellPortEnabled() {
        boolean shellEnabled = this.myShellEnabledCheckBox.isSelected();
        this.myShellPortField.setEnabled(this.myFieldsEnabled && shellEnabled);
    }

    private void doExport() {
        DMServerIntegrationData data = new DMServerIntegrationData(this.myInstallationHomeField.getText());
        this.doApplyEditorTo(data);
        this.myInstallation.getConfigSupport().writeToServer(data);
    }

    private void doImport() {
        DMServerIntegrationData data = new DMServerIntegrationData(this.myInstallationHomeField.getText());
        this.myInstallation.getConfigSupport().readFromServer(data);
        data.setReloadRequired(false);
        this.loadFieldsFrom(data);
    }

    public PathResolver getPathResolver() {
        return this.myPathResolver;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JButton jButton;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox3;
        JSpinner jSpinner;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JSpinner jSpinner2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.server.configuration"), (int)0, (int)0, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel4.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.common"), null, jPanel5, null);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.deployer.timeout"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeployerTimeoutField = jSpinner2 = new JSpinner();
        jSpinner2.setAlignmentX(0.5f);
        jSpinner2.setDoubleBuffered(false);
        jPanel5.add((Component)jSpinner2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.pickup.directory"));
        jPanel5.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPickupDirectoryField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.dmshell.port"));
        jPanel5.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShellPortField = jSpinner = new JSpinner();
        jSpinner.setAlignmentX(0.5f);
        ((Component)jSpinner).setEnabled(true);
        jPanel5.add((Component)jSpinner, new GridConstraints(2, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        this.myShellEnabledCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.dmshell.enabled"));
        jCheckBox3.setAlignmentX(0.5f);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.server.dumps.folder"));
        jPanel5.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerLogsRootFolder = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myLogSystemOutCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.log.system.out"));
        jCheckBox2.setAlignmentX(0.5f);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(284, 22), null));
        this.myLogSystemErrCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.log.system.err"));
        jCheckBox.setAlignmentX(0.5f);
        jPanel5.add((Component)jCheckBox, new GridConstraints(4, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRepositoryPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.repository"), null, jPanel2, null);
        this.myReadErrorLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.warning.cant.read.config"));
        jPanel4.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(4, 0, 0, 0), -1, -1, false, false));
        jPanel6.setAlignmentX(0.0f);
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myImportButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.reload"));
        jPanel6.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 1, 1, 1, 0, null, null, null));
        this.myExportButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.update.server"));
        jPanel6.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 1, 1, 1, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.dmserver.home"));
        jPanel7.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstallationHomeField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 7, 3, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.osgi.framework"));
        jPanel7.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworkNameField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel7.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(290, 20), null));
        this.myEditFrameworkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.edit"));
        jPanel7.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 0, 1, 1, 0, null, null, null));
        this.myStatusPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        this.myStatusValidLabel = jBLabel2 = new JBLabel();
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.status.path.is.valid"));
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel.add((Component)jBLabel2, "valid");
        this.myStatusErrorLabel = jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerIntegrationEditor.status.path.is.invalid"));
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel.add((Component)jBLabel, "error");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

