/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.editors;

import com.intellij.javaee.model.xml.ejb.EjbRelationshipRole;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.editors.RdbmsHelper;
import com.intellij.javaee.weblogic.model.persistence.ColumnMap;
import com.intellij.javaee.weblogic.model.persistence.RelationshipRoleMap;
import com.intellij.javaee.weblogic.model.persistence.TableMap;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsRelation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.util.xml.ui.ChildGenericValueColumnInfo;
import com.intellij.util.xml.ui.ComboControl;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomCollectionControl;
import com.intellij.util.xml.ui.DomTableView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TableColumnsMappingConfigurable
extends CompositeCommittable
implements CommittablePanel {
    private JPanel myPanel;
    private JPanel myTablePanel;
    private JComboBox myPKTableName;
    private JComboBox myFKTableName;
    private JLabel myForeignTableNameLabel;
    private final RdbmsHelper myRdbmsHelper;

    public TableColumnsMappingConfigurable(final RdbmsHelper helper, boolean showForeignColumn) {
        this.myRdbmsHelper = helper;
        this.$$$setupUI$$$();
        RelationshipRoleMap map = (RelationshipRoleMap)helper.getRdbmsRelationRole().getRelationshipRoleMap().createStableCopy();
        ((ComboControl)this.addComponent((Committable)new ComboControl(map.getPrimaryKeyTable(), (Factory)new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                return ContainerUtil.map((Collection)TableColumnsMappingConfigurable.this.getTableNames(helper.getRole()), (Function)Pair.createFunction(null));
            }
        }))).bind((JComponent)this.myPKTableName);
        if (showForeignColumn) {
            ((ComboControl)this.addComponent((Committable)new ComboControl(map.getForeignKeyTable(), (Factory)new Factory<List<Pair<String, Icon>>>(){

                public List<Pair<String, Icon>> create() {
                    return ContainerUtil.map((Collection)TableColumnsMappingConfigurable.this.getTableNames(helper.getTargetRole()), (Function)Pair.createFunction(null));
                }
            }))).bind((JComponent)this.myFKTableName);
        }
        DomTableView collectionPanel = new DomTableView(helper.getProject()){

            protected void tuneTable(JTable table) {
                table.setRowHeight(new JComboBox<E>().getPreferredSize().height);
            }
        };
        this.myTablePanel.setLayout(new BorderLayout());
        this.myTablePanel.add((Component)collectionPanel);
        DomGenericInfo info = map.getManager().getGenericInfo(ColumnMap.class);
        ComboTableCellEditor pkEditor = new ComboTableCellEditor((Factory)new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                return ContainerUtil.map(TableColumnsMappingConfigurable.this.myRdbmsHelper.getSuitableNames(TableColumnsMappingConfigurable.this.myPKTableName, helper.getRole(), true), (Function)Pair.createFunction(null));
            }
        }, false);
        ComboTableCellEditor fkEditor = new ComboTableCellEditor((Factory)new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                return ContainerUtil.map(TableColumnsMappingConfigurable.this.myRdbmsHelper.getSuitableNames(TableColumnsMappingConfigurable.this.myFKTableName, helper.getTargetRole(), true), (Function)Pair.createFunction(null));
            }
        }, false);
        DomCollectionControl<ColumnMap> control = new DomCollectionControl<ColumnMap>((DomElement)map, "column-map", false, new ColumnInfo[]{new ChildGenericValueColumnInfo(WeblogicBundle.message("table.column.mappings.editor.pk.column.column.name", new Object[0]), info.getFixedChildDescription("key-column"), (TableCellEditor)pkEditor), new ChildGenericValueColumnInfo(WeblogicBundle.message("table.column.mappings.editor.fk.column.column.name", new Object[0]), info.getFixedChildDescription("foreign-key-column"), (TableCellEditor)fkEditor)}){

            protected AnAction[] createAdditionActions() {
                return new AnAction[]{new DomCollectionControl.ControlAddAction(WeblogicBundle.message("action.name.add.mapping", new Object[0])){

                    protected void tuneNewValue(ColumnMap columnMap) {
                        columnMap.getKeyColumn().setValue((Object)WeblogicBundle.message("column.name.create.mapping.pk.column", new Object[0]));
                        columnMap.getForeignKeyColumn().setValue((Object)WeblogicBundle.message("column.name.create.mapping.fk.column", new Object[0]));
                    }
                }};
            }
        };
        control.bind((JComponent)collectionPanel);
        this.addComponent((Committable)control);
        if (!showForeignColumn) {
            this.myFKTableName.setVisible(false);
            this.myForeignTableNameLabel.setVisible(false);
        }
    }

    public WeblogicRdbmsRelation getWeblogicRdbmsRelation() {
        return this.myRdbmsHelper.getRdbmsRelation();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private List<String> getTableNames(EjbRelationshipRole role) {
        WeblogicRdbmsBean rdbmsBeanObject = this.myRdbmsHelper.getRdbmsBeanObject(role);
        if (rdbmsBeanObject == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List(rdbmsBeanObject.getTableMaps(), (Function)new Function<TableMap, String>(){

            public String fun(TableMap s) {
                return (String)s.getTableName().getValue();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myForeignTableNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.configure.relations.fk.table"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.configure.relations.pk.table"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPKTableName = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFKTableName = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel2.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

