/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.configuration;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.oss.util.RemoteConnectionTester;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.weblogic.agent.WebLogicTargetType;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class WeblogicRemoteEditor
extends SettingsEditor<CommonModel>
implements PanelWithAnchor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.weblogic.runDebug.configuration.WeblogicRemoteEditor");
    private JButton myTestConnectionButton;
    private JPanel myPanel;
    private JPasswordField myPassword;
    private JTextField myUser;
    private JTextField myServerField;
    private JRadioButton myAdminServerRadioButton;
    private JRadioButton myManagedServerRadioButton;
    private JRadioButton myClusterRadioButton;
    private JTextField myManagedServerField;
    private JTextField myAdminHostField;
    private JTextField myAdminPortField;
    private JPanel myServerSettingsPanel;
    private JTextField myClusterAdminServerField;
    private JTextField myClusterNameField;
    private JBLabel myConnectToLabel;
    private JBLabel myAdminServerNameLabel;
    private JBLabel myManagedServerNameLabel;
    private JBLabel myServerLabel;
    private JComponent anchor;
    private final List<ConnectBehavior> myConnectBehaviors;

    public WeblogicRemoteEditor(Project project) {
        this.$$$setupUI$$$();
        final RemoteConnectionTester connectionTester = new RemoteConnectionTester(project, this){

            protected String getConnectErrorMessage(Exception exception) {
                return WeblogicRemoteEditor.adjustErrorMessage(super.getConnectErrorMessage(exception));
            }
        };
        this.myTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                connectionTester.testConnection();
            }
        });
        this.myConnectBehaviors = new ArrayList<ConnectBehavior>();
        this.myConnectBehaviors.add(new ConnectBehavior(this.myAdminServerRadioButton, "admin"){

            @Override
            protected void doApplyEditorTo(WeblogicModel wl) throws ConfigurationException {
                wl.setTargetType(WebLogicTargetType.TYPE_SERVER);
                wl.CONNECT_TO_MANAGED_SERVER = false;
                wl.SERVER_NAME = WeblogicRemoteEditor.this.myServerField.getText();
            }

            @Override
            protected boolean isMyBehavior(WeblogicModel wl) {
                return !wl.CONNECT_TO_MANAGED_SERVER && wl.getTargetType() == WebLogicTargetType.TYPE_SERVER;
            }

            @Override
            protected void doResetEditorFrom(WeblogicModel wl) {
                WeblogicRemoteEditor.this.myServerField.setText(wl.SERVER_NAME);
            }
        });
        this.myConnectBehaviors.add(new ConnectBehavior(this.myManagedServerRadioButton, "managed"){

            @Override
            protected void doApplyEditorTo(WeblogicModel wl) throws ConfigurationException {
                wl.setTargetType(WebLogicTargetType.TYPE_SERVER);
                wl.CONNECT_TO_MANAGED_SERVER = true;
                wl.SERVER_NAME = WeblogicRemoteEditor.this.myManagedServerField.getText();
                this.saveAdminData(wl, WeblogicRemoteEditor.this.myAdminHostField, WeblogicRemoteEditor.this.myAdminPortField);
            }

            @Override
            protected boolean isMyBehavior(WeblogicModel wl) {
                return wl.CONNECT_TO_MANAGED_SERVER;
            }

            @Override
            protected void doResetEditorFrom(WeblogicModel wl) {
                WeblogicRemoteEditor.this.myManagedServerField.setText(wl.SERVER_NAME);
                this.loadAdminData(wl, WeblogicRemoteEditor.this.myAdminHostField, WeblogicRemoteEditor.this.myAdminPortField);
            }

            private void saveAdminData(WeblogicModel wl, JTextField hostField, JTextField portField) throws ConfigurationException {
                wl.ADMIN_SERVER_HOST = hostField.getText();
                try {
                    wl.ADMIN_SERVER_PORT = Integer.parseInt(portField.getText());
                }
                catch (NumberFormatException ignore) {
                    throw new ConfigurationException(J2EEBundle.message((String)"exception.text.invalid.port.value", (Object[])new Object[]{portField.getText()}));
                }
            }

            private void loadAdminData(WeblogicModel wl, JTextField hostField, JTextField portField) {
                hostField.setText(wl.ADMIN_SERVER_HOST);
                portField.setText(String.valueOf(wl.ADMIN_SERVER_PORT));
            }
        });
        this.myConnectBehaviors.add(new ConnectBehavior(this.myClusterRadioButton, "cluster"){

            @Override
            protected void doApplyEditorTo(WeblogicModel wl) throws ConfigurationException {
                wl.setTargetType(WebLogicTargetType.TYPE_CLUSTER);
                wl.CONNECT_TO_MANAGED_SERVER = false;
                wl.CLUSTER_NAME = WeblogicRemoteEditor.this.myClusterNameField.getText();
                wl.SERVER_NAME = WeblogicRemoteEditor.this.myClusterAdminServerField.getText();
            }

            @Override
            protected boolean isMyBehavior(WeblogicModel wl) {
                return !wl.CONNECT_TO_MANAGED_SERVER && wl.getTargetType() == WebLogicTargetType.TYPE_CLUSTER;
            }

            @Override
            protected void doResetEditorFrom(WeblogicModel wl) {
                WeblogicRemoteEditor.this.myClusterNameField.setText(wl.CLUSTER_NAME);
                WeblogicRemoteEditor.this.myClusterAdminServerField.setText(wl.SERVER_NAME);
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WeblogicRemoteEditor.this.showServerSettings();
            }
        };
        for (ConnectBehavior connectBehavior : this.myConnectBehaviors) {
            connectBehavior.getRadioButton().addActionListener(listener);
        }
        this.setAnchor((JComponent)this.myManagedServerNameLabel);
    }

    private void showServerSettings() {
        for (ConnectBehavior connectBehavior : this.myConnectBehaviors) {
            if (!connectBehavior.showCard()) continue;
            return;
        }
    }

    public void applyEditorTo(CommonModel configuration) throws ConfigurationException {
        WeblogicModel wl = (WeblogicModel)configuration.getServerModel();
        wl.USERNAME = this.myUser.getText();
        wl.PASSWORD = new String(this.myPassword.getPassword());
        for (ConnectBehavior connectBehavior : this.myConnectBehaviors) {
            if (!connectBehavior.applyEditorTo(wl)) continue;
            return;
        }
    }

    public void resetEditorFrom(CommonModel configuration) {
        WeblogicModel wl = (WeblogicModel)configuration.getServerModel();
        this.myUser.setText(wl.USERNAME);
        this.myPassword.setText(wl.PASSWORD);
        for (ConnectBehavior connectBehavior : this.myConnectBehaviors) {
            if (connectBehavior.resetEditorFrom(wl)) break;
        }
        this.showServerSettings();
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicRemoteEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myConnectToLabel.setAnchor(anchor);
        this.myAdminServerNameLabel.setAnchor(anchor);
        this.myManagedServerNameLabel.setAnchor(anchor);
        this.myServerLabel.setAnchor(anchor);
    }

    private static String adjustErrorMessage(String message) {
        int index;
        if (message == null) {
            return "";
        }
        for (index = message.length() - 1; index > 0 && Character.isWhitespace(message.charAt(index)); --index) {
        }
        String[] strings = message.substring(0, index + 1).split(";");
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            if (builder.length() > 0) {
                builder.append(";\n");
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n' || c == '\r' || c == '\t') continue;
                builder.append(c);
            }
        }
        return builder.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JBLabel jBLabel;
        JPasswordField jPasswordField;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JBLabel jBLabel2;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JBLabel jBLabel3;
        JTextField jTextField7;
        JBLabel jBLabel4;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, "admin");
        this.myServerLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.server.name.text"));
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerField = jTextField7 = new JTextField();
        jPanel3.add((Component)jTextField7, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "managed");
        this.myManagedServerNameLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.managed.server.name"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManagedServerField = jTextField6 = new JTextField();
        jPanel4.add((Component)jTextField6, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.admin.server.host"));
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdminHostField = jTextField5 = new JTextField();
        jPanel4.add((Component)jTextField5, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.admin.server.port"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdminPortField = jTextField4 = new JTextField();
        jPanel4.add((Component)jTextField4, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "cluster");
        this.myAdminServerNameLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.admin.server.name"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClusterAdminServerField = jTextField3 = new JTextField();
        jPanel5.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.cluster.name"));
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClusterNameField = jTextField2 = new JTextField();
        jPanel5.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.user"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUser = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.password"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassword = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        this.myConnectToLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.remote.configuration.connect.to"));
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myAdminServerRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("radio.remote.configuration.admin.server"));
        jRadioButton3.setSelected(true);
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myManagedServerRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("radio.remote.configuration.managed.server"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClusterRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("radio.remote.configuration.cluster"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("button.test.connection"));
        jPanel2.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        jBLabel4.setLabelFor(jTextField7);
        jBLabel3.setLabelFor(jTextField6);
        jLabel.setLabelFor(jTextField5);
        jLabel2.setLabelFor(jTextField4);
        jBLabel2.setLabelFor(jTextField6);
        jLabel4.setLabelFor(jTextField);
        jLabel5.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private abstract class ConnectBehavior {
        private JRadioButton myRadioButton;
        private String myCardName;

        public ConnectBehavior(@NonNls JRadioButton radioButton, String cardName) {
            this.myRadioButton = radioButton;
            this.myCardName = cardName;
        }

        public boolean showCard() {
            if (!this.myRadioButton.isSelected()) {
                return false;
            }
            ((CardLayout)WeblogicRemoteEditor.this.myServerSettingsPanel.getLayout()).show(WeblogicRemoteEditor.this.myServerSettingsPanel, this.myCardName);
            return true;
        }

        public JRadioButton getRadioButton() {
            return this.myRadioButton;
        }

        public boolean applyEditorTo(WeblogicModel wl) throws ConfigurationException {
            if (!this.myRadioButton.isSelected()) {
                return false;
            }
            this.doApplyEditorTo(wl);
            return true;
        }

        public boolean resetEditorFrom(WeblogicModel wl) {
            if (!this.isMyBehavior(wl)) {
                return false;
            }
            this.doResetEditorFrom(wl);
            this.myRadioButton.setSelected(true);
            return true;
        }

        protected abstract void doApplyEditorTo(WeblogicModel var1) throws ConfigurationException;

        protected abstract void doResetEditorFrom(WeblogicModel var1);

        protected abstract boolean isMyBehavior(WeblogicModel var1);
    }
}

