/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.build;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.make.report.CompileReportSource;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.gwt.packaging.GwtCompilerOutputElementType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;

public class GwtBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    private static final Key<CompileReportSource> COMPILE_REPORT_SOURCE_KEY = Key.create((String)"GWT_COMPILE_REPORT_SOURCE");

    public static Set<GwtFacet> getFacetsToBuild(Project project, CompileScope compileScope) {
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)compileScope, (boolean)false);
        return GwtBuildTargetScopeProvider.getFacetsIncludedInArtifacts(artifacts, project);
    }

    @Nullable
    public static CompileReportSource getCompileReportSource(CompileScope scope) {
        return (CompileReportSource)scope.getUserData(COMPILE_REPORT_SOURCE_KEY);
    }

    public static void setGenerateCompileReportOption(@NotNull CompileScope scope, @NotNull CompileReportSource source) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "setGenerateCompileReportOption"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "setGenerateCompileReportOption"));
        }
        scope.putUserData(COMPILE_REPORT_SOURCE_KEY, (Object)source);
    }

    private static Set<GwtFacet> getFacetsIncludedInArtifacts(final Collection<? extends Artifact> artifacts, final Project project) {
        final HashSet<GwtFacet> facets = new HashSet<GwtFacet>();
        new ReadAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/build/GwtBuildTargetScopeProvider$1", "run"));
                }
                for (Artifact artifact : artifacts) {
                    PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
                    ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)GwtCompilerOutputElementType.getInstance(), (Processor)new Processor<GwtCompilerOutputElement>(){

                        public boolean process(GwtCompilerOutputElement element) {
                            ContainerUtil.addIfNotNull((Object)((Object)element.getFacet()), (Collection)facets);
                            return true;
                        }
                    }, (PackagingElementResolvingContext)context, (boolean)true);
                }
            }
        }.execute();
        return facets;
    }

    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(final @NotNull CompileScope baseScope, @NotNull CompilerFilter filter, final @NotNull Project project, boolean forceBuild) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        Set facets = (Set)new ReadAction<Set<GwtFacet>>(){

            protected void run(@NotNull Result<Set<GwtFacet>> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/build/GwtBuildTargetScopeProvider$2", "run"));
                }
                Set<GwtFacet> facets = GwtBuildTargetScopeProvider.getFacetsToBuild(project, baseScope);
                CompileReportSource reportSource = GwtBuildTargetScopeProvider.getCompileReportSource(baseScope);
                if (reportSource != null) {
                    facets.add(reportSource.getFacet());
                }
                result.setResult(facets);
            }
        }.execute().getResultObject();
        if (!facets.isEmpty()) {
            ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder gwtScope = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId("gwt").setForceBuild(ArtifactCompileScope.isArtifactRebuildForced((CompileScope)baseScope));
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder modulesScope = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(JavaModuleBuildTargetType.PRODUCTION.getTypeId()).setForceBuild(forceBuild);
            for (GwtFacet facet : facets) {
                String moduleName = facet.getModule().getName();
                gwtScope.addTargetId(moduleName);
                modulesScope.addTargetId(moduleName);
            }
            scopes.add(gwtScope.build());
            scopes.add(modulesScope.build());
            ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> arrayList = scopes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "getBuildTargetScopes"));
            }
            return arrayList;
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/build/GwtBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        return list;
    }
}

