/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRawAsyncCallbackInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtRawAsyncCallbackInspection");

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, final @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtRawAsyncCallbackInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null || !gwtFacet.getSdkVersion().isGenericsSupported()) {
            return null;
        }
        PsiClass sync = RemoteServiceUtil.findSynchronousInterface(aClass);
        if (sync != null) {
            return GwtRawAsyncCallbackInspection.checkAsynchronousInterface(aClass, sync, manager, isOnTheFly);
        }
        SmartList problems = new SmartList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor((List)problems, isOnTheFly){
            final /* synthetic */ List val$problems;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problems = list;
                this.val$isOnTheFly = bl;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiClass async;
                PsiClass sync;
                PsiMethod method = expression.resolveMethod();
                if (method != null && (sync = RemoteServiceUtil.findSynchronousInterface(async = method.getContainingClass())) != null) {
                    GwtRawAsyncCallbackInspection.checkAsyncMethod(method, sync, manager, this.val$problems, expression, this.val$isOnTheFly);
                }
            }
        };
        aClass.accept((PsiElementVisitor)visitor);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static ProblemDescriptor[] checkAsynchronousInterface(@NotNull PsiClass async, @NotNull PsiClass sync, InspectionManager manager, boolean isOnTheFly) {
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "checkAsynchronousInterface"));
        }
        if (sync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sync", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "checkAsynchronousInterface"));
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod method : async.getMethods()) {
            GwtRawAsyncCallbackInspection.checkAsyncMethod(method, sync, manager, problems, null, isOnTheFly);
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkAsyncMethod(PsiMethod method, PsiClass sync, InspectionManager manager, List<ProblemDescriptor> problems, @Nullable PsiMethodCallExpression expression, boolean onTheFly) {
        PsiReferenceParameterList parameterList;
        PsiAnonymousClass anonymousClass;
        PsiExpression lastArg;
        PsiExpression[] arguments;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiParameter lastParameter = parameters[parameters.length - 1];
        PsiType type = lastParameter.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass psiClass = classType.resolve();
        if (psiClass == null || !"com.google.gwt.user.client.rpc.AsyncCallback".equals(psiClass.getQualifiedName())) {
            return;
        }
        PsiMethod syncMethod = RemoteServiceUtil.findMethodInSync(method, sync);
        if (syncMethod == null) {
            return;
        }
        PsiType returnType = syncMethod.getReturnType();
        if (PsiType.VOID.equals((Object)returnType) || returnType == null) {
            return;
        }
        PsiAnonymousClass rawAnonymous = null;
        if (expression != null && (arguments = expression.getArgumentList().getExpressions()).length == parameters.length && (lastArg = arguments[arguments.length - 1]) instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)lastArg).getAnonymousClass()) != null && (parameterList = anonymousClass.getBaseClassReference().getParameterList()) != null && parameterList.getTypeParameterElements().length == 0) {
            rawAnonymous = anonymousClass;
        }
        if (classType.isRaw() || rawAnonymous != null) {
            PsiMethod methodToFix = classType.isRaw() ? method : null;
            GenerifyAsyncCallbackFix fix = new GenerifyAsyncCallbackFix(returnType, methodToFix, rawAnonymous);
            String methodDescription = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            String message = GwtBundle.message("problem.description.raw.use.of.async.callback.interface", methodDescription);
            PsiElement place = rawAnonymous != null ? GwtRawAsyncCallbackInspection.getElementToHighlight(rawAnonymous) : (expression != null ? expression : lastParameter);
            problems.add(manager.createProblemDescriptor(place, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.raw.use.of.async.callback.in.asynchronous.service.interfaces", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("gwtRawAsyncCallback" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "getShortName"));
        }
        return "gwtRawAsyncCallback";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    private static class GenerifyAsyncCallbackFix
    extends BaseGwtLocalQuickFix {
        private final PsiType myType;
        private final PsiMethod myMethodToFix;
        private final PsiAnonymousClass myAnonymousToFix;

        private GenerifyAsyncCallbackFix(@NotNull PsiType type, @Nullable PsiMethod methodToFix, @Nullable PsiAnonymousClass anonymousToFix) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "<init>"));
            }
            super(GwtBundle.message("quickfix.name.replace.async.callback.by.async.callback.0", type.getCanonicalText()));
            this.myType = type;
            this.myMethodToFix = methodToFix;
            this.myAnonymousToFix = anonymousToFix;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "applyFix"));
            }
            ArrayList<VirtualFile> affectedFiles = new ArrayList<VirtualFile>();
            if (this.myMethodToFix != null) {
                affectedFiles.add(this.myMethodToFix.getContainingFile().getVirtualFile());
            }
            if (this.myAnonymousToFix != null) {
                affectedFiles.add(this.myAnonymousToFix.getContainingFile().getVirtualFile());
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(VfsUtil.toVirtualFileArray(affectedFiles)).hasReadonlyFiles()) {
                return;
            }
            try {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                if (this.myMethodToFix != null) {
                    GenerifyAsyncCallbackFix.generifyMethod(this.myMethodToFix, this.myType, elementFactory);
                }
                if (this.myAnonymousToFix != null) {
                    GenerifyAsyncCallbackFix.generifyAnonymous(this.myAnonymousToFix, this.myType, project, elementFactory);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static void generifyAnonymous(@NotNull PsiAnonymousClass anonymous, @NotNull PsiType type, Project project, PsiElementFactory elementFactory) throws IncorrectOperationException {
            PsiMethod[] methods;
            if (anonymous == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymous", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "generifyAnonymous"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "generifyAnonymous"));
            }
            PsiReferenceParameterList list = anonymous.getBaseClassReference().getParameterList();
            if (list != null) {
                list.add((PsiElement)elementFactory.createTypeElement(type));
            }
            for (PsiMethod method : methods = anonymous.findMethodsByName("onSuccess", false)) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length != 1) continue;
                PsiParameter parameter = parameters[0];
                if (!PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)anonymous.getResolveScope()).equals((Object)parameter.getType())) continue;
                parameter.getTypeElement().replace((PsiElement)elementFactory.createTypeElement(type));
                break;
            }
        }

        private static void generifyMethod(@NotNull PsiMethod method, @NotNull PsiType type, PsiElementFactory elementFactory) throws IncorrectOperationException {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "generifyMethod"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix", "generifyMethod"));
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length == 0) {
                return;
            }
            PsiParameter last = parameters[parameters.length - 1];
            last.getTypeElement().replace((PsiElement)elementFactory.createTypeElement((PsiType)RemoteServiceUtil.createAsyncCallbackType((PsiElement)method, type)));
        }
    }
}

