/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.rpc.GwtServletUtil;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtServiceNotRegisteredInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtServiceNotRegisteredInspection");
    private static final ExtensionPointName<Condition<PsiClass>> UNREGISTERED_SERVLET_FILTERS = ExtensionPointName.create((String)"com.intellij.gwt.unregisteredServletFilter");

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.gwt.remote.service.is.not.registered.in.web.xml", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GwtServiceNotRegistered" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection", "getShortName"));
        }
        return "GwtServiceNotRegistered";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection", "checkFile"));
        }
        if (!DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName().equals(file.getName())) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)file);
        if (webFacet == null) {
            return null;
        }
        GwtFacet gwtFacet = GwtFacet.getInstance(webFacet.getModule());
        if (gwtFacet == null) {
            return null;
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null || !file.equals(webApp.getContainingFile())) {
            return null;
        }
        HashMap<Object, Pair> expectedUrlPatterns = new HashMap<Object, Pair>();
        HashMap<Object, String> serviceNames = new HashMap<Object, String>();
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(manager.getProject());
        for (Object servlet : webApp.getServlets()) {
            GwtModule gwtModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            PsiClass serviceInterface;
            PsiClass servletClass = (PsiClass)servlet.getServletClass().getValue();
            if (servletClass == null || !RemoteServiceUtil.isRemoteServiceImplementation(servletClass) || (serviceInterface = RemoteServiceUtil.findRemoteServiceInterface(servletClass)) == null || (psiFile = serviceInterface.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null || (gwtModule = gwtModulesManager.findGwtModuleByClientSourceFile(virtualFile)) == null) continue;
            String serviceName = serviceInterface.getName();
            expectedUrlPatterns.put(servlet, Pair.create((Object)gwtModule, (Object)GwtServletUtil.getServletPath(gwtModule, serviceName, servletClass)));
            serviceNames.put(servlet, serviceName);
        }
        HashMap<CommonServlet, ServletMapping> singleMappings = new HashMap<CommonServlet, ServletMapping>();
        for (ServletMapping mapping : webApp.getServletMappings()) {
            CommonServlet servlet = (CommonServlet)mapping.getServletName().getValue();
            if (servlet == null) continue;
            Pair urlPattern = (Pair)expectedUrlPatterns.get(servlet);
            if (singleMappings.containsKey(servlet)) {
                singleMappings.remove(servlet);
            } else {
                singleMappings.put(servlet, mapping);
            }
            if (urlPattern == null || !GwtServiceNotRegisteredInspection.containsServletPath(mapping, (GwtModule)urlPattern.getFirst(), (String)urlPattern.getSecond(), gwtFacet.getModule())) continue;
            expectedUrlPatterns.remove(servlet);
        }
        if (expectedUrlPatterns.isEmpty()) {
            return null;
        }
        SmartList problems = new SmartList();
        for (CommonServlet servlet : expectedUrlPatterns.keySet()) {
            List urlPatterns;
            ServletMapping mapping = (ServletMapping)singleMappings.get(servlet);
            String serviceName = (String)serviceNames.get(servlet);
            Pair pair = (Pair)expectedUrlPatterns.get(servlet);
            String urlPattern = GwtServletUtil.getServletUrlPattern(gwtFacet, (GwtModule)pair.getFirst(), (String)pair.getSecond());
            AddServletMappingFix quickfix = new AddServletMappingFix(webApp, servlet, serviceName, urlPattern, mapping);
            List list = urlPatterns = mapping != null ? mapping.getUrlPatterns() : Collections.emptyList();
            if (urlPatterns.size() != 1) {
                String message = GwtBundle.message("problem.description.correct.servlet.mapping.is.not.specified.for.remote.service.0", serviceName);
                XmlToken token = (XmlToken)ObjectUtils.assertNotNull((Object)XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)ObjectUtils.assertNotNull((Object)servlet.getXmlTag()))));
                problems.add(manager.createProblemDescriptor((PsiElement)token, message, (LocalQuickFix)quickfix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            XmlTag tag = (XmlTag)ObjectUtils.assertNotNull((Object)((GenericDomValue)urlPatterns.get(0)).getXmlTag());
            String message = GwtBundle.message("problem.description.incorrect.servlet.mapping.for.remote.service.0", serviceName);
            problems.add(manager.createProblemDescriptor((PsiElement)tag, XmlTagUtil.getTrimmedValueRange((XmlTag)tag), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{quickfix}));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static boolean containsServletPath(ServletMapping mapping, GwtModule serviceModule, String relativePath, Module module) {
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(module.getProject());
        for (GenericDomValue pattern : mapping.getUrlPatterns()) {
            String urlPattern = (String)pattern.getValue();
            if (urlPattern == null || !urlPattern.endsWith(relativePath)) continue;
            String modulePath = StringUtil.trimEnd((String)StringUtil.trimStart((String)urlPattern.substring(0, urlPattern.length() - relativePath.length()), (String)"/"), (String)"/");
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            Collection<GwtModule> gwtModules = gwtModulesManager.findGwtModulesByOutputName(modulePath, scope);
            for (GwtModule gwtModule : gwtModules) {
                if (!gwtModulesManager.isInheritedOrSelf(gwtModule, serviceModule)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection", "checkClass"));
        }
        if (!GwtServiceNotRegisteredInspection.shouldCheck((PsiElement)aClass)) {
            return null;
        }
        Project project = manager.getProject();
        if (!RemoteServiceUtil.isRemoteServiceImplementation(aClass)) {
            return null;
        }
        PsiClass service = RemoteServiceUtil.findRemoteServiceInterface(aClass);
        if (service == null) {
            return null;
        }
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
        VirtualFile virtualFile = service.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        GwtModule gwtModule = gwtModulesManager.findGwtModuleByClientSourceFile(virtualFile);
        if (gwtModule == null) {
            return null;
        }
        Module module = gwtModule.getModule();
        if (module == null) {
            return null;
        }
        GwtFacet facet = GwtFacet.findFacetBySourceFile(project, gwtModule.getModuleFile());
        if (facet == null) {
            return null;
        }
        for (Condition condition : (Condition[])UNREGISTERED_SERVLET_FILTERS.getExtensions()) {
            if (!condition.value((Object)aClass)) continue;
            return null;
        }
        String serviceName = service.getName();
        WebFacet webFacet = facet.getWebFacet();
        if (webFacet == null) {
            LocalQuickFix[] quickFixes;
            if (!facet.getSdkVersion().isHostedModeRequiresWebXml()) {
                return null;
            }
            String message = GwtBundle.message("problem.description.remote.service.is.not.registered.as.a.servlet.in.web.xml", serviceName);
            Collection webFacets = WebFacet.getInstances((Module)module);
            if (webFacets.isEmpty()) {
                quickFixes = new LocalQuickFix[]{new CreateWebFacetAndRegisterQuickFix(facet, gwtModule, aClass, serviceName)};
            } else {
                ArrayList<RegisterServiceQuickFix> fixes = new ArrayList<RegisterServiceQuickFix>();
                for (WebFacet web : webFacets) {
                    WebApp webApp = web.getRoot();
                    if (webApp == null) continue;
                    fixes.add(new RegisterServiceQuickFix(facet, gwtModule, webApp, aClass, serviceName, web));
                }
                quickFixes = fixes.toArray(new LocalQuickFix[fixes.size()]);
            }
            return new ProblemDescriptor[]{manager.createProblemDescriptor(GwtServiceNotRegisteredInspection.getElementToHighlight(aClass), message, isOnTheFly, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null) {
            return null;
        }
        Servlet servlet = GwtServletUtil.findServlet(webApp, aClass);
        if (servlet == null) {
            String message = GwtBundle.message("problem.description.remote.service.is.not.registered.as.a.servlet.in.web.xml", serviceName);
            RegisterServiceQuickFix quickFix = new RegisterServiceQuickFix(facet, gwtModule, webApp, aClass, serviceName, webFacet);
            return new ProblemDescriptor[]{manager.createProblemDescriptor(GwtServiceNotRegisteredInspection.getElementToHighlight(aClass), message, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
        }
        return null;
    }

    private static class AddServletMappingFix
    implements LocalQuickFix {
        private final WebApp myRoot;
        private final CommonServlet myServlet;
        private final String myServiceName;
        private final String myUrlPattern;
        private final ServletMapping myExistingMapping;

        public AddServletMappingFix(WebApp root, CommonServlet servlet, String serviceName, String urlPattern, ServletMapping existentMapping) {
            this.myRoot = root;
            this.myServlet = servlet;
            this.myServiceName = serviceName;
            this.myUrlPattern = urlPattern;
            this.myExistingMapping = existentMapping;
        }

        @NotNull
        public String getName() {
            String string = this.myExistingMapping == null || this.myExistingMapping.getUrlPatterns().size() > 1 ? GwtBundle.message("quickfix.name.add.servlet.mapping.for.remote.service.0", this.myServiceName) : GwtBundle.message("quickfix.name.set.correct.servlet.mapping.for.remote.service.0", this.myServiceName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$AddServletMappingFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$AddServletMappingFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$AddServletMappingFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$AddServletMappingFix", "applyFix"));
            }
            if (this.myExistingMapping == null) {
                GwtServletUtil.addServletMapping(this.myRoot, this.myServlet, this.myUrlPattern);
            } else {
                List urlPatterns = this.myExistingMapping.getUrlPatterns();
                if (urlPatterns.size() == 1) {
                    ((GenericDomValue)urlPatterns.get(0)).setValue((Object)this.myUrlPattern);
                } else {
                    this.myExistingMapping.addUrlPattern().setValue((Object)this.myUrlPattern);
                }
            }
        }
    }

    private static class RegisterServiceQuickFix
    extends BaseGwtLocalQuickFix {
        protected final GwtFacet myFacet;
        private final GwtModule myGwtModule;
        private final WebApp myWebApp;
        private final PsiClass myServiceImpl;
        private final String myServiceName;
        private final WebFacet myWebFacet;

        public RegisterServiceQuickFix(GwtFacet facet, GwtModule gwtModule, WebApp webApp, PsiClass serviceImpl, String serviceName, @NotNull WebFacet webFacet) {
            if (webFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$RegisterServiceQuickFix", "<init>"));
            }
            super(webFacet.equals((Object)facet.getWebFacet()) ? GwtBundle.message("quickfix.name.register.remote.service.0.in.web.xml", serviceName) : GwtBundle.message("quickfix.name.connect.gwt.facet.to.0.facet.and.register.remote.service.1.in.web.xml", webFacet.getName(), serviceName));
            this.myFacet = facet;
            this.myGwtModule = gwtModule;
            this.myWebApp = webApp;
            this.myServiceImpl = serviceImpl;
            this.myServiceName = serviceName;
            this.myWebFacet = webFacet;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$RegisterServiceQuickFix", "applyFix"));
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$RegisterServiceQuickFix", "applyFix"));
            }
            if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{DomUtil.getFile((DomElement)this.myWebApp).getVirtualFile()}).hasReadonlyFiles()) {
                if (!this.myWebFacet.equals((Object)this.myFacet.getWebFacet())) {
                    ((GwtFacetConfiguration)this.myFacet.getConfiguration()).setWebFacetName(this.myWebFacet.getName());
                }
                GwtServletUtil.registerServletForService(this.myFacet, this.myGwtModule, this.myWebApp, this.myServiceImpl, this.myServiceName);
            }
        }
    }

    private static class CreateWebFacetAndRegisterQuickFix
    extends BaseGwtLocalQuickFix {
        private final GwtFacet myFacet;
        private final GwtModule myGwtModule;
        private final PsiClass myServiceImpl;
        private final String myServiceName;

        private CreateWebFacetAndRegisterQuickFix(GwtFacet facet, GwtModule gwtModule, PsiClass serviceImpl, String serviceName) {
            super(GwtBundle.message("quickfix.name.create.web.facet.and.register.remote.service.0.in.web.xml", serviceName));
            this.myFacet = facet;
            this.myGwtModule = gwtModule;
            this.myServiceImpl = serviceImpl;
            this.myServiceName = serviceName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$CreateWebFacetAndRegisterQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$CreateWebFacetAndRegisterQuickFix", "applyFix"));
            }
            VirtualFile root = this.findContentRoot();
            LOG.assertTrue(root != null, (Object)this.myGwtModule.getModuleFile());
            WebFacet webFacet = GwtWebUtil.createWebFacet(this.myFacet, root);
            WebApp webApp = webFacet.getRoot();
            LOG.assertTrue(webApp != null);
            GwtServletUtil.registerServletForService(this.myFacet, this.myGwtModule, webApp, this.myServiceImpl, this.myServiceName);
        }

        @Nullable
        private VirtualFile findContentRoot() {
            VirtualFile[] contentRoots;
            for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getContentRoots()) {
                if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)this.myGwtModule.getModuleFile(), (boolean)false)) continue;
                return root;
            }
            return null;
        }
    }
}

