/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtClassMemberReference
extends PsiReferenceBase.Poly<JSGwtReferenceExpressionImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.jsinject.GwtClassMemberReference");
    private static final Key<Map<String, CachedValue<MultiMap<String, PsiMember>>>> CACHED_MEMBER_MAP_KEY_FOR_SDK = Key.create((String)"GWT_cached_member_signatures");
    @NonNls
    private static final String NEW_EXPRESSION = "new";
    @NonNls
    private static final Map<PsiType, String> ourPrimitiveTypes = new HashMap<PsiType, String>();
    private final PsiReference myClassReference;

    public GwtClassMemberReference(JSGwtReferenceExpressionImpl element, @Nullable PsiReference classReference, TextRange range) {
        super((PsiElement)element, range, false);
        this.myClassReference = classReference;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiClass psiClass = this.resolveQualifier();
        if (psiClass == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtClassMemberReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        MultiMap<String, PsiMember> map = this.getMembersMap(psiClass);
        if (map == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtClassMemberReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array((Collection)map.get((Object)this.getValue()), ResolveResult.class, (Function)new Function<PsiMember, ResolveResult>(){

            public ResolveResult fun(PsiMember member) {
                return new PsiElementResolveResult((PsiElement)member);
            }
        });
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtClassMemberReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiClass resolveQualifier() {
        PsiClass emulationClass;
        if (this.myClassReference == null) {
            return null;
        }
        PsiElement element = this.myClassReference.resolve();
        if (!(element instanceof PsiClass)) {
            return null;
        }
        PsiClass psiClass = (PsiClass)element;
        GwtFacet facet = GwtFacet.findFacetByPsiElement(this.myElement);
        if (facet != null && (emulationClass = ((GwtFacetConfiguration)facet.getConfiguration()).getSdk().findJreEmulationClass(psiClass)) != null) {
            return emulationClass;
        }
        return psiClass;
    }

    @Nullable
    private MultiMap<String, PsiMember> getMembersMap(final @NotNull PsiClass aClass) {
        CachedValue value;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/jsinject/GwtClassMemberReference", "getMembersMap"));
        }
        GwtFacet gwtFacet = GwtFacet.findFacetByPsiElement(this.myElement);
        final GwtSdk sdk = gwtFacet != null ? ((GwtFacetConfiguration)gwtFacet.getConfiguration()).getSdk() : null;
        String sdkUrl = sdk != null ? sdk.getHomeDirectoryUrl() : null;
        HashMap<String, CachedValue> map = (HashMap<String, CachedValue>)aClass.getUserData(CACHED_MEMBER_MAP_KEY_FOR_SDK);
        if (map == null) {
            map = new HashMap<String, CachedValue>();
            aClass.putUserData(CACHED_MEMBER_MAP_KEY_FOR_SDK, map);
        }
        if ((value = (CachedValue)map.get(sdkUrl)) == null) {
            value = CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<MultiMap<String, PsiMember>>(){

                public CachedValueProvider.Result<MultiMap<String, PsiMember>> compute() {
                    MultiMap map = GwtClassMemberReference.buildMembersMap(aClass, sdk);
                    return new CachedValueProvider.Result((Object)map, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            }, false);
            map.put(sdkUrl, value);
        }
        return (MultiMap)value.getValue();
    }

    private static MultiMap<String, PsiMember> buildMembersMap(@NotNull PsiClass aClass, @Nullable GwtSdk sdk) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/jsinject/GwtClassMemberReference", "buildMembersMap"));
        }
        MultiMap map = new MultiMap();
        GwtClassMemberReference.collectMethods(aClass, (MultiMap<String, ? super PsiMethod>)map, new HashSet<PsiClass>(), sdk);
        if (sdk == null || sdk.getVersion().isNewExpressionInJavaScriptSupported()) {
            for (PsiMethod psiMethod : aClass.getConstructors()) {
                StringBuilder signature = new StringBuilder(NEW_EXPRESSION);
                signature.append('(');
                if (!GwtClassMemberReference.appendEnclosingClassType(signature, psiMethod.getContainingClass()) || !GwtClassMemberReference.appendParameterTypes(signature, psiMethod)) continue;
                signature.append(')');
                map.putValue((Object)signature.toString(), (Object)psiMethod);
            }
            if (aClass.getConstructors().length == 0) {
                StringBuilder signature = new StringBuilder(NEW_EXPRESSION);
                signature.append('(');
                if (GwtClassMemberReference.appendEnclosingClassType(signature, aClass)) {
                    signature.append(')');
                    map.putValue((Object)signature.toString(), (Object)aClass);
                }
            }
        }
        if (aClass.isEnum()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
            try {
                PsiMethod valuesMethod = elementFactory.createMethodFromText("public static " + aClass.getName() + "[] values() {}", (PsiElement)aClass);
                map.putValue((Object)"values()", (Object)valuesMethod);
                PsiMethod valueOfMethod = elementFactory.createMethodFromText("public static " + aClass.getName() + " valueOf(String name) {}", (PsiElement)aClass);
                map.putValue((Object)"valueOf(Ljava/lang/String;)", (Object)valueOfMethod);
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
        for (PsiMethod psiMethod : aClass.getFields()) {
            map.putValue((Object)psiMethod.getName(), (Object)psiMethod);
        }
        return map;
    }

    private static void collectMethods(@NotNull PsiClass aClass, MultiMap<String, ? super PsiMethod> result, Set<PsiClass> visited, @Nullable GwtSdk sdk) {
        PsiMethod[] emulationClass;
        boolean wildcardsSupported;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/jsinject/GwtClassMemberReference", "collectMethods"));
        }
        boolean bl = wildcardsSupported = sdk == null || sdk.getVersion().isWildcardMethodReferencesInJavaScriptSupported();
        if (sdk != null && (emulationClass = sdk.findJreEmulationClass((PsiClass)aClass)) != null) {
            aClass = emulationClass;
        }
        if (!visited.add((PsiClass)aClass)) {
            return;
        }
        for (PsiMethod psiMethod : aClass.getMethods()) {
            if (psiMethod.isConstructor()) continue;
            StringBuilder signature = new StringBuilder(psiMethod.getName());
            signature.append('(');
            if (!GwtClassMemberReference.appendParameterTypes(signature, psiMethod)) continue;
            signature.append(')');
            String key = signature.toString();
            if (result.containsKey((Object)key)) continue;
            result.putValue((Object)key, (Object)psiMethod);
            if (!wildcardsSupported) continue;
            result.putValue((Object)(psiMethod.getName() + "(*)"), (Object)psiMethod);
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass != null) {
            GwtClassMemberReference.collectMethods(superClass, result, visited, sdk);
        }
        for (PsiClass psiClass : aClass.getInterfaces()) {
            GwtClassMemberReference.collectMethods(psiClass, result, visited, sdk);
        }
    }

    private static boolean appendEnclosingClassType(@NotNull StringBuilder signature, @NotNull PsiClass psiClass) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/gwt/jsinject/GwtClassMemberReference", "appendEnclosingClassType"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/jsinject/GwtClassMemberReference", "appendEnclosingClassType"));
        }
        PsiClass containingClass = psiClass.getContainingClass();
        PsiModifierList modifierList = psiClass.getModifierList();
        if (!(containingClass == null || modifierList != null && modifierList.hasModifierProperty("static"))) {
            String type = GwtClassMemberReference.getClassTypeSignature(containingClass);
            if (type == null) {
                return false;
            }
            signature.append(type);
        }
        return true;
    }

    private static boolean appendParameterTypes(StringBuilder signature, PsiMethod psiMethod) {
        for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
            String type = GwtClassMemberReference.getTypeSignature(psiParameter.getType());
            if (type == null) {
                return false;
            }
            signature.append(type);
        }
        return true;
    }

    @Nullable
    @NonNls
    private static String getTypeSignature(PsiType type) {
        if ((type = TypeConversionUtil.erasure((PsiType)type)) instanceof PsiArrayType) {
            return "[" + GwtClassMemberReference.getTypeSignature(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiPrimitiveType) {
            return ourPrimitiveTypes.get(type);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null) {
                return null;
            }
            return GwtClassMemberReference.getClassTypeSignature(psiClass);
        }
        return null;
    }

    @Nullable
    @NonNls
    private static String getClassTypeSignature(PsiClass psiClass) {
        String name = GwtClassMemberReference.getJvmClassName(psiClass);
        if (name == null) {
            return null;
        }
        return "L" + name + ";";
    }

    @Nullable
    private static String getJvmClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/jsinject/GwtClassMemberReference", "getJvmClassName"));
        }
        PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        if (parent != null) {
            return GwtClassMemberReference.getJvmClassName(parent) + "$" + psiClass.getName();
        }
        String qualifiedName = psiClass.getQualifiedName();
        return qualifiedName != null ? qualifiedName.replace('.', '/') : null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiClass = this.resolveQualifier();
        if (psiClass == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtClassMemberReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        MultiMap<String, PsiMember> map = this.getMembersMap(psiClass);
        if (map == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtClassMemberReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        HashMap<PsiMember, LookupElementBuilder> lookupItems = new HashMap<PsiMember, LookupElementBuilder>();
        for (Map.Entry entry : map.entrySet()) {
            LookupElementBuilder builder;
            Collection members = (Collection)entry.getValue();
            PsiMember member = (PsiMember)ContainerUtil.getFirstItem((Collection)members);
            if (member == null || members.size() > 1) continue;
            String lookupString = (String)entry.getKey();
            LookupElement oldItem = (LookupElement)lookupItems.get(member);
            if (oldItem != null && (oldItem.getLookupString().length() < lookupString.length() || oldItem.getLookupString().length() == lookupString.length() && !lookupString.endsWith("(*)"))) continue;
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                builder = JavaLookupElementBuilder.forMethod((PsiMethod)method, (String)lookupString, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiClass)psiClass).withInsertHandler((InsertHandler)new MethodParenthesesHandler(method, true));
                if (method.isConstructor()) {
                    builder = builder.withPresentableText(NEW_EXPRESSION);
                }
            } else if (member instanceof PsiField) {
                builder = JavaLookupElementBuilder.forField((PsiField)((PsiField)member), (String)lookupString, (PsiClass)psiClass);
            } else if (member instanceof PsiClass) {
                builder = JavaLookupElementBuilder.forClass((PsiClass)((PsiClass)member), (String)lookupString).withInsertHandler((InsertHandler)ParenthesesInsertHandler.NO_PARAMETERS);
            } else {
                LOG.error("unexpected member: " + member);
                continue;
            }
            lookupItems.put(member, builder);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (PsiMember member : (Collection)entry.getValue()) {
                LookupElement element = (LookupElement)lookupItems.get(member);
                if (element == null) continue;
                element.putUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR, (Object)Boolean.TRUE);
            }
        }
        Object[] objectArray = lookupItems.values().toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtClassMemberReference", "getVariants"));
        }
        return objectArray;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String oldText = ((JSGwtReferenceExpressionImpl)this.myElement).getText();
        String oldElementName = this.getRangeInElement().substring(oldText);
        int i = oldElementName.indexOf(40);
        if (i != -1) {
            newElementName = newElementName + oldElementName.substring(i);
        }
        String newText = this.getRangeInElement().replace(oldText, newElementName);
        ASTNode newNode = JSChangeUtil.createExpressionFromText((Project)((JSGwtReferenceExpressionImpl)this.myElement).getProject(), (String)newText, (JSLanguageDialect)JavaScriptSupportLoader.GWT_DIALECT);
        return ((JSGwtReferenceExpressionImpl)this.myElement).replace((JSExpression)newNode.getPsi());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/GwtClassMemberReference", "bindToElement"));
        }
        if (element instanceof PsiMember) {
            return this.handleElementRename(((PsiMember)element).getName());
        }
        return super.bindToElement(element);
    }

    static {
        ourPrimitiveTypes.put((PsiType)PsiType.BYTE, "B");
        ourPrimitiveTypes.put((PsiType)PsiType.CHAR, "C");
        ourPrimitiveTypes.put((PsiType)PsiType.DOUBLE, "D");
        ourPrimitiveTypes.put((PsiType)PsiType.FLOAT, "F");
        ourPrimitiveTypes.put((PsiType)PsiType.INT, "I");
        ourPrimitiveTypes.put((PsiType)PsiType.LONG, "J");
        ourPrimitiveTypes.put((PsiType)PsiType.SHORT, "S");
        ourPrimitiveTypes.put((PsiType)PsiType.BOOLEAN, "Z");
    }
}

