/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JsGwtReferenceExpressionManipulator
extends AbstractElementManipulator<JSGwtReferenceExpressionImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.jsinject.JsGwtReferenceExpressionManipulator");

    public JSGwtReferenceExpressionImpl handleContentChange(@NotNull JSGwtReferenceExpressionImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        PsiElement newElement;
        PsiElement[] children;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/JsGwtReferenceExpressionManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/gwt/jsinject/JsGwtReferenceExpressionManipulator", "handleContentChange"));
        }
        String newText = range.replace(element.getText(), newContent);
        ASTNode callExpression = JSChangeUtil.createExpressionFromText((Project)element.getProject(), (String)(newText + "()"), (JSLanguageDialect)JavaScriptSupportLoader.GWT_DIALECT);
        JSExpression referenceExpression = ((JSCallExpression)callExpression.getPsi(JSCallExpression.class)).getMethodExpression();
        LOG.assertTrue(referenceExpression != null, (Object)newText);
        if (!(referenceExpression instanceof JSGwtReferenceExpressionImpl) && (children = referenceExpression.getChildren()).length == 1) {
            referenceExpression = children[0];
        }
        if (!((newElement = element.replace((PsiElement)referenceExpression)) instanceof JSGwtReferenceExpressionImpl)) {
            LOG.error("Cannot rename injected GWT reference, newText=" + newText);
        }
        return (JSGwtReferenceExpressionImpl)newElement;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JSGwtReferenceExpressionImpl element) {
        int end;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/JsGwtReferenceExpressionManipulator", "getRangeInElement"));
        }
        String text = element.getText();
        int start = text.indexOf(64);
        if (start == -1) {
            start = 0;
        }
        if ((end = text.indexOf("::")) == -1) {
            end = text.length();
        }
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JsGwtReferenceExpressionManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

