/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.maven.GwtFacetImporter;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtMavenSdkPaths;

public class GwtCodehausFacetImporter
extends GwtFacetImporter {
    private static final Logger LOG = Logger.getInstance(GwtCodehausFacetImporter.class);

    public GwtCodehausFacetImporter() {
        this("org.codehaus.mojo", "gwt-maven-plugin");
    }

    protected GwtCodehausFacetImporter(String pluginGroupId, String pluginArtifactId) {
        super(pluginGroupId, pluginArtifactId);
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        this.resolveGwtSdk(mavenProject, embedder);
        this.addSourcesDependencies(mavenProject, embedder);
    }

    private void resolveGwtSdk(MavenProject mavenProject, MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
        MavenArtifact libs;
        File file;
        GwtPath path = this.resolveGwtPath(mavenProject);
        if (path == null || path.isInstalled) {
            return;
        }
        boolean platformDependent = VersionComparatorUtil.compare((String)path.version, (String)"2.0") < 0;
        String platform = platformDependent ? GwtMavenSdkPaths.getPlatformId() : null;
        List repos = mavenProject.getRemoteRepositories();
        embedder.resolve(new MavenArtifactInfo("com.google.gwt", "gwt-user", path.version, "jar", null), repos);
        embedder.resolve(new MavenArtifactInfo("com.google.gwt", "gwt-dev", path.version, "jar", platform), repos);
        if (platformDependent && (file = (libs = embedder.resolve(new MavenArtifactInfo("com.google.gwt", "gwt-dev", path.version, "zip", platform + "-libs"), repos)).getFile()).exists()) {
            try {
                ZipUtil.extract((File)file, (File)file.getParentFile(), null, (boolean)false);
            }
            catch (IOException e) {
                MavenLog.LOG.warn("cannot unpack gwt libraries" + e);
            }
        }
    }

    private void addSourcesDependencies(MavenProject mavenProject, MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
        List repos = mavenProject.getRemoteRepositories();
        List artifactTags = JDOMUtil.getChildren((Element)this.getConfig(mavenProject, "compileSourcesArtifacts"));
        for (Element artifactTag : artifactTags) {
            List parts = StringUtil.split((String)artifactTag.getTextTrim(), (String)":");
            if (parts.size() < 2) continue;
            String groupId = (String)parts.get(0);
            String artifactId = (String)parts.get(1);
            List dependencies = mavenProject.getDependencies();
            for (MavenArtifact artifact : dependencies.toArray(new MavenArtifact[dependencies.size()])) {
                if (!artifact.getMavenId().equals(groupId, artifactId)) continue;
                MavenArtifactInfo artifactInfo = new MavenArtifactInfo(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", "sources");
                MavenArtifact sourceArtifact = embedder.resolve(artifactInfo, repos);
                mavenProject.addDependency(sourceArtifact);
            }
        }
    }

    @Override
    protected void setupGwtCompilerOptions(GwtFacetConfiguration configuration, final Module module, MavenProject project) {
        String optimizationLevel;
        GwtJavaScriptOutputStyle outputStyle;
        String extraJvmArgs = this.findConfigValue(project, "extraJvmArgs");
        if (extraJvmArgs != null) {
            List jvmArgs = ParametersListUtil.parse((String)extraJvmArgs);
            ArrayList<String> filtered = new ArrayList<String>();
            for (String arg : jvmArgs) {
                if (arg.startsWith("-Xmx")) {
                    configuration.setCompilerMaxHeapSize(GwtCodehausFacetImporter.getSizeInMegabytes(arg));
                    continue;
                }
                filtered.add(arg);
            }
            configuration.setAdditionalCompilerVMParameters(ParametersListUtil.join(filtered));
        }
        if ((outputStyle = GwtJavaScriptOutputStyle.byId((String)this.findConfigValue(project, "style"))) != null) {
            configuration.setOutputStyle(outputStyle);
        }
        ArrayList<String> compilerParameters = new ArrayList<String>();
        String localWorkers = this.findConfigValue(project, "localWorkers");
        if (localWorkers != null) {
            compilerParameters.add("-localWorkers");
            compilerParameters.add(localWorkers);
        }
        if (Boolean.parseBoolean(this.findConfigValue(project, "disableCastChecking"))) {
            compilerParameters.add("-XdisableCastChecking");
        }
        if (Boolean.parseBoolean(this.findConfigValue(project, "disableClassMetadata"))) {
            compilerParameters.add("-XdisableClassMetadata");
        }
        if (Boolean.parseBoolean(this.findConfigValue(project, "draftCompile"))) {
            compilerParameters.add("-draftCompile");
        }
        if (Boolean.parseBoolean(this.findConfigValue(project, "compileReport"))) {
            compilerParameters.add("-compileReport");
        }
        if (Boolean.parseBoolean(this.findConfigValue(project, "soycDetailed"))) {
            compilerParameters.add("-XsoycDetailed");
        }
        if ((optimizationLevel = this.findConfigValue(project, "optimizationLevel")) != null) {
            compilerParameters.add("-optimize");
            compilerParameters.add(optimizationLevel);
        }
        configuration.setCompilerParameters(StringUtil.join(compilerParameters, (String)" "));
        final HashSet<String> enabledModules = new HashSet<String>();
        String singleModuleName = this.findConfigValue(project, "module");
        if (singleModuleName != null) {
            enabledModules.add(singleModuleName);
        } else {
            List moduleTags = JDOMUtil.getChildren((Element)this.getConfig(project, "modules"), (String)"module");
            for (Element tag : moduleTags) {
                enabledModules.add(tag.getTextTrim());
            }
        }
        if (!enabledModules.isEmpty()) {
            if (DumbService.isDumb((Project)module.getProject())) {
                DumbService.getInstance((Project)module.getProject()).runWhenSmart(new Runnable(){

                    @Override
                    public void run() {
                        GwtFacet facet = GwtFacet.getInstance(module);
                        if (facet != null) {
                            GwtCodehausFacetImporter.setEnabledGwtModules(module, enabledModules, (GwtFacetConfiguration)facet.getConfiguration());
                        }
                    }
                });
            } else {
                GwtCodehausFacetImporter.setEnabledGwtModules(module, enabledModules, configuration);
            }
        }
    }

    private static void setEnabledGwtModules(@NotNull Module module, @NotNull Set<String> enabledModules, GwtFacetConfiguration configuration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/maven/GwtCodehausFacetImporter", "setEnabledGwtModules"));
        }
        if (enabledModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabledModules", "com/intellij/gwt/maven/GwtCodehausFacetImporter", "setEnabledGwtModules"));
        }
        List<GwtModule> modules = GwtModulesManager.getInstance(module.getProject()).getGwtModules(module, true);
        for (GwtModule gwtModule : modules) {
            String moduleName = gwtModule.getQualifiedName();
            boolean enabled = enabledModules.contains(moduleName);
            configuration.setModuleCompilationEnabled(moduleName, enabled);
        }
    }

    private static int getSizeInMegabytes(String xmxArg) {
        String sizeString = StringUtil.trimStart((String)xmxArg, (String)"-Xmx");
        if (sizeString.length() > 0) {
            try {
                int size = Integer.parseInt(sizeString.substring(0, sizeString.length() - 1));
                if (StringUtil.endsWithIgnoreCase((String)sizeString, (String)"g")) {
                    return size * 1024;
                }
                return size;
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
            }
        }
        return 0;
    }

    @Override
    protected void setupGwtSdk(GwtFacet facet, MavenProject project) {
        GwtPath path = this.resolveGwtPath(project);
        if (path == null) {
            return;
        }
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)facet.getConfiguration();
        configuration.setGwtSdkUrl(VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)path.path)));
        configuration.setGwtSdkType(path.isInstalled ? null : "maven");
    }

    @Nullable
    private GwtPath resolveGwtPath(MavenProject project) {
        String sdkPath = this.findGwtPath(project);
        if (sdkPath != null) {
            return new GwtPath(sdkPath, null, true);
        }
        String version = this.findConfigValue(project, "gwtVersion");
        if (version == null) {
            for (MavenArtifact each : project.findDependencies("com.google.gwt", "gwt-user")) {
                version = each.getVersion();
            }
        }
        if (version == null) {
            return null;
        }
        return new GwtPath(GwtCodehausFacetImporter.getGwtDevPath(project, version), version, false);
    }

    private static String getGwtDevPath(MavenProject project, String version) {
        return project.getLocalRepository().getPath() + "/com/google/gwt/gwt-dev/" + version + "/";
    }

    private static class GwtPath {
        final String path;
        final String version;
        final boolean isInstalled;

        private GwtPath(String path, String version, boolean installed) {
            this.path = path;
            this.version = version;
            this.isInstalled = installed;
        }
    }
}

