/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetArtifactValidator;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.packaging.GwtCompileOutputRelativePathSuggester;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

public abstract class GwtFacetImporter
extends FacetImporter<GwtFacet, GwtFacetConfiguration, GwtFacetType> {
    protected GwtFacetImporter(String pluginGroupId, String pluginArtifactId) {
        super(pluginGroupId, pluginArtifactId, (FacetType)GwtFacetType.getInstance());
    }

    protected void setupFacet(GwtFacet f, MavenProject p) {
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID, true) != null;
    }

    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, GwtFacet facet, MavenProjectsTree mavenTree, MavenProject project, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        this.setupGwtSdk(facet, project);
        this.setupGwtCompilerOptions((GwtFacetConfiguration)facet.getConfiguration(), module, project);
        WebFacet webFacet = (WebFacet)this.findFacet((FacetModel)modelsProvider.getModifiableFacetModel(module), (FacetType)WebFacetType.getInstance(), "Web");
        if (webFacet != null) {
            ((GwtFacetConfiguration)facet.getConfiguration()).setWebFacetName(webFacet.getName());
        }
        this.addGwtCompilerOutputToArtifact(modelsProvider, module, facet, project, webFacet);
    }

    protected void setupGwtCompilerOptions(GwtFacetConfiguration configuration, Module module, MavenProject project) {
    }

    private void addGwtCompilerOutputToArtifact(IdeModifiableModelsProvider modelsProvider, Module module, GwtFacet facet, MavenProject project, WebFacet webFacet) {
        String gwtOutputPath = this.findValueInGoalConfigAndThenInPluginConfig(project, "compile", "webappDirectory");
        if (gwtOutputPath != null) {
            gwtOutputPath = FileUtil.toSystemIndependentName((String)gwtOutputPath);
        }
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        String artifactName = GwtFacetImporter.getArtifactName("war", module, true);
        Artifact webArtifact = artifactModel.findArtifact(artifactName);
        String relativePath = GwtCompileOutputRelativePathSuggester.suggestRelativeOutputPath(facet, modelsProvider.getPackagingElementResolvingContext());
        ModifiableArtifact targetArtifact = null;
        if (webArtifact != null) {
            String artifactOutput = webArtifact.getOutputPath();
            targetArtifact = artifactModel.getOrCreateModifiableArtifact(webArtifact);
            if (!StringUtil.isEmpty((String)gwtOutputPath) && !StringUtil.isEmpty((String)artifactOutput)) {
                String gwtOutputRelativePath = GwtFacetImporter.getGwtOutputRelativePath(gwtOutputPath, artifactOutput, webFacet);
                if (gwtOutputRelativePath != null) {
                    relativePath = gwtOutputRelativePath;
                } else {
                    targetArtifact = null;
                }
            }
        }
        if (targetArtifact == null) {
            if (StringUtil.isEmpty((String)gwtOutputPath)) {
                return;
            }
            String name = GwtFacetArtifactValidator.suggestArtifactName(module.getName());
            Artifact existingGwtArtifact = artifactModel.findArtifact(name);
            targetArtifact = existingGwtArtifact != null ? artifactModel.getOrCreateModifiableArtifact(existingGwtArtifact) : artifactModel.addArtifact(name, (ArtifactType)PlainArtifactType.getInstance());
            targetArtifact.setOutputPath(gwtOutputPath);
        }
        GwtCompilerOutputElement element = new GwtCompilerOutputElement(module.getProject(), facet);
        PackagingElementFactory.getInstance().getOrCreateDirectory(targetArtifact.getRootElement(), relativePath).addOrFindChild((PackagingElement)element);
    }

    @Nullable
    private static String getGwtOutputRelativePath(String gwtOutputPath, String artifactOutput, WebFacet webFacet) {
        if (FileUtil.startsWith((String)gwtOutputPath, (String)artifactOutput)) {
            return FileUtil.getRelativePath((String)artifactOutput, (String)gwtOutputPath, (char)'/');
        }
        for (WebRoot root : webFacet.getWebRoots()) {
            String webRootPath = VfsUtilCore.urlToPath((String)root.getDirectoryUrl());
            if (!FileUtil.startsWith((String)gwtOutputPath, (String)webRootPath)) continue;
            return FileUtil.getRelativePath((String)webRootPath, (String)gwtOutputPath, (char)'/');
        }
        return null;
    }

    @Nullable
    private String findValueInGoalConfigAndThenInPluginConfig(MavenProject project, String goal, String path) {
        String value = this.findGoalConfigValue(project, goal, path);
        if (value != null) {
            return value;
        }
        return this.findConfigValue(project, path);
    }

    protected void setupGwtSdk(GwtFacet facet, MavenProject project) {
        String gwtPath = this.findGwtPath(project);
        if (gwtPath != null) {
            gwtPath = FileUtil.toSystemIndependentName((String)gwtPath);
            gwtPath = VfsUtil.pathToUrl((String)gwtPath);
            ((GwtFacetConfiguration)facet.getConfiguration()).setGwtSdkUrl(gwtPath);
        }
    }

    @Nullable
    protected String findGwtPath(MavenProject mavenProject) {
        String path = this.findConfigValue(mavenProject, "gwtHome");
        if (path == null) {
            path = mavenProject.getProperties().getProperty("google.webtoolkit.home", null);
        }
        return path;
    }

    public static String getArtifactName(String packaging, Module module, boolean exploded) {
        String baseName = module.getName() + ":" + packaging;
        return exploded ? baseName + " exploded" : baseName;
    }
}

