/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GwtFilePatternUtil {
    private static final String[] DEFAULT_EXCLUDE_PATTERNS = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static List<Pattern> ourDefaultExcludes;
    private static List<Pattern> ourDefaultCaseInsensitiveExcludes;

    private static List<Pattern> getDefaultExcludesPatterns(boolean caseSensitive) {
        if (caseSensitive) {
            if (ourDefaultExcludes == null) {
                ourDefaultExcludes = GwtFilePatternUtil.computeDefaultExcludesPatterns(caseSensitive);
            }
            return ourDefaultExcludes;
        }
        if (ourDefaultCaseInsensitiveExcludes == null) {
            ourDefaultCaseInsensitiveExcludes = GwtFilePatternUtil.computeDefaultExcludesPatterns(caseSensitive);
        }
        return ourDefaultCaseInsensitiveExcludes;
    }

    private static List<Pattern> computeDefaultExcludesPatterns(boolean caseSensitive) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String pattern : DEFAULT_EXCLUDE_PATTERNS) {
            patterns.add(GwtFilePatternUtil.createPattern(pattern, caseSensitive));
        }
        return patterns;
    }

    private GwtFilePatternUtil() {
    }

    public static Pattern createPattern(String pattern, boolean caseSensitive) {
        return Pattern.compile(FileUtil.convertAntToRegexp((String)pattern), caseSensitive ? 0 : 2);
    }

    public static boolean isExcludedByDefault(String path, boolean caseSensitive) {
        for (Pattern pattern : GwtFilePatternUtil.getDefaultExcludesPatterns(caseSensitive)) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }
}

