/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.refactorings.rename;

import com.intellij.gwt.clientBundle.ClientBundleUtil;
import com.intellij.gwt.refactorings.rename.GwtAssociatedElementRenameHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CssClassRenameHandler
extends GwtAssociatedElementRenameHandler<CssClass> {
    CssClassRenameHandler() {
        super(CssClass.class);
    }

    @Override
    @NotNull
    public Collection<? extends PsiElement> findAssociatedElements(@NotNull CssClass baseElement) {
        if (baseElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseElement", "com/intellij/gwt/refactorings/rename/CssClassRenameHandler", "findAssociatedElements"));
        }
        PsiFile file = baseElement.getContainingFile();
        if (!(file instanceof CssFile)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/rename/CssClassRenameHandler", "findAssociatedElements"));
            }
            return list;
        }
        Set<PsiClass> classes = ClientBundleUtil.getCssInterfaces((CssFile)file);
        if (classes.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/rename/CssClassRenameHandler", "findAssociatedElements"));
            }
            return list;
        }
        ArrayList result = new ArrayList();
        for (PsiClass psiClass : classes) {
            Collections.addAll(result, psiClass.findMethodsByName(baseElement.getName(), false));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/rename/CssClassRenameHandler", "findAssociatedElements"));
        }
        return arrayList;
    }
}

