/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.GwtRunConfigurationType;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GwtRunConfigurationFactory
extends ConfigurationFactoryEx {
    public GwtRunConfigurationFactory(GwtRunConfigurationType gwtConfigurationType) {
        super((ConfigurationType)gwtConfigurationType);
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtRunConfigurationFactory", "isApplicable"));
        }
        return ProjectFacetManager.getInstance((Project)project).hasFacets(GwtFacetType.ID);
    }

    public RunConfiguration createTemplateConfiguration(Project project) {
        return new GwtRunConfiguration(project, this);
    }

    public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gwt/run/GwtRunConfigurationFactory", "onNewConfigurationCreated"));
        }
        List facets = ProjectFacetManager.getInstance((Project)configuration.getProject()).getFacets(GwtFacetType.ID);
        for (GwtFacet facet : facets) {
            if (!facet.getSdkVersion().isSuperDevModeUsedByDefault()) continue;
            ((GwtRunConfiguration)configuration).getState().USE_SUPER_DEV_MODE = true;
            break;
        }
    }
}

