/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.remoteUi.RemoteUiRequest;
import com.intellij.gwt.run.remoteUi.responses.CapabilityExchangeResponse;
import com.intellij.gwt.run.remoteUi.responses.InitializeResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponseReader;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.RequestWriter;
import com.intellij.util.io.socketConnection.ResponseReader;
import com.intellij.util.io.socketConnection.SocketConnection;
import com.intellij.util.io.socketConnection.SocketConnectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUiConnection {
    private final SocketConnection<RemoteUiRequest, RemoteUiResponse> myConnection;
    private final GwtRunConfiguration myConfiguration;
    private final GwtVersion mySdkVersion;
    private final boolean myOpenInBrowser;
    private final boolean myStartJavaScriptDebugger;
    private final WebBrowser myBrowser;

    public RemoteUiConnection(GwtRunConfiguration configuration, @NotNull GwtVersion sdkVersion, boolean openInBrowser, boolean startJavaScriptDebugger, @Nullable WebBrowser browser) {
        if (sdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkVersion", "com/intellij/gwt/run/remoteUi/RemoteUiConnection", "<init>"));
        }
        this.myConfiguration = configuration;
        this.mySdkVersion = sdkVersion;
        this.myOpenInBrowser = openInBrowser;
        this.myStartJavaScriptDebugger = startJavaScriptDebugger;
        this.myBrowser = browser;
        this.myConnection = SocketConnectionFactory.createServerConnection((int)7901, (int)20, (RequestResponseExternalizerFactory)new RemoteUiRequestExternalizer());
        this.myConnection.registerHandler(CapabilityExchangeResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<CapabilityExchangeResponse>(){

            public void processResponse(CapabilityExchangeResponse response) {
                RemoteUiConnection.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createCapabilitiesResponse(response.getMessageId()));
            }
        });
        this.myConnection.registerHandler(InitializeResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<InitializeResponse>(){

            public void processResponse(InitializeResponse response) {
                List<String> urls = response.getStartupUrlsList();
                if (!urls.isEmpty()) {
                    final String url = urls.get(0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RemoteUiConnection.this.onInitialized(url);
                        }
                    });
                }
                RemoteUiConnection.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createDummyResponseRequest(response.getMessageId()));
            }
        });
    }

    public void sendRestartServerRequest() {
        this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createRestartServerRequest());
    }

    @NotNull
    public GwtVersion getSdkVersion() {
        GwtVersion gwtVersion = this.mySdkVersion;
        if (gwtVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/remoteUi/RemoteUiConnection", "getSdkVersion"));
        }
        return gwtVersion;
    }

    private void onInitialized(String url) {
        if (this.myOpenInBrowser) {
            JavaScriptDebuggerStarter.Util.startDebugOrLaunchBrowser((RunConfiguration)this.myConfiguration, (String)url, (WebBrowser)this.myBrowser, (boolean)this.myStartJavaScriptDebugger);
        }
    }

    public int open() throws IOException {
        this.myConnection.open();
        return this.myConnection.getPort();
    }

    public SocketConnection<RemoteUiRequest, RemoteUiResponse> getConnection() {
        return this.myConnection;
    }

    public void close() {
        this.myConnection.close();
    }

    private static class RemoteUiRequestExternalizer
    extends RequestResponseExternalizerFactory<RemoteUiRequest, RemoteUiResponse> {
        private RemoteUiRequestExternalizer() {
        }

        @NotNull
        public RequestWriter<RemoteUiRequest> createRequestWriter(final @NotNull OutputStream output) throws IOException {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/gwt/run/remoteUi/RemoteUiConnection$RemoteUiRequestExternalizer", "createRequestWriter"));
            }
            RequestWriter<RemoteUiRequest> requestWriter = new RequestWriter<RemoteUiRequest>(){

                public void writeRequest(RemoteUiRequest request) throws IOException {
                    request.sendMessage(output);
                }
            };
            if (requestWriter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/remoteUi/RemoteUiConnection$RemoteUiRequestExternalizer", "createRequestWriter"));
            }
            return requestWriter;
        }

        @NotNull
        public ResponseReader<RemoteUiResponse> createResponseReader(@NotNull InputStream input) throws IOException {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/gwt/run/remoteUi/RemoteUiConnection$RemoteUiRequestExternalizer", "createResponseReader"));
            }
            RemoteUiResponseReader remoteUiResponseReader = new RemoteUiResponseReader(input);
            if (remoteUiResponseReader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/remoteUi/RemoteUiConnection$RemoteUiRequestExternalizer", "createResponseReader"));
            }
            return remoteUiResponseReader;
        }
    }
}

