/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum GwtVersionImpl implements GwtVersion
{
    VERSION_1_0,
    VERSION_FROM_1_1_TO_1_3,
    VERSION_1_4,
    VERSION_1_5,
    VERSION_1_6,
    VERSION_2_0,
    VERSION_2_5,
    VERSION_2_6,
    VERSION_2_7_OR_LATER;

    @NonNls
    private static final String[] GWT_15_SAMPLE_TEMPLATES;
    @NonNls
    private static final String[] GWT_16_SAMPLE_TEMPLATES;
    @NonNls
    private static final String[] GWT_20_SAMPLE_TEMPLATES;
    @NonNls
    private static final String GWT_MODULE_DOCTYPE_FORMAT = "<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD Google Web Toolkit ${VERSION}//EN\" \"http://google-web-toolkit.googlecode.com/svn/releases/${VERSION}/distro-source/core/src/gwt-module.dtd\">";
    @NonNls
    private static final String GWT_2_7_MODULE_DOCTYPE_FORMAT = "<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD Google Web Toolkit 2.7.0//EN\" \"http://gwtproject.org/doctype/2.7.0/gwt-module.dtd\">";

    @Override
    @NotNull
    public String getGwtModuleHtmlTemplate() {
        String string = this.isAtLeast(VERSION_1_6) ? "GwtAppHtml_1_6.html" : (this.isAtLeast(VERSION_1_4) ? "GwtAppHtml_1_4.html" : "GwtAppHtml.html");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getGwtModuleHtmlTemplate"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGwtServiceJavaTemplate() {
        String string = this == VERSION_1_0 ? "GwtAppService_1_0.java" : (this.isAtLeast(VERSION_1_5) ? "GwtAppService_1_5.java" : "GwtAppService.java");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getGwtServiceJavaTemplate"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGwtModuleXmlTemplate() {
        if (this.isAtLeast(VERSION_1_6)) {
            if ("GwtApp_1_6.gwt.xml" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getGwtModuleXmlTemplate"));
            }
            return "GwtApp_1_6.gwt.xml";
        }
        if (this == VERSION_1_5) {
            if ("GwtApp_1_5.gwt.xml" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getGwtModuleXmlTemplate"));
            }
            return "GwtApp_1_5.gwt.xml";
        }
        if ("GwtApp_1_4.gwt.xml" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getGwtModuleXmlTemplate"));
        }
        return "GwtApp_1_4.gwt.xml";
    }

    public boolean isAtLeast(GwtVersionImpl another) {
        return this.compareTo(another) >= 0;
    }

    @Override
    @NotNull
    public String[] getGwtSampleAppTemplates() {
        String[] templates;
        String samplesVersion;
        if (this.isAtLeast(VERSION_2_0)) {
            samplesVersion = "20";
            templates = GWT_20_SAMPLE_TEMPLATES;
        } else if (this.isAtLeast(VERSION_1_6)) {
            samplesVersion = "16";
            templates = GWT_16_SAMPLE_TEMPLATES;
        } else {
            samplesVersion = "15";
            templates = GWT_15_SAMPLE_TEMPLATES;
        }
        String root = "/sampleApps/gwt" + samplesVersion + "/";
        String[] result = new String[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            result[i] = root + templates[i];
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getGwtSampleAppTemplates"));
        }
        return result;
    }

    @Override
    public boolean isJavaIoSerializableSupported() {
        return this.isAtLeast(VERSION_1_4);
    }

    @Override
    public boolean isPrivateNoArgConstructorInSerializableClassAllowed() {
        return this.isAtLeast(VERSION_1_5);
    }

    @Override
    public boolean isGenericsSupported() {
        return this.isAtLeast(VERSION_1_5);
    }

    @Override
    public boolean isNewExpressionInJavaScriptSupported() {
        return this.isAtLeast(VERSION_1_5);
    }

    @Override
    public boolean isShortClassReferencesInJavaScriptSupported() {
        return this.isAtLeast(VERSION_2_7_OR_LATER);
    }

    @Override
    public boolean isWildcardMethodReferencesInJavaScriptSupported() {
        return this.isAtLeast(VERSION_2_5);
    }

    @Override
    @NotNull
    public String getCompilerClassName() {
        String string = this.isAtLeast(VERSION_1_6) ? "com.google.gwt.dev.Compiler" : "com.google.gwt.dev.GWTCompiler";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getCompilerClassName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDevModeClass() {
        if (this.isAtLeast(VERSION_2_0)) {
            if ("com.google.gwt.dev.DevMode" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getDevModeClass"));
            }
            return "com.google.gwt.dev.DevMode";
        }
        String string = this.isAtLeast(VERSION_1_6) ? "com.google.gwt.dev.HostedMode" : "com.google.gwt.dev.GWTShell";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getDevModeClass"));
        }
        return string;
    }

    @Override
    public boolean isModulesToLoadSpecifiedInDevMode() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isHostedModeRequiresWebXml() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isHtmlFilesOutsideSourcesAreAllowed() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isEventHandlersSupported() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isDevModeSupportsOutputStyleOption() {
        return !this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isOutOfProcessHostedModeSupported() {
        return this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isUseSystemIndependentGwtDevJar() {
        return this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isUiBinderSupported() {
        return this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isUiRendererSupported() {
        return this.isAtLeast(VERSION_2_5);
    }

    @Override
    public String getGwtModuleDocTypeString() {
        if (this.isAtLeast(VERSION_2_7_OR_LATER)) {
            return GWT_2_7_MODULE_DOCTYPE_FORMAT;
        }
        String version = this.isAtLeast(VERSION_2_0) ? "2.0" : "1.6";
        return StringUtil.replace((String)GWT_MODULE_DOCTYPE_FORMAT, (String)"${VERSION}", (String)version);
    }

    @Override
    public boolean isBrowserSupportedInDevMode(@NotNull BrowserFamily family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "isBrowserSupportedInDevMode"));
        }
        return family != BrowserFamily.OPERA;
    }

    @Override
    public boolean isSuperDevModeSupported() {
        return this.isAtLeast(VERSION_2_5);
    }

    @Override
    public boolean isLegacyJarForNewSuperDevModeRequired() {
        return this.isAtLeast(VERSION_2_5) && !this.isAtLeast(VERSION_2_7_OR_LATER);
    }

    @Override
    public boolean isSuperDevModeUsedByDefault() {
        return this.isAtLeast(VERSION_2_7_OR_LATER);
    }

    @Override
    @NotNull
    public String getCompilerOutputDirParameterName() {
        String string = this.isAtLeast(VERSION_1_6) ? "-war" : "-out";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtVersionImpl", "getCompilerOutputDirParameterName"));
        }
        return string;
    }

    public static GwtVersionImpl getDefaultVersion() {
        return VERSION_2_5;
    }

    static {
        GWT_15_SAMPLE_TEMPLATES = new String[]{"java/client/App.java.ft", "java/client/AppService.java.ft", "java/client/AppServiceAsync.java.ft", "java/public/App.html.ft", "java/server/AppServiceImpl.java.ft", "java/App.gwt.xml.ft"};
        GWT_16_SAMPLE_TEMPLATES = new String[]{"java/client/App.java.ft", "java/client/AppService.java.ft", "java/client/AppServiceAsync.java.ft", "java/server/AppServiceImpl.java.ft", "java/App.gwt.xml.ft", "war/App.html.ft"};
        GWT_20_SAMPLE_TEMPLATES = new String[]{"java/client/App.java.ft", "java/client/AppService.java.ft", "java/client/AppServiceAsync.java.ft", "java/server/AppServiceImpl.java.ft", "java/App.gwt.xml.ft", "war/App.html.ft", "war/App.css.ft"};
    }
}

