/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.superSource;

import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.superSource.GwtModuleSuperSourceIndex;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.gwt.superSource.GwtSuperSourceClassCacheImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtSuperSourceElementFinder
extends PsiElementFinder {
    private final Project myProject;
    private final PsiManager myPsiManager;
    private Map<String, List<VirtualFile>> mySuperSourceDirectoriesByPackageName = ContainerUtil.newConcurrentMap();
    private Set<String> myNonExistentSuperSourcePackages = ContainerUtil.newConcurrentSet();

    public GwtSuperSourceElementFinder(Project project, PsiManager psiManager) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                GwtSuperSourceElementFinder.this.clearCaches();
            }
        });
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            private void processChange(PsiTreeChangeEvent event) {
                PsiFile file = event.getFile();
                if (file != null && file.getName().endsWith(".gwt.xml")) {
                    GwtSuperSourceElementFinder.this.clearCaches();
                }
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$2", "childAdded"));
                }
                this.processChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$2", "childRemoved"));
                }
                this.processChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$2", "childReplaced"));
                }
                this.processChange(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$2", "childMoved"));
                }
                this.processChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$2", "childrenChanged"));
                }
                this.processChange(event);
            }
        });
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                GwtSuperSourceElementFinder.this.myNonExistentSuperSourcePackages.clear();
            }
        }, (Disposable)project);
    }

    private void clearCaches() {
        this.myNonExistentSuperSourcePackages.clear();
        this.mySuperSourceDirectoriesByPackageName.clear();
    }

    private List<VirtualFile> getDirectoriesByPackageName(String packageName) {
        List<VirtualFile> cached = this.mySuperSourceDirectoriesByPackageName.get(packageName);
        if (cached != null) {
            return cached;
        }
        if (this.myNonExistentSuperSourcePackages.contains(packageName)) {
            return Collections.emptyList();
        }
        List<VirtualFile> result = this.findDirectoriesByPackageName(packageName);
        if (result.isEmpty()) {
            this.myNonExistentSuperSourcePackages.add(packageName);
        } else {
            this.mySuperSourceDirectoriesByPackageName.put(packageName, result);
        }
        return result;
    }

    @NotNull
    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        if (StringUtil.isEmpty((String)packageName)) {
            List<VirtualFile> list = GwtModuleSuperSourceIndex.getSuperSourceRoots(GlobalSearchScope.allScope((Project)this.myProject));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findDirectoriesByPackageName"));
            }
            return list;
        }
        List<VirtualFile> parentDirectories = this.getDirectoriesByPackageName(StringUtil.getPackageName((String)packageName));
        if (parentDirectories.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findDirectoriesByPackageName"));
            }
            return list;
        }
        SmartList result = new SmartList();
        String shortName = StringUtil.getShortName((String)packageName);
        for (VirtualFile parentDirectory : parentDirectories) {
            VirtualFile child = parentDirectory.findChild(shortName);
            if (child == null || !child.isDirectory()) continue;
            result.add(child);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findDirectoriesByPackageName"));
        }
        return smartList;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findPackage"));
        }
        if (!this.hasGwtFacets() || DumbService.isDumb((Project)this.myProject)) {
            return null;
        }
        if (!this.getDirectoriesByPackageName(qualifiedName).isEmpty()) {
            return new PsiPackageImpl(this.myPsiManager, qualifiedName);
        }
        return null;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findClass"));
        }
        return (PsiClass)ContainerUtil.getFirstItem(this.doFindClasses(qualifiedName, scope));
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findClasses"));
        }
        PsiClass[] psiClassArray = (PsiClass[])ContainerUtil.toArray(this.doFindClasses(qualifiedName, scope), (ArrayFactory)PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "findClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    private List<PsiClass> doFindClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String packageName;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "doFindClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "doFindClasses"));
        }
        if (!this.hasGwtFacets()) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        SmartList innerClassNames = new SmartList();
        GwtSuperSourceClassCache classCache = GwtSuperSourceClassCache.getInstance(this.myProject);
        String currentName = qualifiedName;
        do {
            packageName = StringUtil.getPackageName((String)currentName);
            String className = StringUtil.getShortName((String)currentName);
            if (!className.isEmpty() && Character.isLowerCase(className.charAt(0)) && !innerClassNames.isEmpty()) break;
            for (VirtualFile directory : this.getDirectoriesByPackageName(packageName)) {
                if (!scope.contains(directory)) continue;
                for (VirtualFile file : directory.getChildren()) {
                    PsiFile psiFile;
                    if (!scope.contains(file) || !file.getFileType().equals(StdFileTypes.JAVA) || !((psiFile = classCache.getCachedPsiFile(file)) instanceof PsiJavaFile)) continue;
                    for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                        if (!currentName.equals(aClass.getQualifiedName())) continue;
                        ContainerUtil.addIfNotNull((Collection)result, (Object)GwtSuperSourceClassCacheImpl.findInnerClass(aClass, (List<String>)innerClassNames));
                    }
                }
            }
            innerClassNames.add(className);
        } while ((currentName = packageName).length() > 0);
        return result;
    }

    private boolean hasGwtFacets() {
        return ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(GwtFacetType.ID);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "processPackageDirectories"));
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.hasGwtFacets()) {
            return true;
        }
        for (VirtualFile directory : this.getDirectoriesByPackageName(psiPackage.getQualifiedName())) {
            PsiDirectory psiDirectory;
            if (!scope.contains(directory) || (psiDirectory = this.myPsiManager.findDirectory(directory)) == null || consumer.process((Object)psiDirectory)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "getClasses"));
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.hasGwtFacets()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "getClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList classes = null;
        for (VirtualFile packageDir : this.getDirectoriesByPackageName(psiPackage.getQualifiedName())) {
            if (!scope.contains(packageDir)) continue;
            for (VirtualFile file : packageDir.getChildren()) {
                PsiFile psiFile;
                if (!scope.contains(file) || !file.getFileType().equals(StdFileTypes.JAVA) || !((psiFile = GwtSuperSourceClassCache.getInstance(this.myProject).getCachedPsiFile(file)) instanceof PsiClassOwner)) continue;
                if (classes == null) {
                    classes = new ArrayList();
                }
                Collections.addAll(classes, ((PsiClassOwner)psiFile).getClasses());
            }
        }
        PsiClass[] psiClassArray = classes != null ? classes.toArray(new PsiClass[classes.size()]) : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder", "getClasses"));
        }
        return psiClassArray;
    }
}

