/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class CreateSetterQuickFix
implements IntentionAction {
    private String mySetterName;
    private final String myPropertyName;
    private PsiClass myClass;

    CreateSetterQuickFix(PsiClass aClass, String setterName, String propertyName) {
        this.myClass = aClass;
        this.mySetterName = setterName;
        this.myPropertyName = propertyName;
    }

    @NotNull
    public String getText() {
        String string = "Create '" + this.mySetterName + "' method in '" + this.myClass.getName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/CreateSetterQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = BaseGwtLocalQuickFix.FAMILY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/CreateSetterQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/uiBinder/CreateSetterQuickFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/uiBinder/CreateSetterQuickFix", "invoke"));
        }
        PsiManager psiManager = this.myClass.getManager();
        String text = "public void " + this.mySetterName + "(" + "java.lang.String" + " " + this.myPropertyName + ") {\n}";
        PsiMethod method = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createMethodFromText(text, (PsiElement)this.myClass);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        PsiMethod added = (PsiMethod)this.myClass.add((PsiElement)method);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)added);
        added.navigate(true);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

