/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateUiFieldIntention
extends AbstractIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.uiBinder.CreateUiFieldIntention");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/uiBinder/CreateUiFieldIntention", "invoke"));
        }
        Pair<XmlAttributeValue, PsiClass> pair = CreateUiFieldIntention.findAttribute(file, editor);
        if (pair == null) {
            return;
        }
        XmlAttributeValue attributeValue = (XmlAttributeValue)pair.getFirst();
        PsiClass psiClass = (PsiClass)pair.getSecond();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)psiClass)) {
            return;
        }
        AccessToken token = WriteAction.start();
        try {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attributeValue, XmlTag.class);
            if (tag == null) {
                return;
            }
            String className = UiBinderUtil.getComponentClassName(tag);
            PsiClassType type = elementFactory.createTypeByFQClassName(className, psiClass.getResolveScope());
            PsiField field = elementFactory.createField(attributeValue.getValue(), (PsiType)type);
            PsiModifierList modifierList = field.getModifierList();
            LOG.assertTrue(modifierList != null, field.getClass());
            modifierList.setModifierProperty("private", false);
            modifierList.addAnnotation("com.google.gwt.uibinder.client.UiField");
            PsiField lastField = null;
            PsiField lastUiField = null;
            for (PsiField psiField : psiClass.getFields()) {
                if (UiBinderUtil.isUiField(psiField)) {
                    lastUiField = psiField;
                }
                lastField = psiField;
            }
            if (lastUiField != null) {
                lastField = lastUiField;
            }
            PsiElement added = lastField != null ? psiClass.addAfter((PsiElement)field, lastField) : psiClass.add((PsiElement)field);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(added);
            CodeStyleManager.getInstance((Project)project).reformat(added);
        }
        finally {
            token.finish();
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/uiBinder/CreateUiFieldIntention", "isAvailable"));
        }
        return CreateUiFieldIntention.findAttribute(file, editor) != null;
    }

    @Nullable
    private static Pair<XmlAttributeValue, PsiClass> findAttribute(PsiFile file, Editor editor) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        GwtFacet gwtFacet = GwtFacet.findFacetByPsiElement((PsiElement)file);
        if (gwtFacet == null) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
        if (attributeValue == null) {
            return null;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)attributeValue, XmlAttribute.class);
        if (attribute == null || !attribute.getLocalName().equals("field") || !UiBinderUtil.hasUiBinderNamespace(attribute)) {
            return null;
        }
        String fieldName = attributeValue.getValue();
        if (!PsiNameHelper.getInstance((Project)attributeValue.getProject()).isIdentifier(fieldName)) {
            return null;
        }
        List<PsiClass> classes = UiBinderMappingService.getInstance(gwtFacet.getModule()).getBoundClasses(file);
        for (PsiClass psiClass : classes) {
            if (psiClass.findFieldByName(fieldName, true) != null) continue;
            return Pair.create((Object)attributeValue, (Object)psiClass);
        }
        return null;
    }

    @NotNull
    public String getText() {
        if ("Create @UiField for tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/CreateUiFieldIntention", "getText"));
        }
        return "Create @UiField for tag";
    }
}

