/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlSchemaProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtUiXmlSchemaProvider
extends XmlSchemaProvider {
    private static final Key<XmlFile> UI_BINDER_PATCHED_SCHEMA_KEY = Key.create((String)"GWT_UI_BINDER_PATCHED_SCHEMA");
    private static final Set<String> RESERVED_PREFIXES = ContainerUtil.newTroveSet((Object[])new String[]{"client", "g", "ui"});
    private static final Map<String, Couple<String>> DEFAULT_SCHEMES = new HashMap<String, Couple<String>>();

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getSchema"));
        }
        if (module == null) {
            return null;
        }
        return GwtUiXmlSchemaProvider.findDefaultSchema(url, module);
    }

    public static boolean isDefaultSchema(String namespace) {
        return DEFAULT_SCHEMES.containsKey(namespace);
    }

    @Nullable
    public static XmlFile findDefaultSchema(String url, Module module) {
        Couple<String> pair = DEFAULT_SCHEMES.get(url);
        if (pair != null) {
            String schemaPath = (String)pair.getSecond();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(PathUtil.getParentPath((String)schemaPath).replace('/', '.'));
            if (psiPackage != null) {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                String fileName = PathUtil.getFileName((String)schemaPath);
                for (PsiDirectory directory : psiPackage.getDirectories(scope)) {
                    PsiFile file = directory.findFile(fileName);
                    if (!(file instanceof XmlFile)) continue;
                    XmlFile xmlFile = (XmlFile)file;
                    if (url.equals("urn:ui:com.google.gwt.uibinder")) {
                        return GwtUiXmlSchemaProvider.getOrCreatePatchedCopy(xmlFile);
                    }
                    return xmlFile;
                }
            }
        }
        return null;
    }

    private static XmlFile getOrCreatePatchedCopy(XmlFile xmlFile) {
        XmlFile patched = (XmlFile)xmlFile.getUserData(UI_BINDER_PATCHED_SCHEMA_KEY);
        if (patched == null) {
            XmlTag rootTag;
            patched = (XmlFile)xmlFile.copy();
            XmlDocument document = patched.getDocument();
            if (document != null && (rootTag = document.getRootTag()) != null) {
                for (XmlTag tag : rootTag.getSubTags()) {
                    if (!"UiBinder".equals(tag.getAttributeValue("name", "http://www.w3.org/2001/XMLSchema"))) continue;
                    for (XmlTag typeTag : tag.getSubTags()) {
                        if (!"complexType".equals(typeTag.getLocalName())) continue;
                        boolean baseMessagesInterfaceFound = false;
                        for (XmlTag attributeTag : typeTag.getSubTags()) {
                            if (!"attribute".equals(attributeTag.getLocalName())) continue;
                            attributeTag.setAttribute("form", "qualified");
                            if (baseMessagesInterfaceFound || !"baseMessagesInterface".equals(attributeTag.getAttributeValue("name"))) continue;
                            baseMessagesInterfaceFound = true;
                        }
                        if (baseMessagesInterfaceFound) continue;
                        XmlTag baseMessagesInterface = typeTag.createChildTag("attribute", "xs", null, false);
                        baseMessagesInterface.setAttribute("name", "baseMessagesInterface");
                        baseMessagesInterface.setAttribute("type", "xs:string");
                        baseMessagesInterface.setAttribute("form", "qualified");
                        typeTag.addSubTag(baseMessagesInterface, false);
                    }
                }
            }
            xmlFile.putUserData(UI_BINDER_PATCHED_SCHEMA_KEY, (Object)patched);
        }
        return patched;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getAvailableNamespaces"));
        }
        if (tagName == null) {
            Set<String> set = DEFAULT_SCHEMES.keySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getAvailableNamespaces"));
            }
            return set;
        }
        for (Map.Entry<String, Couple<String>> entry : DEFAULT_SCHEMES.entrySet()) {
            if (!tagName.equals(entry.getValue().getFirst())) continue;
            Set<String> set = Collections.singleton(entry.getKey());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getAvailableNamespaces"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getAvailableNamespaces"));
        }
        return set;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getDefaultPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "getDefaultPrefix"));
        }
        Couple<String> pair = DEFAULT_SCHEMES.get(namespace);
        if (pair != null) {
            return (String)pair.getFirst();
        }
        if (namespace.startsWith("urn:import:")) {
            return GwtUiXmlSchemaProvider.suggestPrefix(StringUtil.trimStart((String)namespace, (String)"urn:import:"));
        }
        return null;
    }

    private static String suggestPrefix(String packageName) {
        List names = StringUtil.split((String)packageName, (String)".");
        for (int i = names.size() - 1; i >= 0; --i) {
            String name = (String)names.get(i);
            if (RESERVED_PREFIXES.contains(name)) continue;
            return name;
        }
        return "x";
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider", "isAvailable"));
        }
        return UiBinderUtil.isUiXmlFile(file);
    }

    static {
        DEFAULT_SCHEMES.put("urn:ui:com.google.gwt.uibinder", (Couple<String>)Couple.of((Object)"ui", (Object)"com/google/gwt/uibinder/resources/UiBinder.xsd"));
        DEFAULT_SCHEMES.put("urn:import:com.google.gwt.user.client.ui", (Couple<String>)Couple.of((Object)"g", (Object)"com/google/gwt/uibinder/resources/com.google.gwt.user.client.ui.xsd"));
    }
}

