/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.grails.rt;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.jetbrains.groovy.grails.rt.AgentUtils;

public class ForkListenerTransformer
implements ClassFileTransformer {
    private boolean done;
    private final String fileName;

    public ForkListenerTransformer(String fileName) {
        this.fileName = fileName;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.done) {
            return null;
        }
        if (AgentUtils.isGrailsClassLoader(loader)) {
            ForkListenerTransformer.writeToFile(this.fileName, new byte[]{1});
            this.done = true;
        } else if ("org/grails/maven/plugin/tools/ForkedGrailsRuntime".equals(className)) {
            ForkListenerTransformer.writeToFile(this.fileName, new byte[]{1, 2, 3});
            this.done = true;
        }
        return null;
    }

    private static void writeToFile(String fileName, byte[] content) {
        try {
            FileOutputStream outputStream = new FileOutputStream(fileName);
            try {
                outputStream.write(content);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

