/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CfmlAttributeValueManipulator
extends AbstractElementManipulator<CfmlCompositeElement> {
    public CfmlCompositeElement handleContentChange(@NotNull CfmlCompositeElement expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        PsiElement newStringElement;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/coldFusion/model/psi/CfmlAttributeValueManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/coldFusion/model/psi/CfmlAttributeValueManipulator", "handleContentChange"));
        }
        PsiElement parent = expr.getParent();
        PsiFile psiFile = null;
        String oldText = expr.getText();
        String newText = StringUtil.startsWithChar((CharSequence)oldText, (char)'\"') ? oldText.substring(1, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset(), oldText.lastIndexOf("\"")) : oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        String templateText = "";
        if (parent != null && parent.getNode().getElementType() == CfmlElementTypes.INCLUDEEXPRESSION) {
            templateText = "<cfscript> cfinclude \"";
            psiFile = PsiFileFactory.getInstance((Project)expr.getContainingFile().getProject()).createFileFromText("newElementFile.cfml", templateText + newText + "\"; </cfscript>");
        } else {
            parent = PsiTreeUtil.getParentOfType((PsiElement)expr, CfmlTag.class);
            if (parent != null) {
                templateText = "<cfinclude template=\"";
                psiFile = PsiFileFactory.getInstance((Project)expr.getContainingFile().getProject()).createFileFromText("newElementFile.cfml", templateText + newText + "\">");
            }
        }
        if (psiFile != null && (newStringElement = psiFile.findElementAt(templateText.length())) != null && newStringElement.getParent() != null) {
            return (CfmlCompositeElement)expr.replace(newStringElement.getParent());
        }
        return expr;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CfmlCompositeElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coldFusion/model/psi/CfmlAttributeValueManipulator", "getRangeInElement"));
        }
        TextRange textRange = CfmlAttributeValueManipulator.getValueRange(element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAttributeValueManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    private static TextRange getValueRange(CfmlCompositeElement element) {
        if (StringUtil.startsWithChar((CharSequence)element.getText(), (char)'\"')) {
            return TextRange.allOf((String)element.getFirstChild().getNextSibling().getText()).shiftRight(1);
        }
        return TextRange.allOf((String)element.getText());
    }
}

