/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlProperty;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.CfmlTypedElement;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeNameImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedAttributeImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlPsiUtil {
    private static final Set<String> OUR_TRANSPARENT_FUNCTIONS = new HashSet();

    @Nullable
    public static Collection<String> findBetween(@NotNull String source, @NotNull String startMarker, @NotNull String endMarker) {
        int end;
        int start;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "findBetween"));
        }
        if (startMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMarker", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "findBetween"));
        }
        if (endMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endMarker", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "findBetween"));
        }
        int fromIndex = 0;
        LinkedList<String> collection = new LinkedList<String>();
        while (fromIndex < source.length() && fromIndex >= 0 && (start = source.indexOf(startMarker, fromIndex)) >= 0 && (end = source.indexOf(endMarker, start += startMarker.length())) >= start) {
            collection.add(source.substring(start, end));
            fromIndex = end + endMarker.length();
        }
        return collection;
    }

    @Nullable
    public static TextRange findRange(@NotNull String source, @NotNull String startMarker, @NotNull String endMarker) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "findRange"));
        }
        if (startMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMarker", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "findRange"));
        }
        if (endMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endMarker", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "findRange"));
        }
        int start = source.indexOf(startMarker);
        if (start < 0) {
            return null;
        }
        int end = source.indexOf(endMarker, start += startMarker.length());
        if (end < start) {
            return null;
        }
        return new TextRange(start, end);
    }

    public static boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement currentElement) {
        PsiElement element;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "processDeclarations"));
        }
        if (currentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentElement", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "processDeclarations"));
        }
        PsiElement psiElement = element = lastParent == null ? currentElement.getLastChild() : lastParent.getPrevSibling();
        do {
            CfmlAssignmentExpression assignmentExpression;
            CfmlVariable assignedVariable;
            if (element instanceof PsiNamedElement && !(element instanceof CfmlFunction)) {
                if (!processor.execute(element, state)) {
                    return false;
                }
            } else if (element instanceof CfmlTag) {
                if (!(element instanceof CfmlFunction)) {
                    PsiElement psiElement2 = ((CfmlTag)element).getDeclarativeElement();
                    if (psiElement2 != null && !processor.execute(psiElement2, state)) {
                        return false;
                    }
                    if (OUR_TRANSPARENT_FUNCTIONS.contains(((CfmlTag)element).getTagName()) && !CfmlPsiUtil.processDeclarations(processor, state, null, element)) {
                        return false;
                    }
                }
            } else if (element instanceof CfmlAssignmentExpression && (assignedVariable = (assignmentExpression = (CfmlAssignmentExpression)element).getAssignedVariable()) != null && lastParent != assignmentExpression.getRightHandExpr() && !processor.execute((PsiElement)assignedVariable, state)) {
                return false;
            }
            if (element != null) continue;
            return true;
        } while ((element = element.getPrevSibling()) != null);
        return true;
    }

    @Nullable
    public static CfmlTypedElement getTypedQualifierInner(PsiElement element) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof CfmlTypedElement)) continue;
            return (CfmlTypedElement)child;
        }
        return null;
    }

    @Nullable
    public static CfmlReference getQualifierInner(PsiElement element) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CfmlReferenceExpression) {
                return (CfmlReferenceExpression)child;
            }
            if (!(child instanceof CfmlFunctionCallExpression)) continue;
            return ((CfmlFunctionCallExpression)child).getReferenceExpression();
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByName(String typeName, Project project) {
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName(typeName, GlobalSearchScope.allScope((Project)project));
    }

    public static CfmlFile createDummyFile(Project project, String text) {
        String fileName = "dummy." + CfmlFileType.INSTANCE.getDefaultExtension();
        return (CfmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)CfmlLanguage.INSTANCE, (CharSequence)text);
    }

    @NotNull
    public static CfmlReferenceExpression createReferenceExpression(String text, Project project) {
        CfmlFile dummyFile = CfmlPsiUtil.createDummyFile(project, "<cfset " + text + " = 0>");
        PsiElement tag = dummyFile.getFirstChild();
        assert (tag != null);
        CfmlAssignmentExpression assignment = (CfmlAssignmentExpression)PsiTreeUtil.getChildOfType((PsiElement)tag, CfmlAssignmentExpression.class);
        assert (assignment != null);
        CfmlReferenceExpression expression = (CfmlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)assignment, CfmlReferenceExpression.class);
        assert (expression != null);
        CfmlReferenceExpression cfmlReferenceExpression = expression;
        if (cfmlReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "createReferenceExpression"));
        }
        return cfmlReferenceExpression;
    }

    @NotNull
    public static PsiElement createIdentifier(String text, Project project) {
        CfmlReferenceExpression reference = CfmlPsiUtil.createReferenceExpression(text, project);
        PsiElement identifier = reference.getFirstChild();
        assert (identifier != null);
        ASTNode identifierNode = identifier.getNode();
        assert (identifierNode != null);
        assert (identifierNode.getElementType() == CfscriptTokenTypes.IDENTIFIER);
        PsiElement psiElement = identifier;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "createIdentifier"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createConstantString(String text, Project project) {
        CfmlFile dummyFile = CfmlPsiUtil.createDummyFile(project, "<cffunction name=\"" + text + "\"></cffunction>");
        PsiElement tag = dummyFile.getFirstChild();
        assert (tag != null);
        CfmlAttributeNameImpl namedAttribute = (CfmlAttributeNameImpl)PsiTreeUtil.getChildOfType((PsiElement)tag, CfmlAttributeNameImpl.class);
        assert (namedAttribute != null);
        PsiElement element = namedAttribute.getValueElement();
        assert (element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "createConstantString"));
        }
        return psiElement;
    }

    @Nullable
    public static String getPureAttributeValue(CfmlTag tag, String attributeName) {
        CfmlAttributeImpl[] attributes = (CfmlAttributeImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, CfmlAttributeImpl.class);
        if (attributes == null) {
            return null;
        }
        for (CfmlAttributeImpl attribute : attributes) {
            if (!attributeName.equals(attribute.getAttributeName())) continue;
            return attribute.getPureAttributeValue();
        }
        return null;
    }

    public static boolean isFunctionDefinition(Object element) {
        return element instanceof CfmlFunction || element instanceof CfmlNamedAttributeImpl && ((CfmlNamedAttributeImpl)element).getParent() instanceof CfmlFunction;
    }

    public static CfmlFunction getFunctionDefinition(Object element) {
        if (element instanceof CfmlFunction) {
            return (CfmlFunction)element;
        }
        if (element instanceof CfmlNamedAttributeImpl && ((CfmlNamedAttributeImpl)element).getParent() instanceof CfmlFunction) {
            return (CfmlFunction)((CfmlNamedAttributeImpl)element).getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getAttributeValueElement(PsiElement element, @NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getAttributeValueElement"));
        }
        CfmlAttributeImpl[] attributes = (CfmlAttributeImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)element, CfmlAttributeImpl.class);
        if (attributes == null) {
            return null;
        }
        for (CfmlAttributeImpl attribute : attributes) {
            if (!attributeName.equals(attribute.getAttributeName())) continue;
            return attribute.getValueElement();
        }
        return null;
    }

    @NotNull
    public static PsiReference[] getComponentReferencesFromAttributes(PsiElement element) {
        String implList;
        ASTNode rImplNode;
        PsiElement rEx = CfmlPsiUtil.getAttributeValueElement(element, "extends");
        PsiElement rImpl = CfmlPsiUtil.getAttributeValueElement(element, "implements");
        ASTNode rExNode = rEx != null ? rEx.getNode() : null;
        ASTNode aSTNode = rImplNode = rImpl != null ? rImpl.getNode() : null;
        if (rExNode != null) {
            PsiReference[] psiReferenceArray;
            if (rImplNode == null) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = new CfmlComponentReference(rExNode, element);
            } else {
                PsiReference[] psiReferenceArray3 = new PsiReference[2];
                psiReferenceArray3[0] = new CfmlComponentReference(rExNode, element);
                psiReferenceArray = psiReferenceArray3;
                psiReferenceArray3[1] = new CfmlComponentReference(rImplNode, element);
            }
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getComponentReferencesFromAttributes"));
            }
            return psiReferenceArray;
        }
        if (rImplNode != null && !(implList = rImplNode.getText()).contains(",")) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new CfmlComponentReference(rImplNode, element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getComponentReferencesFromAttributes"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getComponentReferencesFromAttributes"));
        }
        return psiReferenceArray;
    }

    @Nullable
    private static ASTNode getSuperComponentNode(PsiElement element) {
        PsiElement rEx = CfmlPsiUtil.getAttributeValueElement(element, "extends");
        if (rEx != null) {
            return rEx.getNode();
        }
        return null;
    }

    @NotNull
    public static String getSuperComponentName(PsiElement element) {
        ASTNode superComponentNode = CfmlPsiUtil.getSuperComponentNode(element);
        if (superComponentNode != null) {
            String string = superComponentNode.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getSuperComponentName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getSuperComponentName"));
        }
        return "";
    }

    @Nullable
    public static CfmlComponentReference getSuperComponentReference(PsiElement element) {
        ASTNode node = CfmlPsiUtil.getSuperComponentNode(element);
        if (node != null) {
            return new CfmlComponentReference(node, element);
        }
        return null;
    }

    @Nullable
    public static CfmlComponent getSuperComponent(PsiElement element) {
        PsiElement resolve;
        CfmlComponentReference referenceToSuperComponent = CfmlPsiUtil.getSuperComponentReference(element);
        if (referenceToSuperComponent != null && (resolve = referenceToSuperComponent.resolve()) != null && resolve instanceof CfmlComponent) {
            return (CfmlComponent)resolve;
        }
        return null;
    }

    private static <Result extends PsiNamedElement> Result[] componentHierarchyGatherer(CfmlComponent component, Getter<Result[], CfmlComponent> gatherer, Result[] EMPTY_ARRAY, boolean isSuperPriority) {
        CfmlComponent currentComponent;
        HashSet names = new HashSet();
        LinkedList<PsiNamedElement> result = new LinkedList<PsiNamedElement>();
        for (currentComponent = isSuperPriority ? component.getSuper() : component; currentComponent != null; currentComponent = currentComponent.getSuper()) {
            for (PsiNamedElement candidate : (PsiNamedElement[])gatherer.get(currentComponent)) {
                if (!names.add(candidate.getName())) continue;
                result.add(candidate);
            }
        }
        if (isSuperPriority) {
            currentComponent = component;
            for (PsiNamedElement candidate : (PsiNamedElement[])gatherer.get(currentComponent)) {
                if (!names.add(candidate.getName())) continue;
                result.add(candidate);
            }
        }
        return (PsiNamedElement[])result.toArray(EMPTY_ARRAY);
    }

    @NotNull
    public static CfmlFunction[] getFunctionsWithSupers(CfmlComponent component, boolean isSuperPriority) {
        CfmlFunction[] cfmlFunctionArray = (CfmlFunction[])CfmlPsiUtil.componentHierarchyGatherer((CfmlComponent)component, (Getter)new Getter<CfmlFunction[], CfmlComponent>(){

            @Override
            public CfmlFunction[] get(CfmlComponent component) {
                return component.getFunctions();
            }
        }, (PsiNamedElement[])CfmlFunction.EMPTY_ARRAY, (boolean)isSuperPriority);
        if (cfmlFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getFunctionsWithSupers"));
        }
        return cfmlFunctionArray;
    }

    @NotNull
    public static CfmlProperty[] getPropertiesWithSupers(CfmlComponent component, boolean isSuperPriority) {
        CfmlProperty[] cfmlPropertyArray = (CfmlProperty[])CfmlPsiUtil.componentHierarchyGatherer((CfmlComponent)component, (Getter)new Getter<CfmlProperty[], CfmlComponent>(){

            @Override
            public CfmlProperty[] get(CfmlComponent component) {
                return component.getProperties();
            }
        }, (PsiNamedElement[])CfmlProperty.EMPTY_ARRAY, (boolean)isSuperPriority);
        if (cfmlPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlPsiUtil", "getPropertiesWithSupers"));
        }
        return cfmlPropertyArray;
    }

    public static boolean processGlobalVariablesForComponent(CfmlComponent component, final PsiScopeProcessor processor, final ResolveState state, final PsiElement lastParent) {
        boolean res = true;
        try {
            component.accept(new CfmlRecursiveElementVisitor(){

                public void visitCfmlAssignmentExpression(CfmlAssignmentExpression expression) {
                    if (expression.getFirstChild().getNode().getElementType() != CfscriptTokenTypes.VAR_KEYWORD && expression.getParent() != lastParent && expression.getAssignedVariable() != null && !processor.execute((PsiElement)expression.getAssignedVariable(), state)) {
                        throw CfmlRecursiveElementVisitor.Stop.DONE;
                    }
                }

                @Override
                public void visitCfmlComponent(CfmlComponent component) {
                    super.visitElement(component);
                }

                @Override
                public void visitCfmlFunction(CfmlFunction function) {
                    if (function != lastParent) {
                        super.visitCfmlFunction(function);
                    }
                }

                @Override
                public void visitElement(PsiElement element) {
                    if (element != lastParent && element instanceof CfmlAssignmentExpression) {
                        this.visitCfmlAssignmentExpression((CfmlAssignmentExpression)element);
                    } else {
                        super.visitElement(element);
                    }
                }
            });
        }
        catch (CfmlRecursiveElementVisitor.Stop e) {
            res = false;
        }
        return res;
    }

    static {
        OUR_TRANSPARENT_FUNCTIONS.add("cfsilent");
        OUR_TRANSPARENT_FUNCTIONS.add("cfscript");
        OUR_TRANSPARENT_FUNCTIONS.add("cfprocessingdirective");
        OUR_TRANSPARENT_FUNCTIONS.add("cfsavecontent");
        OUR_TRANSPARENT_FUNCTIONS.add("cflock");
    }

    public static interface Getter<T, V> {
        public T get(V var1);
    }
}

