/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.mxunit;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CfmlStackTraceFilterProvider
implements Filter {
    private Project myProject;
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private static final String DISK_PATTERN = "\\p{Alpha}:";
    private static final String FILENAME_PATTERN = "[^:/\\\\]+";
    public static final String EXT_PATTERN = "\\.[\\p{Graph}^:/\\\\\\?]+";
    private static final String LINE_NUM_PATTERN = "(\\d+)";
    private static final String PATTERN = "(?:/|\\\\)[^:]*[^:/\\\\]+(?:\\.[\\p{Graph}^:/\\\\\\?]+)?";
    private static Pattern WIN_MXUNIT_PATTERN_ERROR = Pattern.compile("\\s*((\\p{Alpha}:(?:/|\\\\)[^:]*[^:/\\\\]+(?:\\.[\\p{Graph}^:/\\\\\\?]+)?)[(]((\\d+))[)])[^\n]*\n");
    private static Pattern UNIX_MXUNIT_PATTERN_ERROR = Pattern.compile("\\s*(((?:/|\\\\)[^:]*[^:/\\\\]+(?:\\.[\\p{Graph}^:/\\\\\\?]+)?)[(]((\\d+))[)])[^\n]*\n");

    public CfmlStackTraceFilterProvider(Project project) {
        this.myProject = project;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        int lineNumber;
        Pattern p = WIN_MXUNIT_PATTERN_ERROR;
        Matcher m = p.matcher(line);
        int numberOfReferenceGroup = 0;
        String fileName = "";
        String lineNumberString = "";
        if (!m.find() && !(m = (p = UNIX_MXUNIT_PATTERN_ERROR).matcher(line)).find()) {
            return null;
        }
        numberOfReferenceGroup = 1;
        fileName = m.group(2);
        lineNumberString = m.group(3);
        if (fileName == null) {
            return null;
        }
        final File file = new File(fileName);
        int n = lineNumber = StringUtil.isEmpty((String)lineNumberString) ? 0 : Integer.parseInt(lineNumberString) - 1;
        if (lineNumber == 0) {
            return null;
        }
        final Ref vFile = new Ref();
        if (!file.isFile()) {
            return null;
        }
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    vFile.set((Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file));
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (vFile.isNull()) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        int highlightStartOffset = textStartOffset + m.start(numberOfReferenceGroup);
        int highlightEndOffset = textStartOffset + m.end(numberOfReferenceGroup);
        OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(this.myProject, (VirtualFile)vFile.get(), lineNumber);
        TextAttributes attributes = HYPERLINK_ATTRIBUTES.clone();
        if (!ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent((VirtualFile)vFile.get())) {
            Color color = UIUtil.getInactiveTextColor();
            attributes.setForegroundColor(color);
            attributes.setEffectColor(color);
        }
        return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)info, attributes);
    }
}

