/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
        }
        Project project = parent.getProject();
        if (project == null) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (parent instanceof ProjectViewModuleGroupNode) {
            List modifiedChildren = ContainerUtil.newSmartList();
            for (Object child : children) {
                if (child instanceof ProjectViewModuleNode) {
                    Module module = (Module)((ProjectViewModuleNode)child).getValue();
                    if (!GradleTreeStructureProvider.showUnderModuleGroup(module)) continue;
                    GradleProjectViewModuleNode sourceSetNode = GradleTreeStructureProvider.getGradleSourceSetNode(project, (ProjectViewModuleNode)child, settings);
                    child = sourceSetNode != null ? sourceSetNode : child;
                } else if (child instanceof PsiDirectoryNode) {
                    GradleSourceSetDirectoryNode sourceSetNode = GradleTreeStructureProvider.getGradleSourceSetNode(project, (PsiDirectoryNode)child, settings);
                    if (sourceSetNode != null && !GradleTreeStructureProvider.showUnderModuleGroup(sourceSetNode.myModule)) continue;
                    child = sourceSetNode != null ? sourceSetNode : child;
                }
                modifiedChildren.add(child);
            }
            List list = modifiedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return list;
        }
        if (parent instanceof GradleProjectViewModuleNode) {
            Module module = (Module)((GradleProjectViewModuleNode)parent).getValue();
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            List modifiedChildren = ContainerUtil.newSmartList();
            for (AbstractTreeNode child : children) {
                PsiDirectory psiDirectory;
                if (child instanceof PsiDirectoryNode && (psiDirectory = (PsiDirectory)((PsiDirectoryNode)child).getValue()) != null) {
                    VirtualFile virtualFile = psiDirectory.getVirtualFile();
                    if (projectPath != null && FileUtil.isAncestor((String)projectPath, (String)virtualFile.getPath(), (boolean)false)) continue;
                }
                modifiedChildren.add(child);
            }
            List list = modifiedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return list;
        }
        if (parent instanceof PsiDirectoryNode) {
            List modifiedChildren = ContainerUtil.newSmartList();
            for (Object child : children) {
                if (child instanceof PsiDirectoryNode) {
                    GradleSourceSetDirectoryNode sourceSetNode = GradleTreeStructureProvider.getGradleSourceSetNode(project, (PsiDirectoryNode)child, settings);
                    child = sourceSetNode != null ? sourceSetNode : child;
                }
                modifiedChildren.add(child);
            }
            List list = modifiedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return list;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
        }
        return collection;
    }

    @Nullable
    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    private static boolean showUnderModuleGroup(Module module) {
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (projectPath == null || FileUtil.isAncestor((String)projectPath, (String)root.getPath(), (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static GradleProjectViewModuleNode getGradleSourceSetNode(@NotNull Project project, @NotNull ProjectViewModuleNode moduleNode, ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleSourceSetNode"));
        }
        if (moduleNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleSourceSetNode"));
        }
        Module module = (Module)moduleNode.getValue();
        String sourceSetName = GradleTreeStructureProvider.getSourceSetName(module);
        if (sourceSetName == null) {
            return null;
        }
        return new GradleProjectViewModuleNode(project, module, settings);
    }

    @Nullable
    private static GradleSourceSetDirectoryNode getGradleSourceSetNode(@NotNull Project project, @NotNull PsiDirectoryNode directoryNode, ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleSourceSetNode"));
        }
        if (directoryNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryNode", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleSourceSetNode"));
        }
        PsiDirectory psiDirectory = (PsiDirectory)directoryNode.getValue();
        if (psiDirectory == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (!ProjectRootsUtil.isModuleContentRoot((VirtualFile)virtualFile, (Project)project)) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(virtualFile);
        String sourceSetName = GradleTreeStructureProvider.getSourceSetName(module);
        if (sourceSetName == null) {
            return null;
        }
        return new GradleSourceSetDirectoryNode(project, psiDirectory, settings, module, sourceSetName);
    }

    @Nullable
    private static String getSourceSetName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if (!"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        int i = externalProjectId.lastIndexOf(58);
        if (i == -1 || externalProjectId.length() < i + 1) {
            return null;
        }
        return externalProjectId.substring(i + 1);
    }

    private static class GradleProjectViewModuleNode
    extends ProjectViewModuleNode {
        public GradleProjectViewModuleNode(Project project, Module value, ViewSettings viewSettings) {
            super(project, value, viewSettings);
        }

        public void update(PresentationData presentation) {
            super.update(presentation);
            String sourceSetName = GradleTreeStructureProvider.getSourceSetName((Module)this.getValue());
            if (sourceSetName != null) {
                presentation.setPresentableText(sourceSetName);
                presentation.addText(sourceSetName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }

        protected boolean showModuleNameInBold() {
            return false;
        }
    }

    private static class GradleSourceSetDirectoryNode
    extends PsiDirectoryNode {
        private String mySourceSetName;
        private Module myModule;

        public GradleSourceSetDirectoryNode(Project project, PsiDirectory psiDirectory, ViewSettings settings, Module module, String sourceSetName) {
            super(project, psiDirectory, settings);
            this.mySourceSetName = sourceSetName;
            this.myModule = module;
        }

        protected boolean shouldShowModuleName() {
            return false;
        }

        protected void updateImpl(PresentationData data) {
            super.updateImpl(data);
            PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
            assert (psiDirectory != null);
            VirtualFile directoryFile = psiDirectory.getVirtualFile();
            if (StringUtil.isNotEmpty((String)this.mySourceSetName) && !StringUtil.equalsIgnoreCase((CharSequence)this.mySourceSetName.replace("-", ""), (CharSequence)directoryFile.getName().replace("-", ""))) {
                data.addText("[" + this.mySourceSetName + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    }
}

