/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Order(value=-2147483646)
public class GradleSourceSetDataService
extends AbstractModuleDataService<GradleSourceSetData> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        Key<GradleSourceSetData> key = GradleSourceSetData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "getTargetDataKey"));
        }
        return key;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(final @NotNull Collection<DataNode<GradleSourceSetData>> toImport, final @NotNull ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        Computable<Collection<Module>> computable = new Computable<Collection<Module>>(){

            public Collection<Module> compute() {
                List orphanIdeModules = ContainerUtil.newSmartList();
                for (Module module : modelsProvider.getModules()) {
                    String projectId;
                    DataNode found;
                    if (module.isDisposed() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) || !"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) continue;
                    String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                    if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || (found = (DataNode)ContainerUtil.find((Iterable)toImport, (Condition)new Condition<DataNode<GradleSourceSetData>>(projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module)){
                        final /* synthetic */ String val$projectId;
                        {
                            this.val$projectId = string;
                        }

                        public boolean value(DataNode<GradleSourceSetData> node) {
                            return ((GradleSourceSetData)((Object)node.getData())).getId().equals(this.val$projectId);
                        }
                    })) != null) continue;
                    orphanIdeModules.add(module);
                }
                return orphanIdeModules;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        return computable;
    }

    protected void setModuleOptions(Module module, DataNode<GradleSourceSetData> moduleDataNode) {
        super.setModuleOptions(module, moduleDataNode);
        module.setOption("external.system.module.type", "sourceSet");
    }
}

