/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringComponentScanModel<T extends SpringBeansPackagesScan>
extends ComponentScanPackagesModel {
    private final Set<String> myActiveProfiles;
    private volatile CachedValue<Collection<SpringBeanPointer>> myScannedBeans;
    private final T myComponentScan;

    public SpringComponentScanModel(@NotNull Module module, final @NotNull T componentScan, Set<String> activeProfiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/SpringComponentScanModel", "<init>"));
        }
        if (componentScan == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentScan", "com/intellij/spring/contexts/model/SpringComponentScanModel", "<init>"));
        }
        super(new NotNullLazyValue<Set<PsiPackage>>(){

            @NotNull
            protected Set<PsiPackage> compute() {
                Set<PsiPackage> set = componentScan.getPsiPackages();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringComponentScanModel$1", "compute"));
                }
                return set;
            }
        }, module);
        this.myComponentScan = componentScan;
        this.myActiveProfiles = activeProfiles;
    }

    @Override
    public Collection<SpringBeanPointer> getLocalBeans() {
        PsiElement psiElement = this.myComponentScan.getIdentifyingPsiElement();
        if (psiElement == null) {
            return Collections.emptySet();
        }
        if (this.myScannedBeans == null) {
            this.myScannedBeans = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Collection<SpringBeanPointer>>(){

                @Nullable
                public CachedValueProvider.Result<Collection<SpringBeanPointer>> compute() {
                    Collection<SpringBeanPointer> pointers = SpringComponentScanModel.this.calculateLocalBeans();
                    return CachedValueProvider.Result.create(pointers, (Object[])SpringModificationTrackersManager.getInstance(SpringComponentScanModel.this.getModule().getProject()).getOuterModelsDependencies());
                }
            }, false);
        }
        return (Collection)this.myScannedBeans.getValue();
    }

    @Override
    protected Collection<SpringBeanPointer> calculateScannedBeans() {
        Set<CommonSpringBean> elements = this.myComponentScan.getScannedElements(this.getModule());
        List<CommonSpringBean> inActiveProfiles = SpringProfileUtils.filterBeansInActiveProfiles(elements, this.myActiveProfiles);
        return BeanService.getInstance().mapSpringBeans(inActiveProfiles);
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringComponentScanModel", "getActiveProfiles"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set<PsiFile> set = Collections.singleton(this.myComponentScan.getContainingFile());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringComponentScanModel", "getConfigFiles"));
        }
        return set;
    }

    @Override
    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/SpringComponentScanModel", "hasConfigFile"));
        }
        return this.getConfigFiles().contains(configFile);
    }
}

