/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringMetaStereotypeComponent
extends SpringStereotypeElement {
    private static final NullableFunction<PsiClass, String> PSI_CLASS_FQN = new NullableFunction<PsiClass, String>(){

        public String fun(PsiClass psiClass) {
            return psiClass.getQualifiedName();
        }
    };
    @Nullable
    private final String myAnno;
    private final PsiAnchor myPsiClassAnchor;

    public SpringMetaStereotypeComponent(@NotNull PsiClass psiClassAnchor) {
        if (psiClassAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassAnchor", "com/intellij/spring/model/jam/stereotype/SpringMetaStereotypeComponent", "<init>"));
        }
        this(null, psiClassAnchor);
    }

    public SpringMetaStereotypeComponent(@Nullable String anno, @NotNull PsiClass psiClassAnchor) {
        if (psiClassAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassAnchor", "com/intellij/spring/model/jam/stereotype/SpringMetaStereotypeComponent", "<init>"));
        }
        super(anno);
        this.myAnno = anno;
        this.myPsiClassAnchor = PsiAnchor.create((PsiElement)psiClassAnchor);
    }

    protected static Collection<String> getAnnotations(@Nullable Module module, @NotNull String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/model/jam/stereotype/SpringMetaStereotypeComponent", "getAnnotations"));
        }
        if (module == null) {
            return Collections.singleton(annotation);
        }
        Collection<PsiClass> classes = JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren(annotation);
        return ContainerUtil.mapNotNull(classes, PSI_CLASS_FQN);
    }

    @Override
    @NotNull
    public PsiClass getPsiElement() {
        PsiElement element = this.myPsiClassAnchor.retrieve();
        if (element == null) {
            String msg = this.myPsiClassAnchor instanceof PsiAnchor.StubIndexReference ? ((PsiAnchor.StubIndexReference)this.myPsiClassAnchor).diagnoseNull() : "Anchor hasn't survived: " + this.myPsiClassAnchor;
            throw new RuntimeException(msg);
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringMetaStereotypeComponent", "getPsiElement"));
        }
        return psiClass;
    }

    @Override
    public boolean isValid() {
        PsiElement psiElement = this.myPsiClassAnchor.retrieve();
        return psiElement != null && psiElement.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringMetaStereotypeComponent)) {
            return false;
        }
        SpringMetaStereotypeComponent that = (SpringMetaStereotypeComponent)o;
        if (this.myAnno != null ? !this.myAnno.equals(that.myAnno) : that.myAnno != null) {
            return false;
        }
        return !(this.myPsiClassAnchor != null ? !this.myPsiClassAnchor.equals(that.myPsiClassAnchor) : that.myPsiClassAnchor != null);
    }

    public int hashCode() {
        int result = this.myAnno != null ? this.myAnno.hashCode() : 0;
        result = 31 * result + (this.myPsiClassAnchor != null ? this.myPsiClassAnchor.hashCode() : 0);
        return result;
    }
}

