/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.factories.CustomFactoryMethodTypeHandler;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.ConstructorArgumentValues;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringDomProfile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomSpringBean
implements CommonSpringBean {
    private CachedValue<PsiClass> myClassCachedValue;
    private CachedValue<PsiClass> myFactoriesClassCachedValue;

    @Override
    @NameValue
    @Nullable
    public abstract String getBeanName();

    @Nullable
    public GenericValue<PsiMethod> getFactoryMethod() {
        return null;
    }

    @Nullable
    public GenericValue<SpringBeanPointer> getFactoryBean() {
        return null;
    }

    @Nullable
    public abstract String getClassName();

    @Override
    @Nullable
    public final PsiClass getBeanClass() {
        return this.getBeanClass(null, true);
    }

    @Override
    @Nullable
    public PsiClass getBeanClass(boolean considerFactories) {
        return this.getBeanClass(null, considerFactories);
    }

    @Nullable
    public abstract Module getModule();

    @NotNull
    public abstract PsiFile getContainingFile();

    @Nullable
    public PsiClass getBeanClass(@Nullable Set<AbstractDomSpringBean> visited, boolean considerFactories) {
        if (visited != null && visited.contains(this)) {
            return null;
        }
        if (considerFactories) {
            if (this.myFactoriesClassCachedValue == null) {
                this.myFactoriesClassCachedValue = CachedValuesManager.getManager((Project)this.getContainingFile().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiClass>(){

                    @Nullable
                    public CachedValueProvider.Result<PsiClass> compute() {
                        PsiClass beanClass = AbstractDomSpringBean.calculateFactoriesBeanClass(AbstractDomSpringBean.this);
                        return CachedValueProvider.Result.createSingleDependency((Object)beanClass, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                    }
                });
            }
            return (PsiClass)this.myFactoriesClassCachedValue.getValue();
        }
        return this.getClassAttributeValue();
    }

    public PsiClass getClassAttributeValue() {
        if (this.myClassCachedValue == null) {
            this.myClassCachedValue = CachedValuesManager.getManager((Project)this.getContainingFile().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiClass>(){

                @Nullable
                public CachedValueProvider.Result<PsiClass> compute() {
                    PsiClass beanClass = AbstractDomSpringBean.calculateBeanClass(AbstractDomSpringBean.this);
                    return CachedValueProvider.Result.createSingleDependency((Object)beanClass, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                }
            });
        }
        return (PsiClass)this.myClassCachedValue.getValue();
    }

    @Nullable
    private static PsiClass calculateFactoriesBeanClass(@NotNull AbstractDomSpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/xml/AbstractDomSpringBean", "calculateFactoriesBeanClass"));
        }
        GenericValue<PsiMethod> value = springBean.getFactoryMethod();
        PsiMethod factoryMethod = value == null ? null : (PsiMethod)value.getValue();
        GenericValue<SpringBeanPointer> factoryBean = springBean.getFactoryBean();
        if (factoryMethod != null && SpringFactoryBeansManager.getInstance().isValidFactoryMethod(factoryMethod, factoryBean != null && factoryBean.getValue() != null)) {
            PsiType returnType = factoryMethod.getReturnType();
            for (CustomFactoryMethodTypeHandler typeHandler : (CustomFactoryMethodTypeHandler[])CustomFactoryMethodTypeHandler.EP_NAME.getExtensions()) {
                PsiType factoryMethodType = typeHandler.getFactoryMethodType(factoryMethod, springBean);
                if (!(factoryMethodType instanceof PsiClassType)) continue;
                return ((PsiClassType)factoryMethodType).resolve();
            }
            if (returnType instanceof PsiClassType) {
                PsiTypeParameter[] typeParameters = factoryMethod.getTypeParameters();
                PsiClass resolve = ((PsiClassType)returnType).resolve();
                if (resolve == null) {
                    return null;
                }
                if (!(springBean instanceof SpringBean)) {
                    return resolve;
                }
                for (PsiTypeParameter typeParameter : typeParameters) {
                    if (!typeParameter.equals(resolve)) continue;
                    String text = "java.lang.Class<" + typeParameter.getName() + ">";
                    PsiParameter[] parameters = factoryMethod.getParameterList().getParameters();
                    int length = parameters.length;
                    for (int i = 0; i < length; ++i) {
                        String rawText;
                        PsiParameter psiParameter = parameters[i];
                        PsiType type = psiParameter.getType();
                        if (!type.getCanonicalText().equals(text)) continue;
                        ConstructorArgumentValues values = new ConstructorArgumentValues();
                        values.init((SpringBean)((Object)springBean));
                        ConstructorArgDefinition definition = values.resolve(i, psiParameter, null);
                        if (definition == null) continue;
                        GenericDomValue<?> valueElement = definition.getValueElement();
                        String string = rawText = valueElement == null ? null : valueElement.getRawText();
                        if (rawText == null) continue;
                        return DomJavaUtil.findClass((String)rawText, (PsiFile)springBean.getContainingFile(), (Module)springBean.getModule(), null);
                    }
                    return resolve;
                }
                return resolve;
            }
        }
        return AbstractDomSpringBean.calculateBeanClass(springBean);
    }

    @Nullable
    private static PsiClass calculateBeanClass(@NotNull AbstractDomSpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/xml/AbstractDomSpringBean", "calculateBeanClass"));
        }
        String className = springBean.getClassName();
        XmlTag psiElement = springBean.getXmlTag();
        if (className == null || psiElement == null) {
            return null;
        }
        PsiFile containingFile = springBean.getContainingFile();
        GlobalSearchScope scope = ClassValueConverter.getScope((Project)psiElement.getProject(), (Module)springBean.getModule(), (PsiFile)containingFile);
        return DomJavaUtil.findClass((String)className.trim(), (PsiFile)containingFile, null, (GlobalSearchScope)scope);
    }

    @Override
    public SpringQualifier getSpringQualifier() {
        return null;
    }

    @Override
    @NotNull
    public SpringProfile getProfile() {
        SpringDomProfile profile;
        Beans beans = this.getBeansParent();
        if (beans != null && DomUtil.hasXml((DomElement)(profile = beans.getProfile()))) {
            SpringDomProfile springDomProfile = profile;
            if (springDomProfile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/AbstractDomSpringBean", "getProfile"));
            }
            return springDomProfile;
        }
        SpringProfile springProfile = SpringProfile.DEFAULT;
        if (springProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/AbstractDomSpringBean", "getProfile"));
        }
        return springProfile;
    }

    @Nullable
    public abstract Beans getBeansParent();

    @Override
    public boolean isPrimary() {
        return false;
    }
}

