/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeHolderUtil {
    private static final Key<CachedValue<List<PsiType>>> TYPE_HOLDER_TYPES = Key.create((String)"TYPE_HOLDER_TYPES");

    private TypeHolderUtil() {
    }

    @Nullable
    public static PsiType getRequiredType(@NotNull TypeHolder typeHolder) {
        if (typeHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHolder", "com/intellij/spring/model/xml/beans/TypeHolderUtil", "getRequiredType"));
        }
        List<PsiType> psiTypes = TypeHolderUtil.getRequiredTypes(typeHolder);
        return (PsiType)ContainerUtil.getFirstItem(psiTypes);
    }

    @NotNull
    public static List<PsiType> getRequiredTypes(final @NotNull TypeHolder typeHolder) {
        if (typeHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHolder", "com/intellij/spring/model/xml/beans/TypeHolderUtil", "getRequiredTypes"));
        }
        if (!DomUtil.hasXml((DomElement)typeHolder) || !typeHolder.isValid()) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/TypeHolderUtil", "getRequiredTypes"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)typeHolder.getManager().getProject()).getCachedValue((UserDataHolder)typeHolder, TYPE_HOLDER_TYPES, (CachedValueProvider)new CachedValueProvider<List<PsiType>>(){

            @Nullable
            public CachedValueProvider.Result<List<PsiType>> compute() {
                List<PsiType> requiredTypes = typeHolder.getRequiredTypes();
                return CachedValueProvider.Result.create(requiredTypes, (Object[])new Object[]{DomUtil.getFile((DomElement)typeHolder)});
            }
        }, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/TypeHolderUtil", "getRequiredTypes"));
        }
        return list;
    }

    @Nullable
    public static PsiClassType getRequiredClassType(@NotNull TypeHolder typeHolder) {
        if (typeHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHolder", "com/intellij/spring/model/xml/beans/TypeHolderUtil", "getRequiredClassType"));
        }
        PsiType injectionType = TypeHolderUtil.getRequiredType(typeHolder);
        if (injectionType instanceof PsiClassType) {
            return (PsiClassType)injectionType;
        }
        return null;
    }
}

