/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseFamilyId {
    public static final DatabaseFamilyId UNKNOWN = new DatabaseFamilyId("UNKNOWN");
    public static final DatabaseFamilyId ORACLE = new DatabaseFamilyId("ORACLE");
    public static final DatabaseFamilyId MYSQL = new DatabaseFamilyId("MYSQL");
    public static final DatabaseFamilyId POSTGRES = new DatabaseFamilyId("POSTGRES");
    public static final DatabaseFamilyId MSSQL = new DatabaseFamilyId("MSSQL");
    public static final DatabaseFamilyId SYBASE = new DatabaseFamilyId("SYBASE");
    public static final DatabaseFamilyId DB2 = new DatabaseFamilyId("DB2");
    public static final DatabaseFamilyId SQLITE = new DatabaseFamilyId("SQLITE");
    public static final DatabaseFamilyId HSQLDB = new DatabaseFamilyId("HSQLDB");
    public static final DatabaseFamilyId H2 = new DatabaseFamilyId("H2");
    public static final DatabaseFamilyId DERBY = new DatabaseFamilyId("DERBY");
    private final String myName;

    public DatabaseFamilyId(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/DatabaseFamilyId", "<init>"));
        }
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public boolean isOracle() {
        return this == ORACLE;
    }

    public boolean isMysql() {
        return this == MYSQL;
    }

    public boolean isPostgres() {
        return this == POSTGRES;
    }

    public boolean isMicrosoft() {
        return this == MSSQL;
    }

    public boolean isSybase() {
        return this == SYBASE;
    }

    public boolean isDb2() {
        return this == DB2;
    }

    public boolean isHsqldb() {
        return this == HSQLDB;
    }

    public boolean isH2() {
        return this == H2;
    }

    public boolean isDerby() {
        return this == DERBY;
    }

    public boolean isSqlite() {
        return this == SQLITE;
    }

    public boolean isTransactSql() {
        return this.isMicrosoft() || this.isSybase();
    }

    @NotNull
    public static DatabaseFamilyId forDataSource(@NotNull DatabaseSystem o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/DatabaseFamilyId", "forDataSource"));
        }
        DatabaseFamilyId result = DatabaseFamilyId.fromString(o.getDatabaseProductName());
        if (result != UNKNOWN) {
            DatabaseFamilyId databaseFamilyId = result;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forDataSource"));
            }
            return databaseFamilyId;
        }
        if (o instanceof RawConnectionConfig) {
            result = DatabaseFamilyId.forConnection((RawConnectionConfig)((Object)o));
        }
        DatabaseFamilyId databaseFamilyId = result;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forDataSource"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId forConnection(@NotNull RawConnectionConfig o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/DatabaseFamilyId", "forConnection"));
        }
        DatabaseFamilyId result = DatabaseFamilyId.fromString(o.getUrl());
        if (result != UNKNOWN) {
            DatabaseFamilyId databaseFamilyId = result;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forConnection"));
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.fromString(o.getDriverClass());
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forConnection"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId fromString(@Nullable String text) {
        if (text == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"oracle")) {
            DatabaseFamilyId databaseFamilyId = ORACLE;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"MySQL")) {
            DatabaseFamilyId databaseFamilyId = MYSQL;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"postgres")) {
            DatabaseFamilyId databaseFamilyId = POSTGRES;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"microsoft") || StringUtil.containsIgnoreCase((String)text, (String)"sqlserver")) {
            DatabaseFamilyId databaseFamilyId = MSSQL;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"sybase") || text.startsWith("ASE") || StringUtil.containsIgnoreCase((String)text, (String)"Adaptive Server")) {
            DatabaseFamilyId databaseFamilyId = SYBASE;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"DB2")) {
            DatabaseFamilyId databaseFamilyId = DB2;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"HSQL")) {
            DatabaseFamilyId databaseFamilyId = HSQLDB;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"H2")) {
            DatabaseFamilyId databaseFamilyId = H2;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"Derby")) {
            DatabaseFamilyId databaseFamilyId = DERBY;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (StringUtil.containsIgnoreCase((String)text, (String)"SQLite")) {
            DatabaseFamilyId databaseFamilyId = SQLITE;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = UNKNOWN;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
        }
        return databaseFamilyId;
    }
}

